/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.sql.SQLException;
import java.sql.ShardingKey;
import java.time.Duration;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import javax.net.ssl.SSLContext;
import javax.sql.XAConnection;
import javax.sql.XAConnectionBuilder;
import oracle.jdbc.OracleShardingKey;
import oracle.ucp.jdbc.BorrowContextUpdater;
import oracle.ucp.jdbc.BorrowContextUpdaterGetter;
import oracle.ucp.jdbc.PoolDataSource;
import oracle.ucp.jdbc.UCPConnectionBuilderImpl;
import oracle.ucp.jdbc.UCPXAConnectionBuilder;
import oracle.ucp.logging.annotations.Blind;
import oracle.ucp.util.OpaqueString;

public abstract class UCPXAConnectionBuilderImpl
implements UCPXAConnectionBuilder,
BorrowContextUpdaterGetter {
    protected Executor executor = ForkJoinPool.commonPool();
    private final BorrowContextUpdater borrowContextUpdater;

    @Override
    public BorrowContextUpdater getBorrowContextUpdater() {
        return this.borrowContextUpdater;
    }

    UCPXAConnectionBuilderImpl() {
        this.borrowContextUpdater = new BorrowContextUpdater();
    }

    UCPXAConnectionBuilderImpl(UCPXAConnectionBuilderImpl builder) {
        this.borrowContextUpdater = Objects.isNull(builder) ? new BorrowContextUpdater() : new BorrowContextUpdater(builder.getBorrowContextUpdater());
    }

    UCPXAConnectionBuilderImpl(UCPConnectionBuilderImpl builder) {
        this.borrowContextUpdater = Objects.isNull(builder) ? new BorrowContextUpdater() : new BorrowContextUpdater(builder.getBorrowContextUpdater());
    }

    @Override
    public UCPXAConnectionBuilder user(String user) {
        this.borrowContextUpdater.user(user);
        return this;
    }

    @Override
    public UCPXAConnectionBuilder password(@Blind String password) {
        this.borrowContextUpdater.password(OpaqueString.newOpaqueString(password));
        return this;
    }

    UCPXAConnectionBuilder internalPassword(OpaqueString password) {
        this.borrowContextUpdater.password(password);
        return this;
    }

    @Override
    public UCPXAConnectionBuilder labels(Properties labels) {
        this.borrowContextUpdater.labels(labels);
        return this;
    }

    @Override
    public UCPXAConnectionBuilder serviceName(String serviceName) {
        this.borrowContextUpdater.serviceName(null == serviceName ? null : serviceName.toLowerCase());
        return this;
    }

    @Override
    public UCPXAConnectionBuilder proxyProperties(int proxyType, Properties proxyProperties) {
        this.borrowContextUpdater.proxyProperties(proxyType, proxyProperties);
        return this;
    }

    @Override
    public UCPXAConnectionBuilder shardingKey(OracleShardingKey shardingKey) {
        this.borrowContextUpdater.shardingKey(shardingKey);
        return this;
    }

    @Override
    public XAConnectionBuilder shardingKey(ShardingKey shardingKey) {
        return this.shardingKey((OracleShardingKey)shardingKey);
    }

    @Override
    public UCPXAConnectionBuilder superShardingKey(OracleShardingKey superShardingKey) {
        this.borrowContextUpdater.superShardingKey(superShardingKey);
        return this;
    }

    @Override
    public XAConnectionBuilder superShardingKey(ShardingKey superShardingKey) {
        return this.superShardingKey((OracleShardingKey)superShardingKey);
    }

    @Override
    public UCPXAConnectionBuilder pdbRoles(Properties pdbRoles) {
        this.borrowContextUpdater.pdbRoles(pdbRoles);
        return this;
    }

    UCPXAConnectionBuilder sslContext(SSLContext sslContext) {
        this.borrowContextUpdater.sslContext(sslContext);
        return this;
    }

    UCPXAConnectionBuilder hostnameResolver(PoolDataSource.HostnameResolver hostnameResolver) {
        this.borrowContextUpdater.hostnameResolver(hostnameResolver);
        return this;
    }

    UCPXAConnectionBuilder readOnlyInstanceAllowed(boolean readOnlyInstanceAllowed) {
        this.borrowContextUpdater.readOnlyInstanceAllowed(readOnlyInstanceAllowed);
        return this;
    }

    @Override
    public abstract XAConnection build() throws SQLException;

    @Override
    public UCPXAConnectionBuilder executor(Executor executor) {
        if (Objects.isNull(executor)) {
            throw new IllegalArgumentException("executor should not be null");
        }
        this.executor = executor;
        return this;
    }

    @Override
    @Deprecated
    public UCPXAConnectionBuilder connectionWaitTimeout(int connectionWaitTimeout) {
        if (connectionWaitTimeout < 0) {
            throw new IllegalArgumentException("connection wait timeout should be >= 0");
        }
        this.borrowContextUpdater.connectionWaitDuration(Duration.ofSeconds(connectionWaitTimeout));
        return this;
    }

    @Override
    public UCPXAConnectionBuilder connectionWaitDuration(Duration connectionWaitDuration) {
        Objects.requireNonNull(connectionWaitDuration);
        if (connectionWaitDuration.isNegative()) {
            throw new IllegalArgumentException("connection wait duration should be 0 or positive");
        }
        this.borrowContextUpdater.connectionWaitDuration(connectionWaitDuration);
        return this;
    }
}

