/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.admin;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import javax.management.modelmbean.RequiredModelMBean;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalConnectionPoolAdapter;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalConnectionPoolLifeCycleState;
import oracle.ucp.admin.PoolMBeans;
import oracle.ucp.admin.UniversalConnectionPoolMBean;
import oracle.ucp.admin.UniversalConnectionPoolManager;
import oracle.ucp.admin.UniversalConnectionPoolManagerHelper;
import oracle.ucp.admin.UniversalConnectionPoolManagerImpl;
import oracle.ucp.admin.UniversalConnectionPoolManagerMBean;
import oracle.ucp.common.DiagnosticsSummary;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.Util;

public class UniversalConnectionPoolManagerMBeanImpl
implements UniversalConnectionPoolManagerMBean {
    static final String CLASS_NAME = UniversalConnectionPoolManagerMBeanImpl.class.getName();
    private static UniversalConnectionPoolManagerMBeanImpl m_poolManagerBeanInstance = null;
    private static UniversalConnectionPoolManagerHelper m_poolManagerHelper = null;
    private static UniversalConnectionPoolManager m_poolManagerInstance = null;
    private final ReentrantLock poolMBeanLock = new ReentrantLock();
    private static final ReentrantLock mbeanLock = new ReentrantLock();
    private static MBeanServer m_mbeanServer = (MBeanServer)AccessController.doPrivileged(new PrivilegedAction<Object>(){

        @Override
        public Object run() {
            return UniversalConnectionPoolManagerMBeanImpl.createMBeanServer();
        }
    });

    private UniversalConnectionPoolManagerMBeanImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UniversalConnectionPoolManagerMBean getUniversalConnectionPoolManagerMBean() throws UniversalConnectionPoolException {
        mbeanLock.lock();
        try {
            m_poolManagerInstance = UniversalConnectionPoolManagerImpl.getUniversalConnectionPoolManager(DiagnosticsCollectorImpl.getCommon());
            if (m_mbeanServer != null) {
                if (m_poolManagerBeanInstance == null) {
                    m_poolManagerBeanInstance = new UniversalConnectionPoolManagerMBeanImpl();
                    String objectName = "oracle.ucp.admin:name=UniversalConnectionPoolManagerMBean(" + UniversalConnectionPoolManagerMBeanImpl.class.hashCode() + ")";
                    String beanDisplayName = "UniversalConnectionPoolManagerMBean";
                    String objectReference = "ObjectReference";
                    final ObjectName name = new ObjectName(objectName);
                    ModelMBeanInfo mbeanInfo = UniversalConnectionPoolManagerMBeanImpl.getMBeanInfo(name, "UniversalConnectionPoolManagerMBean");
                    final RequiredModelMBean rmm = new RequiredModelMBean(mbeanInfo);
                    rmm.setManagedResource(m_poolManagerBeanInstance, "ObjectReference");
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
                            if (!m_mbeanServer.isRegistered(name)) {
                                m_mbeanServer.registerMBean(rmm, name);
                            }
                            return null;
                        }
                    });
                    DiagnosticsCollectorImpl.getCommon().trace(Level.FINE, CLASS_NAME, "getUniversalConnectionPoolManagerMBean", "Universal Connection Pool Manager MBean created", null, null, new Object[0]);
                }
            } else {
                m_poolManagerInstance.setJmxEnabled(false);
            }
        }
        catch (Exception e) {
            UCPErrorHandler.throwUniversalConnectionPoolException(e);
        }
        finally {
            mbeanLock.unlock();
        }
        return m_poolManagerBeanInstance;
    }

    @Override
    public void startConnectionPool(String poolName) throws UniversalConnectionPoolException {
        if (poolName == null) {
            UCPErrorHandler.throwUniversalConnectionPoolException(54);
        }
        try {
            m_poolManagerInstance.startConnectionPool(poolName);
        }
        catch (UniversalConnectionPoolException e) {
            DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "startConnectionPool", "", null, e, new Object[0]);
            throw e;
        }
    }

    @Override
    public void stopConnectionPool(String poolName) throws UniversalConnectionPoolException {
        if (poolName == null) {
            UCPErrorHandler.throwUniversalConnectionPoolException(54);
        }
        try {
            m_poolManagerInstance.stopConnectionPool(poolName);
        }
        catch (UniversalConnectionPoolException e) {
            DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "stopConnectionPool", "", null, e, new Object[0]);
            throw e;
        }
    }

    @Override
    public void refreshConnectionPool(String poolName) throws UniversalConnectionPoolException {
        if (poolName == null) {
            UCPErrorHandler.throwUniversalConnectionPoolException(54);
        }
        try {
            m_poolManagerInstance.refreshConnectionPool(poolName);
        }
        catch (UniversalConnectionPoolException e) {
            DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "refreshConnectionPool", "", null, e, new Object[0]);
            throw e;
        }
    }

    @Override
    public void recycleConnectionPool(String poolName) throws UniversalConnectionPoolException {
        if (poolName == null) {
            UCPErrorHandler.throwUniversalConnectionPoolException(54);
        }
        try {
            m_poolManagerInstance.recycleConnectionPool(poolName);
        }
        catch (UniversalConnectionPoolException e) {
            DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "recycleConnectionPool", "", null, e, new Object[0]);
            throw e;
        }
    }

    @Override
    public void purgeConnectionPool(String poolName) throws UniversalConnectionPoolException {
        if (poolName == null) {
            UCPErrorHandler.throwUniversalConnectionPoolException(54);
        }
        try {
            m_poolManagerInstance.purgeConnectionPool(poolName);
        }
        catch (UniversalConnectionPoolException e) {
            DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "purgeConnectionPool", "", null, e, new Object[0]);
            throw e;
        }
    }

    @Override
    public UniversalConnectionPoolMBean createConnectionPool(UniversalConnectionPoolAdapter ucpAdapter) throws UniversalConnectionPoolException {
        try {
            UniversalConnectionPool pool = ucpAdapter.createUniversalConnectionPool();
            return PoolMBeans.getOrCreateBean(pool);
        }
        catch (Exception e) {
            UCPErrorHandler.throwUniversalConnectionPoolException(386, e);
            return null;
        }
    }

    @Override
    public void destroyConnectionPool(String poolName) throws UniversalConnectionPoolException {
        if (poolName == null) {
            UCPErrorHandler.throwUniversalConnectionPoolException(54);
        }
        PoolMBeans.destroyBean(poolName);
        try {
            m_poolManagerInstance.destroyConnectionPool(poolName);
        }
        catch (UniversalConnectionPoolException e) {
            DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "destroyConnectionPool", "", null, e, new Object[0]);
            throw e;
        }
    }

    @Override
    public void reconfigureConnectionPool(String poolName, Properties configuration) throws UniversalConnectionPoolException {
        if (poolName == null) {
            UCPErrorHandler.throwUniversalConnectionPoolException(54);
        }
        m_poolManagerInstance.reconfigureConnectionPool(poolName, configuration);
    }

    @Override
    public String[] getConnectionPoolNames() throws UniversalConnectionPoolException {
        return m_poolManagerInstance.getConnectionPoolNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerUniversalConnectionPoolMBean(UniversalConnectionPoolMBean poolMBean) throws UniversalConnectionPoolException {
        this.poolMBeanLock.lock();
        try {
            if (poolMBean == null) {
                UCPErrorHandler.throwUniversalConnectionPoolException(380);
            }
            String mbeanDisplayName = "UniversalConnectionPoolMBean";
            String objectReference = "ObjectReference";
            m_poolManagerHelper = new UniversalConnectionPoolManagerHelper(m_poolManagerInstance.getConnectionPool(poolMBean.getName()));
            String uniquePoolID = m_poolManagerHelper.getManagerPoolID();
            String beanName = "oracle.ucp.admin.UniversalConnectionPoolMBean:name=" + uniquePoolID;
            DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "registerUniversalConnectionPoolMBean", "registering  UniversalConnectionPoolMBean {0}  for {1}", null, null, beanName, poolMBean.getName());
            final ObjectName name = new ObjectName(beanName);
            if (m_mbeanServer != null) {
                ModelMBeanInfo mbeanInfo = poolMBean.getMBeanInfo(name, "UniversalConnectionPoolMBean");
                final RequiredModelMBean rmm = new RequiredModelMBean(mbeanInfo);
                rmm.setManagedResource(poolMBean, "ObjectReference");
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
                        if (!m_mbeanServer.isRegistered(name)) {
                            m_mbeanServer.registerMBean(rmm, name);
                        }
                        return null;
                    }
                });
            }
        }
        catch (Exception e) {
            UCPErrorHandler.throwUniversalConnectionPoolException(e);
        }
        finally {
            this.poolMBeanLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterUniversalConnectionPoolMBean(String poolName) throws UniversalConnectionPoolException {
        this.poolMBeanLock.lock();
        try {
            if (poolName == null) {
                UCPErrorHandler.throwUniversalConnectionPoolException(54);
            }
            String objectName = "oracle.ucp.admin.UniversalConnectionPoolMBean:name=";
            m_poolManagerHelper = new UniversalConnectionPoolManagerHelper(m_poolManagerInstance.getConnectionPool(poolName));
            final ObjectName name = new ObjectName("oracle.ucp.admin.UniversalConnectionPoolMBean:name=" + m_poolManagerHelper.getManagerPoolID());
            if (m_mbeanServer != null) {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws InstanceNotFoundException, MBeanRegistrationException {
                        m_mbeanServer.unregisterMBean(name);
                        return null;
                    }
                });
            }
        }
        catch (Exception e) {
            UCPErrorHandler.throwUniversalConnectionPoolException(e);
        }
        finally {
            this.poolMBeanLock.unlock();
        }
    }

    @Override
    public void startMetricsCollection(String poolName) throws UniversalConnectionPoolException {
        if (poolName == null) {
            UCPErrorHandler.throwUniversalConnectionPoolException(54);
        }
        try {
            m_poolManagerInstance.startMetricsCollection(poolName);
        }
        catch (UniversalConnectionPoolException e) {
            DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "startMetricsCollection", "", null, e, new Object[0]);
            throw e;
        }
    }

    @Override
    public void stopMetricsCollection(String poolName) throws UniversalConnectionPoolException {
        if (poolName == null) {
            UCPErrorHandler.throwUniversalConnectionPoolException(54);
        }
        try {
            m_poolManagerInstance.stopMetricsCollection(poolName);
        }
        catch (UniversalConnectionPoolException e) {
            DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "stopMetricsCollection", "", null, e, new Object[0]);
            throw e;
        }
    }

    @Override
    public void setMetricUpdateInterval(Integer interval) throws UniversalConnectionPoolException {
        this.poolMBeanLock.lock();
        try {
            m_poolManagerInstance.setMetricUpdateInterval(interval);
        }
        finally {
            this.poolMBeanLock.unlock();
        }
    }

    @Override
    public Integer getMetricUpdateInterval() {
        return m_poolManagerInstance.getMetricUpdateInterval();
    }

    @Override
    public UniversalConnectionPoolLifeCycleState getConnectionPoolLifeCycleState(String poolName) throws UniversalConnectionPoolException {
        UniversalConnectionPool pool;
        if (poolName == null) {
            UCPErrorHandler.throwUniversalConnectionPoolException(54);
        }
        try {
            pool = m_poolManagerInstance.getConnectionPool(poolName);
        }
        catch (UniversalConnectionPoolException e) {
            DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "getConnectionPoolLifeCycleState", "", null, e, new Object[0]);
            throw e;
        }
        return pool.getLifeCycleState();
    }

    @Override
    public String diagnosticsSummaryPrintout() {
        try {
            String diag = DiagnosticsSummary.collect();
            DiagnosticsCollectorImpl.getCommon().trace(Level.INFO, CLASS_NAME, "desc", "{0}", null, null, diag);
            System.out.println(diag);
            return diag;
        }
        catch (UniversalConnectionPoolException e) {
            DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "desc", "", null, e, new Object[0]);
            return "unable to collect diagnostics summary";
        }
    }

    @Override
    public Boolean getTraceEnabled() {
        return DiagnosticsCollectorImpl.getCommon().getTraceEnabled();
    }

    @Override
    public void setTraceEnabled(Boolean enabled) {
        DiagnosticsCollectorImpl.getCommon().setTraceEnabled(enabled);
    }

    @Override
    public Boolean getLoggingEnabled() {
        return DiagnosticsCollectorImpl.getCommon().getLoggingEnabled();
    }

    @Override
    public void setLoggingEnabled(Boolean enabled) {
        DiagnosticsCollectorImpl.getCommon().setLoggingEnabled(enabled);
    }

    @Override
    public Level getLogLevel() {
        return DiagnosticsCollectorImpl.getCommon().getLogLevel();
    }

    @Override
    public String getLogLevelStr() {
        return DiagnosticsCollectorImpl.getCommon().getLogLevel().getName();
    }

    @Override
    public void setLogLevel(Level level) {
        if (null == level) {
            throw new IllegalArgumentException("log level is null");
        }
        DiagnosticsCollectorImpl.getCommon().setLogLevel(level);
    }

    @Override
    public void setLogLevelStr(String level) {
        if (null == level) {
            throw new IllegalArgumentException("log level is null");
        }
        this.setLogLevel(Level.parse(level));
    }

    @Override
    public Integer getBufferSize() {
        return DiagnosticsCollectorImpl.getCommon().getBufferSize();
    }

    @Override
    public void setBufferSize(Integer size) {
        if (size <= 0) {
            throw new IllegalArgumentException("buffer size should be positive");
        }
        DiagnosticsCollectorImpl.getCommon().setBufferSize(size);
    }

    @Override
    public String getErrorCodesToWatchList() {
        return DiagnosticsCollectorImpl.getErrorCodesToWatchList();
    }

    @Override
    public void setErrorCodesToWatchList(String errorCodesToWatchList) {
        if (null == errorCodesToWatchList) {
            throw new IllegalArgumentException("eeeor codes to watch list is null");
        }
        DiagnosticsCollectorImpl.setErrorCodesToWatchList(errorCodesToWatchList);
    }

    @Override
    public String getLoggingConfigFile() {
        return DiagnosticsCollectorImpl.getLoggingConfigFile();
    }

    @Override
    public void setLoggingConfigFile(String loggingConfigFile) {
        if (null == loggingConfigFile) {
            throw new IllegalArgumentException("logging config file is null");
        }
        DiagnosticsCollectorImpl.setLoggingConfigFile(loggingConfigFile);
    }

    @Override
    public void dumpTraceBuffer() {
        DiagnosticsCollectorImpl.dumpTraceBuffer();
    }

    @Override
    public String getMBeanNameForConnectionPool(String connectionPoolName) throws UniversalConnectionPoolException {
        String beanName = "";
        if (connectionPoolName == null) {
            UCPErrorHandler.throwUniversalConnectionPoolException(54);
        }
        try {
            UniversalConnectionPoolManagerHelper managerHelper = new UniversalConnectionPoolManagerHelper(m_poolManagerInstance.getConnectionPool(connectionPoolName));
            beanName = managerHelper.getManagerPoolID();
        }
        catch (Exception e) {
            UCPErrorHandler.throwUniversalConnectionPoolException(e);
        }
        return beanName;
    }

    private static ModelMBeanInfo getMBeanInfo(ObjectName mbeanObjName, String mbeanManagerDisplayName) throws UniversalConnectionPoolException {
        assert (mbeanObjName != null);
        assert (mbeanManagerDisplayName != null);
        DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "getMBeanInfo", "constructing MBeanInfo", null, null, new Object[0]);
        ModelMBeanInfoSupport modelMBeanInfo = null;
        try {
            String descriptorType = "mbean";
            String mbeanManagerName = "oracle.ucp.admin.UniversalConnectionPoolManagerMBean";
            String mbeanManagerDescription = "UniversalConnectionPoolManagerMBeanImpl Object";
            DescriptorSupport modelMBeanDescriptor = new DescriptorSupport("name=" + String.valueOf(mbeanObjName), "descriptorType=mbean", "displayName=" + mbeanManagerDisplayName);
            modelMBeanInfo = new ModelMBeanInfoSupport("oracle.ucp.admin.UniversalConnectionPoolManagerMBean", "UniversalConnectionPoolManagerMBeanImpl Object", UniversalConnectionPoolManagerMBeanImpl.getAttributesInfo(), UniversalConnectionPoolManagerMBeanImpl.getConstructorsInfo(), UniversalConnectionPoolManagerMBeanImpl.getOperationsInfo(), UniversalConnectionPoolManagerMBeanImpl.getNotificationsInfo());
            modelMBeanInfo.setMBeanDescriptor(modelMBeanDescriptor);
        }
        catch (RuntimeOperationsException e) {
            UCPErrorHandler.throwUniversalConnectionPoolException(361, e);
        }
        catch (MBeanException e) {
            UCPErrorHandler.throwUniversalConnectionPoolException(360, e);
        }
        return modelMBeanInfo;
    }

    private static ModelMBeanConstructorInfo[] getConstructorsInfo() throws UniversalConnectionPoolException {
        ModelMBeanConstructorInfo[] constInfo = new ModelMBeanConstructorInfo[]{};
        return constInfo;
    }

    private static ModelMBeanAttributeInfo[] getAttributesInfo() throws UniversalConnectionPoolException {
        ArrayList<ModelMBeanAttributeInfo> attributes = new ArrayList<ModelMBeanAttributeInfo>();
        DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "getAttributesInfo", "constructing AttributesInfo", null, null, new Object[0]);
        try {
            DescriptorSupport desc = new DescriptorSupport();
            desc.setField("name", "MetricUpdateInterval");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("MetricUpdateIntervalAttrDisplayName"));
            desc.setField("getMethod", "getMetricUpdateInterval");
            desc.setField("setMethod", "setMetricUpdateInterval");
            desc.setField("currencyTimeLimit", "0");
            attributes.add(new ModelMBeanAttributeInfo("MetricUpdateInterval", "java.lang.Integer", UCPErrorHandler.findMessage("MetricUpdateIntervalAttrDescription"), true, true, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "traceEnabled");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("TraceEnabledAttrDisplayName"));
            desc.setField("getMethod", "getTraceEnabled");
            desc.setField("setMethod", "setTraceEnabled");
            attributes.add(new ModelMBeanAttributeInfo("traceEnabled", "java.lang.Boolean", UCPErrorHandler.findMessage("TraceEnabledAttrDescription"), true, true, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "loggingEnabled");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("LoggingEnabledAttrDisplayName"));
            desc.setField("getMethod", "getLoggingEnabled");
            desc.setField("setMethod", "setLoggingEnabled");
            attributes.add(new ModelMBeanAttributeInfo("loggingEnabled", "java.lang.Boolean", UCPErrorHandler.findMessage("LoggingEnabledAttrDescription"), true, true, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "logLevelStr");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("LogLevelAttrDisplayName"));
            desc.setField("getMethod", "getLogLevelStr");
            desc.setField("setMethod", "setLogLevelStr");
            attributes.add(new ModelMBeanAttributeInfo("logLevelStr", "java.lang.String", UCPErrorHandler.findMessage("LogLevelAttrDescription"), true, true, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "logLevel");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("LogLevelAttrDisplayName"));
            desc.setField("getMethod", "getLogLevel");
            desc.setField("setMethod", "setLogLevel");
            attributes.add(new ModelMBeanAttributeInfo("logLevel", "java.util.logging.Level", UCPErrorHandler.findMessage("LogLevelAttrDescription"), true, true, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "bufferSize");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("BufferSizeAttrDisplayName"));
            desc.setField("getMethod", "getBufferSize");
            desc.setField("setMethod", "setBufferSize");
            attributes.add(new ModelMBeanAttributeInfo("bufferSize", "java.lang.Integer", UCPErrorHandler.findMessage("BufferSizeAttrDescription"), true, true, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "errorCodesToWatchList");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("ErrorCodesToWatchListAttrDisplayName"));
            desc.setField("getMethod", "getErrorCodesToWatchList");
            desc.setField("setMethod", "setErrorCodesToWatchList");
            attributes.add(new ModelMBeanAttributeInfo("errorCodesToWatchList", "java.lang.String", UCPErrorHandler.findMessage("ErrorCodesToWatchListAttrDescription"), true, true, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "loggingConfigFile");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("LoggingConfigFileAttrDisplayName"));
            desc.setField("getMethod", "getLoggingConfigFile");
            desc.setField("setMethod", "setLoggingConfigFile");
            attributes.add(new ModelMBeanAttributeInfo("loggingConfigFile", "java.lang.String", UCPErrorHandler.findMessage("LoggingConfigFileAttrDescription"), true, true, false, desc));
        }
        catch (Exception e) {
            UCPErrorHandler.throwUniversalConnectionPoolException(363, e);
        }
        return attributes.toArray(new ModelMBeanAttributeInfo[0]);
    }

    private static ModelMBeanOperationInfo[] getOperationsInfo() throws UniversalConnectionPoolException {
        ArrayList<ModelMBeanOperationInfo> operations = new ArrayList<ModelMBeanOperationInfo>();
        DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "getOperationsInfo", "constructing OperationsInfo", null, null, new Object[0]);
        try {
            String mBeanName = "oracle.ucp.admin.UniversalConnectionPoolManagerMBean";
            DescriptorSupport desc = new DescriptorSupport();
            desc.setField("name", "startConnectionPool");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.UniversalConnectionPoolManagerMBean");
            desc.setField("role", "operation");
            String description = UCPErrorHandler.findMessage("StartConnectionPoolOperationDescription");
            MBeanParameterInfo[] mbeanNameParams = new MBeanParameterInfo[]{new MBeanParameterInfo("connectionPoolName", "java.lang.String", description)};
            operations.add(new ModelMBeanOperationInfo("startConnectionPool", description, mbeanNameParams, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "stopConnectionPool");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.UniversalConnectionPoolManagerMBean");
            desc.setField("role", "operation");
            description = UCPErrorHandler.findMessage("StopConnectionPoolOperationDescription");
            mbeanNameParams = new MBeanParameterInfo[]{new MBeanParameterInfo("connectionPoolName", "java.lang.String", description)};
            operations.add(new ModelMBeanOperationInfo("stopConnectionPool", description, mbeanNameParams, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "destroyConnectionPool");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.UniversalConnectionPoolManagerMBean");
            desc.setField("role", "operation");
            description = UCPErrorHandler.findMessage("DestroyConnectionPoolOperationDescription");
            mbeanNameParams = new MBeanParameterInfo[]{new MBeanParameterInfo("connectionPoolName", "java.lang.String", description)};
            operations.add(new ModelMBeanOperationInfo("destroyConnectionPool", description, mbeanNameParams, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "startMetricsCollection");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.UniversalConnectionPoolManagerMBean");
            desc.setField("role", "operation");
            description = UCPErrorHandler.findMessage("StartMetricCollectionOperationDescription");
            mbeanNameParams = new MBeanParameterInfo[]{new MBeanParameterInfo("connectionPoolName", "java.lang.String", description)};
            operations.add(new ModelMBeanOperationInfo("startMetricsCollection", description, mbeanNameParams, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "stopMetricsCollection");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.UniversalConnectionPoolManagerMBean");
            desc.setField("role", "operation");
            description = UCPErrorHandler.findMessage("StopMetricCollectionOperationDescription");
            mbeanNameParams = new MBeanParameterInfo[]{new MBeanParameterInfo("connectionPoolName", "java.lang.String", description)};
            operations.add(new ModelMBeanOperationInfo("stopMetricsCollection", description, mbeanNameParams, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "refreshConnectionPool");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.UniversalConnectionPoolManagerMBean");
            desc.setField("role", "operation");
            description = UCPErrorHandler.findMessage("RefreshConnectionPoolOperationDescription");
            mbeanNameParams = new MBeanParameterInfo[]{new MBeanParameterInfo("connectionPoolName", "java.lang.String", description)};
            operations.add(new ModelMBeanOperationInfo("refreshConnectionPool", description, mbeanNameParams, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "recycleConnectionPool");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.UniversalConnectionPoolManagerMBean");
            desc.setField("role", "operation");
            description = UCPErrorHandler.findMessage("RecycleConnectionPoolOperationDescription");
            mbeanNameParams = new MBeanParameterInfo[]{new MBeanParameterInfo("connectionPoolName", "java.lang.String", description)};
            operations.add(new ModelMBeanOperationInfo("recycleConnectionPool", description, mbeanNameParams, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "purgeConnectionPool");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.UniversalConnectionPoolManagerMBean");
            desc.setField("role", "operation");
            description = UCPErrorHandler.findMessage("PurgeConnectionPoolOperationDescription");
            mbeanNameParams = new MBeanParameterInfo[]{new MBeanParameterInfo("connectionPoolName", "java.lang.String", description)};
            operations.add(new ModelMBeanOperationInfo("purgeConnectionPool", description, mbeanNameParams, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getConnectionPoolNames");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.UniversalConnectionPoolManagerMBean");
            desc.setField("role", "getter");
            MBeanParameterInfo[] params = null;
            operations.add(new ModelMBeanOperationInfo("getConnectionPoolNames", UCPErrorHandler.findMessage("GetConnectionPoolNamesOperationDescription"), params, "String[]", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getConnectionPoolLifeCycleState");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.UniversalConnectionPoolManagerMBean");
            desc.setField("role", "operation");
            description = UCPErrorHandler.findMessage("GetConnectionPoolLifeCycleStateOperationDescription");
            mbeanNameParams = new MBeanParameterInfo[]{new MBeanParameterInfo("connectionPoolName", "java.lang.String", description)};
            operations.add(new ModelMBeanOperationInfo("getConnectionPoolLifeCycleState", description, mbeanNameParams, "UniversalConnectionPoolLifeCycleState", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getMetricUpdateInterval");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.UniversalConnectionPoolManagerMBean");
            desc.setField("role", "getter");
            params = null;
            operations.add(new ModelMBeanOperationInfo("getMetricUpdateInterval", UCPErrorHandler.findMessage("GetMetricUpdateIntervalOperationDescription"), params, "java.lang.Integer", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "setMetricUpdateInterval");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.UniversalConnectionPoolManagerMBean");
            desc.setField("role", "setter");
            description = UCPErrorHandler.findMessage("SetMetricUpdateIntervalOperationDescription");
            MBeanParameterInfo[] metricIntervalParams = new MBeanParameterInfo[]{new MBeanParameterInfo("interval", "java.lang.Integer", description)};
            operations.add(new ModelMBeanOperationInfo("setMetricUpdateInterval", description, metricIntervalParams, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "createConnectionPool");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.UniversalConnectionPoolManagerMBean");
            desc.setField("role", "operation");
            description = UCPErrorHandler.findMessage("CreateConnectionPoolOperationDescription");
            MBeanParameterInfo[] poolConfigParams = new MBeanParameterInfo[]{new MBeanParameterInfo("ucpAdapter", "oracle.ucp.UniversalConnectionPoolAdapter", description)};
            operations.add(new ModelMBeanOperationInfo("createConnectionPool", description, poolConfigParams, "oracle.ucp.admin.UniversalConnectionPoolMBean", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getMBeanNameForConnectionPool");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.UniversalConnectionPoolManagerMBean");
            desc.setField("role", "operation");
            description = UCPErrorHandler.findMessage("GetMBeanNameForConnectionPool");
            mbeanNameParams = new MBeanParameterInfo[]{new MBeanParameterInfo("connectionPoolName", "java.lang.String", description)};
            operations.add(new ModelMBeanOperationInfo("getMBeanNameForConnectionPool", description, mbeanNameParams, "java.lang.String", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "diagnosticsSummaryPrintout");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.UniversalConnectionPoolManagerMBean");
            desc.setField("role", "operation");
            params = null;
            operations.add(new ModelMBeanOperationInfo("diagnosticsSummaryPrintout", UCPErrorHandler.findMessage("DiagnosticsSummaryPrintout"), params, "java.lang.String", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getTraceEnabled");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.UniversalConnectionPoolManagerMBean");
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getTraceEnabled", UCPErrorHandler.findMessage("GetTraceEnabledOperationDescription"), null, "java.lang.Boolean", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "setTraceEnabled");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.UniversalConnectionPoolManagerMBean");
            desc.setField("role", "setter");
            String sDesc = UCPErrorHandler.findMessage("SetTraceEnabledOperationDescription");
            MBeanParameterInfo[] params2 = new MBeanParameterInfo[]{new MBeanParameterInfo("traceEnabled", "java.lang.Boolean", sDesc)};
            operations.add(new ModelMBeanOperationInfo("setTraceEnabled", sDesc, params2, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getLoggingEnabled");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.UniversalConnectionPoolManagerMBean");
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getLoggingEnabled", UCPErrorHandler.findMessage("GetLoggingEnabledOperationDescription"), null, "java.lang.Boolean", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "setLoggingEnabled");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.UniversalConnectionPoolManagerMBean");
            desc.setField("role", "setter");
            sDesc = UCPErrorHandler.findMessage("SetLoggingEnabledOperationDescription");
            params2 = new MBeanParameterInfo[]{new MBeanParameterInfo("loggingEnabled", "java.lang.Boolean", sDesc)};
            operations.add(new ModelMBeanOperationInfo("setLoggingEnabled", sDesc, params2, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getLogLevelStr");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.UniversalConnectionPoolManagerMBean");
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getLogLevelStr", UCPErrorHandler.findMessage("GetLogLevelOperationDescription"), null, "java.lang.String", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "setLogLevelStr");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.UniversalConnectionPoolManagerMBean");
            desc.setField("role", "setter");
            sDesc = UCPErrorHandler.findMessage("SetLogLevelOperationDescription");
            params2 = new MBeanParameterInfo[]{new MBeanParameterInfo("logLevelStr", "java.lang.String", sDesc)};
            operations.add(new ModelMBeanOperationInfo("setLogLevelStr", sDesc, params2, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getLogLevel");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.UniversalConnectionPoolManagerMBean");
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getLogLevel", UCPErrorHandler.findMessage("GetLogLevelOperationDescription"), null, "java.util.logging.Level", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "setLogLevel");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.UniversalConnectionPoolManagerMBean");
            desc.setField("role", "setter");
            sDesc = UCPErrorHandler.findMessage("SetLogLevelOperationDescription");
            params2 = new MBeanParameterInfo[]{new MBeanParameterInfo("logLevel", "java.util.logging.Level", sDesc)};
            operations.add(new ModelMBeanOperationInfo("setLogLevel", sDesc, params2, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getBufferSize");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.UniversalConnectionPoolManagerMBean");
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getBufferSize", UCPErrorHandler.findMessage("GetBufferSizeOperationDescription"), null, "java.lang.Integer", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "setBufferSize");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.UniversalConnectionPoolManagerMBean");
            desc.setField("role", "setter");
            sDesc = UCPErrorHandler.findMessage("SetBufferSizeOperationDescription");
            params2 = new MBeanParameterInfo[]{new MBeanParameterInfo("bufferSize", "java.lang.Integer", sDesc)};
            operations.add(new ModelMBeanOperationInfo("setBufferSize", sDesc, params2, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getErrorCodesToWatchList");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.UniversalConnectionPoolManagerMBean");
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getErrorCodesToWatchList", UCPErrorHandler.findMessage("GetErrorCodesToWatchListOperationDescription"), null, "java.lang.String", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "setErrorCodesToWatchList");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.UniversalConnectionPoolManagerMBean");
            desc.setField("role", "setter");
            sDesc = UCPErrorHandler.findMessage("SetErrorCodesToWatchListOperationDescription");
            params2 = new MBeanParameterInfo[]{new MBeanParameterInfo("errorCodesToWatchList", "java.lang.String", sDesc)};
            operations.add(new ModelMBeanOperationInfo("setErrorCodesToWatchList", sDesc, params2, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getLoggingConfigFile");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.UniversalConnectionPoolManagerMBean");
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getLoggingConfigFile", UCPErrorHandler.findMessage("GetLoggingConfigFileOperationDescription"), null, "java.lang.String", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "setLoggingConfigFile");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.UniversalConnectionPoolManagerMBean");
            desc.setField("role", "setter");
            sDesc = UCPErrorHandler.findMessage("SetLoggingConfigFileOperationDescription");
            params2 = new MBeanParameterInfo[]{new MBeanParameterInfo("loggingConfigFile", "java.lang.String", sDesc)};
            operations.add(new ModelMBeanOperationInfo("setLoggingConfigFile", sDesc, params2, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "dumpTraceBuffer");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.UniversalConnectionPoolManagerMBean");
            desc.setField("role", "operation");
            sDesc = UCPErrorHandler.findMessage("DumpTraceBufferOperationDescription");
            operations.add(new ModelMBeanOperationInfo("dumpTraceBuffer", sDesc, null, "void", 1, desc));
        }
        catch (RuntimeOperationsException e) {
            UCPErrorHandler.throwUniversalConnectionPoolException(364, e);
        }
        return operations.toArray(new ModelMBeanOperationInfo[0]);
    }

    private static ModelMBeanNotificationInfo[] getNotificationsInfo() throws UniversalConnectionPoolException {
        ModelMBeanNotificationInfo[] notifInfo = new ModelMBeanNotificationInfo[]{};
        return notifInfo;
    }

    private static MBeanServer createMBeanServer() {
        MBeanServer mbeanServer = null;
        try {
            mbeanServer = ManagementFactory.getPlatformMBeanServer();
            DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "createMBeanServer", "returns JDK''s MBeanServer {0}", null, null, mbeanServer);
        }
        catch (Exception e) {
            DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "createMBeanServer", "Cannot create Platform MBean Server", null, null, new Object[0]);
            DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "createMBeanServer", "", null, e, new Object[0]);
        }
        return mbeanServer;
    }

    static {
        try {
            Class<?> cls = Util.getClassForName("oracle.as.jmx.framework.PortableMBeanFactory", true, Thread.currentThread().getContextClassLoader(), UniversalConnectionPoolManagerMBeanImpl.class.getClassLoader());
            Method mthd = cls.getMethod("getMBeanServer", new Class[0]);
            m_mbeanServer = (MBeanServer)mthd.invoke(cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), new Object[0]);
            DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "<clinit>", "AS MBeanServer loaded {0}", null, null, m_mbeanServer);
        }
        catch (Throwable e) {
            DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "<clinit>", "Unable to get OracleAS MBean Server. Continue to use the JDK Platform MBean Server", null, null, new Object[0]);
        }
    }
}

