/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.actors;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;

public class RestartableExecutor
implements Executor {
    private final ReentrantLock startStopLock = new ReentrantLock();
    private volatile ThreadPoolExecutor threadPoolExecutor = null;
    static final String CLASS_NAME = RestartableExecutor.class.getName();

    public void start() {
        try {
            this.startStopLock.lock();
            if (null == this.threadPoolExecutor) {
                this.threadPoolExecutor = new ThreadPoolExecutor(0, 8, 3L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(8), new ThreadPoolExecutor.CallerRunsPolicy());
            }
        }
        finally {
            this.startStopLock.unlock();
        }
    }

    public void stop() {
        try {
            this.startStopLock.lock();
            if (null == this.threadPoolExecutor) {
                return;
            }
            this.threadPoolExecutor.shutdown();
            try {
                if (this.threadPoolExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                    DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "stop", "terminated successfully", null, null, new Object[0]);
                } else {
                    DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "stop", "Waited ThreadPoolExecutor shutdown for 5 seconds, did not end up", null, null, new Object[0]);
                }
            }
            catch (InterruptedException e) {
                DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "stop", "", null, e, new Object[0]);
            }
            this.threadPoolExecutor = null;
        }
        finally {
            this.startStopLock.unlock();
        }
    }

    @Override
    public void execute(Runnable runnable) {
        ThreadPoolExecutor tpe = this.threadPoolExecutor;
        if (null == tpe) {
            throw new IllegalStateException("thread pool executor not started");
        }
        tpe.execute(runnable);
    }
}

