/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgview.translation;

import java.util.List;
import java.util.Set;
import oracle.pg.rdbms.pgql.PgqlUtils;
import oracle.pg.rdbms.pgql.pgview.translation.GraphPatternTranslator;
import oracle.pgql.lang.ir.ExpAsVar;
import oracle.pgql.lang.ir.GraphPattern;
import oracle.pgql.lang.ir.OrderByElem;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.QueryExpressionVisitor;
import oracle.pgql.lang.util.ReplaceExpressions;

class VarRefReplacer
extends ReplaceExpressions {
    Set<String> variables;

    VarRefReplacer(Set<String> variables) {
        this.variables = variables;
    }

    protected boolean matches(QueryExpression expression) {
        return expression.getExpType() == QueryExpression.ExpressionType.VARREF && !GraphPatternTranslator.isVertexOrEdgeReference((QueryExpression.VarRef)expression) && this.variables.contains(((QueryExpression.VarRef)expression).getVariable().getName());
    }

    public QueryExpression replace(QueryExpression expression) {
        return new QueryExpression.FunctionCall("_ora_varref_function_", PgqlUtils.buildList(expression));
    }

    static void replaceExpressions(GraphPattern gp, Set<String> variables) {
        gp.accept((QueryExpressionVisitor)new VarRefReplacer(variables));
    }

    static void replaceExpressions(QueryExpression exp, Set<String> variables) {
        exp.accept((QueryExpressionVisitor)new VarRefReplacer(variables));
    }

    static void replaceExpressions(List<ExpAsVar> subSelectElems, Set<QueryExpression> constraints, List<ExpAsVar> groupByElements, List<OrderByElem> orderByElems, QueryExpression havingExp, Set<String> variables) {
        VarRefReplacer visitor = new VarRefReplacer(variables);
        for (ExpAsVar selectElement : subSelectElems) {
            selectElement.getExp().accept((QueryExpressionVisitor)visitor);
        }
        for (QueryExpression constraint : constraints) {
            constraint.accept((QueryExpressionVisitor)visitor);
        }
        for (ExpAsVar groupByElement : groupByElements) {
            groupByElement.getExp().accept((QueryExpressionVisitor)visitor);
        }
        for (OrderByElem orderByElem : orderByElems) {
            orderByElem.accept((QueryExpressionVisitor)visitor);
        }
        if (havingExp != null) {
            havingExp.accept((QueryExpressionVisitor)visitor);
        }
    }
}

