/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgview.metadata;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import oracle.pg.rdbms.pgql.PgqlConnection;
import oracle.pg.rdbms.pgql.PgqlExecution;
import oracle.pg.rdbms.pgql.PgqlToSqlException;
import oracle.pg.rdbms.pgql.pgview.metadata.CacheMap;
import oracle.pg.rdbms.pgql.pgview.metadata.MetadataRefreshTimeElements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataRefreshTimes {
    private static final Logger ms_log = LoggerFactory.getLogger(MetadataRefreshTimes.class);
    private static final String LAST_DDL_TIME_QUERY = "SELECT TO_CHAR(LAST_DDL_TIME, 'DD-MM-YYYY HH24:MI:SS') as last_ddl\nFROM SYS.ALL_OBJECTS WHERE owner = ? AND object_name = ? AND object_type = 'TABLE'";
    private static Map<MetadataRefreshTimesKey, MetadataRefreshTimeElements> cacheSync;

    public static synchronized void addOrUpdateGraph(PgqlConnection pgqlConn, String schemaName, String graphName) {
        MetadataRefreshTimesKey key;
        if (cacheSync == null) {
            cacheSync = new HashMap<MetadataRefreshTimesKey, MetadataRefreshTimeElements>();
        }
        if (cacheSync.containsKey(key = new MetadataRefreshTimesKey(pgqlConn.getJdbcConnection(), schemaName, graphName)) && Instant.now().minusMillis(pgqlConn.getGraphMetadataRefreshInterval()).isBefore(cacheSync.get(key).getTimeOfCheckOfLastMetadataChange())) {
            return;
        }
        MetadataRefreshTimeElements metadataRefreshTimeElements = new MetadataRefreshTimeElements(MetadataRefreshTimes.getLastDdlDateTime(pgqlConn.getJdbcConnection(), schemaName, graphName));
        cacheSync.put(key, metadataRefreshTimeElements);
    }

    public static synchronized boolean isRefreshed(PgqlConnection pgqlConn, String schemaName, String graphName) {
        MetadataRefreshTimesKey key = new MetadataRefreshTimesKey(pgqlConn.getJdbcConnection(), schemaName, graphName);
        MetadataRefreshTimeElements metadataRefreshTimeElements = cacheSync.get(key);
        if (metadataRefreshTimeElements == null) {
            ms_log.debug("Metadata for graph is not yet cached; fetching it from the server");
            return false;
        }
        Instant localInstantDateTime = metadataRefreshTimeElements.getTimeOfCheckOfLastMetadataChange();
        if (Instant.now().minusMillis(pgqlConn.getGraphMetadataRefreshInterval()).isBefore(localInstantDateTime)) {
            ms_log.debug("Graph metadata was already fetched within the refresh interval and will not be refetched");
            return true;
        }
        Instant lastDdlDateTimeInstant = MetadataRefreshTimes.getLastDdlDateTime(pgqlConn.getJdbcConnection(), schemaName, graphName);
        Instant dbInstantDateTime = metadataRefreshTimeElements.getTimeOfLastMetadataChange();
        MetadataRefreshTimeElements newMetadataRefreshTimeElements = new MetadataRefreshTimeElements(lastDdlDateTimeInstant);
        cacheSync.put(key, newMetadataRefreshTimeElements);
        if (lastDdlDateTimeInstant.equals(Instant.MIN) || lastDdlDateTimeInstant.isAfter(dbInstantDateTime)) {
            PgqlExecution.deleteCache(pgqlConn, schemaName, graphName);
            if (lastDdlDateTimeInstant.equals(Instant.MIN)) {
                throw new PgqlToSqlException("Graph " + schemaName + "." + graphName + " does not exist");
            }
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Instant getLastDdlDateTime(Connection conn, String schemaName, String graphName) {
        ms_log.debug("Getting last DDL DateTime for graph: " + schemaName + "." + graphName);
        try (PreparedStatement stmt = conn.prepareStatement(LAST_DDL_TIME_QUERY);){
            stmt.setString(1, schemaName);
            stmt.setString(2, graphName + "_ELEM_TABLE$");
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                String lastDdlTime = rs.getString(1);
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd-MM-yyyy HH:mm:ss");
                Instant instant2 = LocalDateTime.parse(lastDdlTime, formatter).toInstant(ZoneOffset.UTC);
                return instant2;
            }
            Instant instant = Instant.MIN;
            return instant;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    static class MetadataRefreshTimesKey {
        private final String connectionUrl;
        private final String connectionUser;
        private final String graphName;
        private final String schemaName;

        public MetadataRefreshTimesKey(Connection connection, String schemaName, String graphName) {
            this.connectionUrl = CacheMap.getConnectionURL(connection);
            this.connectionUser = CacheMap.getConnectionUser(connection);
            this.graphName = graphName;
            this.schemaName = schemaName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MetadataRefreshTimesKey that = (MetadataRefreshTimesKey)o;
            return this.connectionUrl.equals(that.connectionUrl) && this.connectionUser.equals(that.connectionUser) && this.graphName.equals(that.graphName) && this.schemaName.equals(that.schemaName);
        }

        public int hashCode() {
            return Objects.hash(this.connectionUrl, this.connectionUser, this.graphName, this.schemaName);
        }

        public String toString() {
            return "MetadataRefreshTimesKey{connectionUrl=" + this.connectionUrl + ", connectionUser=" + this.connectionUser + ", graphName='" + this.graphName + '\'' + ", schemaName='" + this.schemaName + '\'' + '}';
        }
    }
}

