/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgsql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import oracle.pg.rdbms.pgql.PgqlToSqlException;
import oracle.pg.rdbms.pgql.PgqlUtils;
import oracle.pg.rdbms.pgql.QueryContext;
import oracle.pg.rdbms.pgql.pgsql.utils.ExistSubQuery;
import oracle.pg.rdbms.pgql.pgsql.utils.ExistsType;
import oracle.pg.rdbms.pgql.pgview.util.Pair;
import oracle.pgql.lang.ir.Direction;
import oracle.pgql.lang.ir.ExpAsVar;
import oracle.pgql.lang.ir.GraphQuery;
import oracle.pgql.lang.ir.GroupBy;
import oracle.pgql.lang.ir.OrderByElem;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.QueryPath;
import oracle.pgql.lang.ir.QueryVariable;
import oracle.pgql.lang.ir.QueryVertex;
import oracle.pgql.lang.ir.SelectQuery;
import oracle.pgql.lang.ir.VertexPairConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgSqlQueryTranslator {
    private static final Logger ms_log = LoggerFactory.getLogger(PgSqlQueryTranslator.class);
    private static final String JAVA_DATETIME_FMT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private static final String JAVA_DATETIME_TZ_FMT = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
    private static final String DATETIME_TZ_FMT = "'SYYYY-MM-DD\"T\"HH24:MI:SS.FFTZH:TZM'";
    private static QueryContext ctx;

    public static String translateQuery(GraphQuery gq, QueryContext queryContext, Set<Pair<String, String>> subQueryElements, Set<Pair<String, String>> queryElements) {
        ArrayList<String> selectElements;
        ctx = queryContext;
        if (!(gq instanceof SelectQuery)) {
            throw new PgqlToSqlException("DML queries are not supported");
        }
        SelectQuery selectQuery = (SelectQuery)gq;
        Set vertexPairConnections = selectQuery.getGraphPattern().getConnections();
        Set queryVertices = selectQuery.getGraphPattern().getVertices();
        HashMap<String, Set<String>> labelExpressions = new HashMap<String, Set<String>>();
        ArrayList<ExistSubQuery> existsElements = new ArrayList<ExistSubQuery>();
        HashSet<Pair<String, String>> columnsElement = new HashSet<Pair<String, String>>();
        ArrayList<String> whereElementsVisited = new ArrayList<String>();
        for (QueryExpression qe : selectQuery.getGraphPattern().getConstraints()) {
            Pair<String, Boolean> exp = PgSqlQueryTranslator.translateExpression(qe, null, labelExpressions, existsElements, ExistsType.AND);
            if (((Boolean)exp.second).booleanValue()) continue;
            whereElementsVisited.add((String)exp.first);
        }
        ArrayList<String> paths = PgSqlQueryTranslator.getPaths(vertexPairConnections, labelExpressions, queryVertices);
        if (!existsElements.isEmpty()) {
            PgSqlQueryTranslator.handleExistsTranslation(selectQuery, labelExpressions, existsElements, columnsElement);
        }
        if (subQueryElements == null) {
            selectElements = PgSqlQueryTranslator.getElements(selectQuery.getProjection().getElements(), columnsElement, true);
        } else {
            selectElements = new ArrayList();
            queryElements.forEach(e -> selectElements.add("t." + (String)e.second));
        }
        GroupBy gp = selectQuery.getGroupBy();
        ArrayList<ExpAsVar> gpElements = gp == null ? new ArrayList() : gp.getElements();
        ArrayList<String> groupByElements = PgSqlQueryTranslator.getElements(gpElements, columnsElement, false);
        QueryExpression having = selectQuery.getHaving();
        String sqlHaving = having == null ? null : (String)PgSqlQueryTranslator.translateExpression((QueryExpression)having, columnsElement, null, null, (ExistsType)ExistsType.AND).first;
        List orderByElems = selectQuery.getOrderBy().getElements();
        ArrayList<String> orderByElements = new ArrayList<String>();
        for (OrderByElem orderByElem : orderByElems) {
            orderByElements.add((String)PgSqlQueryTranslator.translateExpression((QueryExpression)PgSqlQueryTranslator.tryToDereference((QueryExpression)orderByElem.getExp()), columnsElement, null, null, (ExistsType)ExistsType.AND).first + (orderByElem.isAscending() ? " ASC" : " DESC"));
        }
        existsElements.forEach(e -> e.setTranslatedQuery(PgSqlQueryTranslator.translateQuery((GraphQuery)e.getSelectQuery(), ctx, e.getExistColumnElements(), columnsElement)));
        if (!existsElements.isEmpty()) {
            return PgSqlQueryTranslator.buildSqlPgqExistsQuery(selectQuery, selectElements, paths, whereElementsVisited, columnsElement, groupByElements, sqlHaving, orderByElements, existsElements);
        }
        return PgSqlQueryTranslator.buildSqlPgqQuery(selectQuery, selectElements, paths, whereElementsVisited, columnsElement, groupByElements, sqlHaving, orderByElements, subQueryElements);
    }

    public static void handleExistsTranslation(SelectQuery selectQuery, Map<String, Set<String>> labelExpressions, ArrayList<ExistSubQuery> existsElements, Set<Pair<String, String>> columnsElement) {
        HashSet existsColumnElements = new HashSet();
        AtomicInteger id_index = new AtomicInteger();
        existsElements.forEach(e -> {
            existsColumnElements.clear();
            e.getSelectQuery().getGraphPattern().getVertices().forEach(v1 -> selectQuery.getGraphPattern().getVertices().forEach(v2 -> {
                if (v1.getName().equals(v2.getName())) {
                    Set labels = (Set)labelExpressions.get(v1.getName());
                    if (labels != null) {
                        StringBuilder stringBuilder = new StringBuilder("SELECT t1.property_name FROM sys.user_pg_prop_definitions t1, sys.user_pg_keys t2, sys.user_pg_element_labels t3 WHERE t1.column_name = t2.column_name AND t1.element_name = t2.element_name AND t2.element_name = t3.element_name AND t3.graph_name = ? AND t3.label_name IN (");
                        stringBuilder.append(labels.stream().map(s -> "?").collect(Collectors.joining(", ")));
                        stringBuilder.append(")");
                        try (PreparedStatement ps = PgSqlQueryTranslator.ctx.pgqlConn.getJdbcConnection().prepareStatement(stringBuilder.toString());){
                            ps.setString(1, PgSqlQueryTranslator.ctx.graphName);
                            int i = 2;
                            for (String elt : labels) {
                                ps.setString(i, elt);
                                ++i;
                            }
                            ResultSet rs = ps.executeQuery();
                            if (rs.next()) {
                                do {
                                    existsColumnElements.add(new Pair<String, String>(oracle.pgql.lang.ir.PgqlUtils.printIdentifier((String)v1.getName()) + "." + oracle.pgql.lang.ir.PgqlUtils.printIdentifier((String)rs.getString(1)), "spid_" + id_index.getAndIncrement()));
                                } while (rs.next());
                            }
                            existsColumnElements.add(new Pair<String, String>("VERTEX_ID(" + oracle.pgql.lang.ir.PgqlUtils.printIdentifier((String)v1.getName()) + ")", "vpid_" + id_index.getAndIncrement()));
                        }
                        catch (Exception ex) {
                            throw new PgqlToSqlException(ex);
                        }
                    } else {
                        existsColumnElements.add(new Pair<String, String>("VERTEX_ID(" + oracle.pgql.lang.ir.PgqlUtils.printIdentifier((String)v1.getName()) + ")", "vpid_" + id_index.getAndIncrement()));
                    }
                }
            }));
            e.setExistColumnElements(existsColumnElements);
            columnsElement.addAll(existsColumnElements);
        });
    }

    public static ArrayList<String> getElements(List<ExpAsVar> elementsList, Set<Pair<String, String>> columnsElement, boolean as) {
        ArrayList<String> elements = new ArrayList<String>();
        for (ExpAsVar expAsVar : elementsList) {
            elements.add((String)PgSqlQueryTranslator.translateExpression((QueryExpression)PgSqlQueryTranslator.tryToDereference((QueryExpression)expAsVar.getExp()), columnsElement, null, null, (ExistsType)ExistsType.AND).first + (as ? " AS " + PgqlUtils.escapeAndEnquoteIdentifier(expAsVar.getName()) : ""));
        }
        return elements;
    }

    private static String buildSqlPgqExistsQuery(SelectQuery selectQuery, ArrayList<String> selectElements, ArrayList<String> paths, ArrayList<String> whereElementsVisited, Set<Pair<String, String>> columnsElement, ArrayList<String> groupByElements, String sqlHaving, ArrayList<String> orderByElements, ArrayList<ExistSubQuery> existsElements) {
        StringBuilder sqlQuery = new StringBuilder("WITH tmp AS (SELECT ");
        sqlQuery.append(columnsElement.stream().map(e -> (String)e.second).collect(Collectors.joining(", ")));
        sqlQuery.append(" FROM GRAPH_TABLE( ").append(oracle.pgql.lang.ir.PgqlUtils.printIdentifier((String)PgSqlQueryTranslator.ctx.schemaName) + "." + oracle.pgql.lang.ir.PgqlUtils.printIdentifier((String)PgSqlQueryTranslator.ctx.graphName));
        sqlQuery.append(" MATCH ").append(String.join((CharSequence)", ", paths));
        if (whereElementsVisited.size() > 0) {
            sqlQuery.append(" WHERE ").append(String.join((CharSequence)" AND ", whereElementsVisited));
        }
        String tmp = columnsElement.stream().map(e -> (String)e.first + " AS " + (String)e.second).collect(Collectors.joining(", "));
        sqlQuery.append(" COLUMNS(").append(tmp).append("))),\n");
        int i = 1;
        for (ExistSubQuery esq : existsElements) {
            String translatedQuery = esq.getTranslatedQuery();
            sqlQuery.append(" tmp").append(i).append(" AS (").append(translatedQuery).append(")");
            if (i != existsElements.size()) {
                sqlQuery.append(", ");
            }
            sqlQuery.append("\n");
            ++i;
        }
        sqlQuery.append("/* end_tmp_with_clause */");
        sqlQuery.append(" SELECT ").append(selectQuery.getProjection().isDistinct() ? "DISTINCT " : "").append(String.join((CharSequence)", ", selectElements));
        sqlQuery.append(" FROM ( SELECT * FROM tmp");
        for (i = 0; i < existsElements.size(); ++i) {
            if (existsElements.get(i).getType() == ExistsType.AND) {
                sqlQuery.append(" INTERSECT ");
            } else if (existsElements.get(i).getType() == ExistsType.AND_NOT) {
                sqlQuery.append(" MINUS ");
            }
            sqlQuery.append(" SELECT * FROM tmp").append(i + 1);
        }
        sqlQuery.append(" )");
        if (groupByElements.size() > 0) {
            sqlQuery.append(" GROUP BY ").append(String.join((CharSequence)", ", groupByElements));
        }
        if (sqlHaving != null) {
            sqlQuery.append(" HAVING ").append(sqlHaving);
        }
        if (orderByElements.size() > 0) {
            sqlQuery.append(" ORDER BY ").append(String.join((CharSequence)", ", orderByElements));
        }
        if (selectQuery.getOffset() != null) {
            sqlQuery.append(PgSqlQueryTranslator.getLimitOrOffset(selectQuery.getOffset(), false));
        }
        if (selectQuery.getLimit() != null) {
            sqlQuery.append(PgSqlQueryTranslator.getLimitOrOffset(selectQuery.getLimit(), true));
        }
        return sqlQuery.toString();
    }

    public static String buildSqlPgqQuery(SelectQuery selectQuery, ArrayList<String> selectElements, ArrayList<String> paths, ArrayList<String> whereElementsVisited, Set<Pair<String, String>> columnsElement, ArrayList<String> groupByElements, String sqlHaving, ArrayList<String> orderByElements, Set<Pair<String, String>> subQueryElements) {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("\nbuilding SQL/PGQ string...");
        }
        StringBuilder sqlQuery = new StringBuilder("SELECT " + (selectQuery.getProjection().isDistinct() ? "DISTINCT " : "") + String.join((CharSequence)", ", selectElements));
        sqlQuery.append(" FROM ").append(subQueryElements == null ? "" : "tmp t, ");
        sqlQuery.append("GRAPH_TABLE( ").append(oracle.pgql.lang.ir.PgqlUtils.printIdentifier((String)PgSqlQueryTranslator.ctx.schemaName) + "." + oracle.pgql.lang.ir.PgqlUtils.printIdentifier((String)PgSqlQueryTranslator.ctx.graphName));
        sqlQuery.append(" MATCH ").append(String.join((CharSequence)", ", paths));
        if (whereElementsVisited.size() > 0) {
            sqlQuery.append(" WHERE ").append(String.join((CharSequence)" and ", whereElementsVisited));
        }
        sqlQuery.append(" COLUMNS(").append(columnsElement.stream().map(e -> (String)e.first + " AS " + (String)e.second).collect(Collectors.joining(", ")));
        sqlQuery.append(subQueryElements != null && !subQueryElements.isEmpty() ? (columnsElement.isEmpty() ? "" : ", ") + subQueryElements.stream().map(e -> (String)e.first + " AS " + (String)e.second).collect(Collectors.joining(", ")) : "");
        sqlQuery.append("))").append(subQueryElements != null ? " gt" : "");
        if (subQueryElements != null && !subQueryElements.isEmpty()) {
            sqlQuery.append(" WHERE ");
            int i = 0;
            for (Pair<String, String> e2 : subQueryElements) {
                String str = (String)e2.second;
                if (str.charAt(0) == 'v') {
                    sqlQuery.append("JSON_EQUAL(t.").append(str).append(", gt.").append(str).append(")");
                } else {
                    sqlQuery.append("t.").append(str).append(" = gt.").append(str);
                }
                if (++i == subQueryElements.size()) continue;
                sqlQuery.append(" AND ");
            }
        }
        if (groupByElements.size() > 0) {
            sqlQuery.append(" GROUP BY ").append(String.join((CharSequence)", ", groupByElements));
        }
        if (sqlHaving != null) {
            sqlQuery.append(" HAVING ").append(sqlHaving);
        }
        if (orderByElements.size() > 0) {
            sqlQuery.append(" ORDER BY ").append(String.join((CharSequence)", ", orderByElements));
        }
        if (selectQuery.getOffset() != null) {
            sqlQuery.append(PgSqlQueryTranslator.getLimitOrOffset(selectQuery.getOffset(), false));
        }
        if (selectQuery.getLimit() != null) {
            sqlQuery.append(PgSqlQueryTranslator.getLimitOrOffset(selectQuery.getLimit(), true));
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("\nbuilt query: " + sqlQuery);
        }
        return sqlQuery.toString();
    }

    public static ArrayList<String> getPaths(Set<VertexPairConnection> vertexPairConnections, Map<String, Set<String>> labelExpressions, Set<QueryVertex> queryVertices) {
        ArrayList<String> paths = new ArrayList<String>();
        HashSet<QueryVertex> matchedVertices = new HashSet<QueryVertex>();
        for (VertexPairConnection vpc : vertexPairConnections) {
            if (vpc instanceof QueryPath) {
                throw new UnsupportedOperationException("Variable length path patterns are not supported when translating PGQL to SQL property graph");
            }
            String path = "";
            QueryVertex src = vpc.getSrc();
            QueryVertex dst = vpc.getDst();
            path = path + PgSqlQueryTranslator.getPathForVertex((QueryVariable)src, labelExpressions, true);
            path = path + "-";
            path = path + PgSqlQueryTranslator.getPathForVertex((QueryVariable)vpc, labelExpressions, false);
            path = path + (vpc.getDirection() == Direction.ANY ? "-" : "->");
            path = path + PgSqlQueryTranslator.getPathForVertex((QueryVariable)dst, labelExpressions, true);
            paths.add(path);
            matchedVertices.add(src);
            matchedVertices.add(dst);
        }
        for (QueryVertex v : queryVertices) {
            if (matchedVertices.contains(v)) continue;
            paths.add(PgSqlQueryTranslator.getPathForVertex((QueryVariable)v, labelExpressions, true));
        }
        return paths;
    }

    public static String getLimitOrOffset(QueryExpression qe, boolean isLimit) {
        switch (qe.getExpType()) {
            case INTEGER: {
                return isLimit ? " FETCH FIRST " + ((QueryExpression.Constant.ConstInteger)qe).getValue() + " ROWS ONLY" : " OFFSET " + ((QueryExpression.Constant.ConstInteger)qe).getValue() + " ROWS";
            }
            case BIND_VARIABLE: {
                return isLimit ? " FETCH FIRST ? ROWS ONLY" : " OFFSET ? ROWS";
            }
        }
        throw new UnsupportedOperationException(qe.getExpType() + " is not supported in " + (isLimit ? "LIMIT" : "OFFSET") + " clause");
    }

    public static String getPathForVertex(QueryVariable v, Map<String, Set<String>> labelExpressions, boolean isVertex) {
        Set<String> labels;
        String path;
        String string = path = isVertex ? "(" : "[";
        if (!v.isAnonymous()) {
            path = path + v.getName();
        }
        if ((labels = labelExpressions.get(v.getName())) != null) {
            path = path + " IS " + labels.stream().map(oracle.pgql.lang.ir.PgqlUtils::printIdentifier).collect(Collectors.joining("|"));
        }
        path = path + (isVertex ? ")" : "]");
        return path;
    }

    private static QueryExpression tryToDereference(QueryExpression exp) {
        if (exp.getExpType() == QueryExpression.ExpressionType.VARREF) {
            QueryExpression.VarRef varRef = (QueryExpression.VarRef)exp;
            if (varRef.getVariable().getVariableType() == QueryVariable.VariableType.EXP_AS_VAR) {
                ExpAsVar expAsVar = (ExpAsVar)varRef.getVariable();
                return expAsVar.getExp();
            }
            throw new UnsupportedOperationException(varRef.getVariable().getVariableType() + " Cannot be projected in COLUMNS clause");
        }
        return exp;
    }

    public static Pair<String, Boolean> translateExpression(QueryExpression qe, Set<Pair<String, String>> columnElem, Map<String, Set<String>> labelExpressions, ArrayList<ExistSubQuery> existsElements, ExistsType existsType) {
        QueryExpression.ExpressionType expType = qe.getExpType();
        switch (expType) {
            case INTEGER: {
                return new Pair<String, Boolean>(String.valueOf(((QueryExpression.Constant.ConstInteger)qe).getValue()), false);
            }
            case STRING: {
                return new Pair<String, Boolean>(oracle.pgql.lang.ir.PgqlUtils.printLiteral((String)((String)((QueryExpression.Constant.ConstString)qe).getValue())), false);
            }
            case DECIMAL: {
                return new Pair<String, Boolean>(String.valueOf(((QueryExpression.Constant.ConstDecimal)qe).getValue()), false);
            }
            case DATE: {
                return new Pair<String, Boolean>("DATE '" + ((LocalDate)((QueryExpression.Constant.ConstDate)qe).getValue()).toString() + "'", false);
            }
            case TIME: {
                return new Pair<String, Boolean>("TIME '" + ((LocalTime)((QueryExpression.Constant.ConstTime)qe).getValue()).toString() + "'", false);
            }
            case TIME_WITH_TIMEZONE: {
                return new Pair<String, Boolean>("TIME '" + ((OffsetTime)((QueryExpression.Constant.ConstTimeWithTimezone)qe).getValue()).toString() + "'", false);
            }
            case TIMESTAMP: {
                LocalDateTime ts = (LocalDateTime)((QueryExpression.Constant.ConstTimestamp)qe).getValue();
                ZoneId tsz = ZoneId.systemDefault();
                OffsetDateTime tsodt = ts.atOffset(tsz.getRules().getOffset(ts));
                String tsdate = tsodt.format(DateTimeFormatter.ofPattern(JAVA_DATETIME_FMT));
                return new Pair<String, Boolean>("TO_TIMESTAMP_TZ('" + tsdate + "', " + DATETIME_TZ_FMT + ")", false);
            }
            case TIMESTAMP_WITH_TIMEZONE: {
                OffsetDateTime tsodt = (OffsetDateTime)((QueryExpression.Constant.ConstTimestampWithTimezone)qe).getValue();
                String tsdate = tsodt.format(DateTimeFormatter.ofPattern(JAVA_DATETIME_FMT));
                return new Pair<String, Boolean>("TO_TIMESTAMP_TZ('" + tsdate + "', " + DATETIME_TZ_FMT + ")", false);
            }
            case PROP_ACCESS: {
                QueryExpression.PropertyAccess pa = (QueryExpression.PropertyAccess)qe;
                if (columnElem != null) {
                    String tmp = pa.getVariable().getName() + "." + pa.getPropertyName();
                    columnElem.add(new Pair<String, String>(pa.getVariable().getName() + "." + oracle.pgql.lang.ir.PgqlUtils.printIdentifier((String)pa.getPropertyName()), oracle.pgql.lang.ir.PgqlUtils.printIdentifier((String)tmp)));
                    return new Pair<String, Boolean>(oracle.pgql.lang.ir.PgqlUtils.printIdentifier((String)tmp), false);
                }
                return new Pair<String, Boolean>(oracle.pgql.lang.ir.PgqlUtils.printIdentifier((String)pa.getVariable().getName()) + "." + oracle.pgql.lang.ir.PgqlUtils.printIdentifier((String)pa.getPropertyName()), false);
            }
            case GREATER: {
                QueryExpression.RelationalExpression.Greater gr = (QueryExpression.RelationalExpression.Greater)qe;
                return new Pair<String, Boolean>("(" + (String)PgSqlQueryTranslator.translateExpression((QueryExpression)gr.getExp1(), columnElem, labelExpressions, existsElements, (ExistsType)existsType).first + " > " + (String)PgSqlQueryTranslator.translateExpression((QueryExpression)gr.getExp2(), columnElem, labelExpressions, existsElements, (ExistsType)existsType).first + ")", false);
            }
            case GREATER_EQUAL: {
                QueryExpression.RelationalExpression.GreaterEqual gre = (QueryExpression.RelationalExpression.GreaterEqual)qe;
                return new Pair<String, Boolean>("(" + (String)PgSqlQueryTranslator.translateExpression((QueryExpression)gre.getExp1(), columnElem, labelExpressions, existsElements, (ExistsType)existsType).first + " >= " + (String)PgSqlQueryTranslator.translateExpression((QueryExpression)gre.getExp2(), columnElem, labelExpressions, existsElements, (ExistsType)existsType).first + ")", false);
            }
            case LESS: {
                QueryExpression.RelationalExpression.Less le = (QueryExpression.RelationalExpression.Less)qe;
                return new Pair<String, Boolean>("(" + (String)PgSqlQueryTranslator.translateExpression((QueryExpression)le.getExp1(), columnElem, labelExpressions, existsElements, (ExistsType)existsType).first + " < " + (String)PgSqlQueryTranslator.translateExpression((QueryExpression)le.getExp2(), columnElem, labelExpressions, existsElements, (ExistsType)existsType).first + ")", false);
            }
            case LESS_EQUAL: {
                QueryExpression.RelationalExpression.LessEqual lee = (QueryExpression.RelationalExpression.LessEqual)qe;
                return new Pair<String, Boolean>("(" + (String)PgSqlQueryTranslator.translateExpression((QueryExpression)lee.getExp1(), columnElem, labelExpressions, existsElements, (ExistsType)existsType).first + " <= " + (String)PgSqlQueryTranslator.translateExpression((QueryExpression)lee.getExp2(), columnElem, labelExpressions, existsElements, (ExistsType)existsType).first + ")", false);
            }
            case SUB: {
                QueryExpression.ArithmeticExpression.Sub sub = (QueryExpression.ArithmeticExpression.Sub)qe;
                return new Pair<String, Boolean>("(" + (String)PgSqlQueryTranslator.translateExpression((QueryExpression)sub.getExp1(), columnElem, labelExpressions, existsElements, (ExistsType)existsType).first + " - " + (String)PgSqlQueryTranslator.translateExpression((QueryExpression)sub.getExp2(), columnElem, labelExpressions, existsElements, (ExistsType)existsType).first + ")", false);
            }
            case ADD: {
                QueryExpression.ArithmeticExpression.Add add = (QueryExpression.ArithmeticExpression.Add)qe;
                return new Pair<String, Boolean>("(" + (String)PgSqlQueryTranslator.translateExpression((QueryExpression)add.getExp1(), columnElem, labelExpressions, existsElements, (ExistsType)existsType).first + " + " + (String)PgSqlQueryTranslator.translateExpression((QueryExpression)add.getExp2(), columnElem, labelExpressions, existsElements, (ExistsType)existsType).first + ")", false);
            }
            case MUL: {
                QueryExpression.ArithmeticExpression.Mul mul = (QueryExpression.ArithmeticExpression.Mul)qe;
                return new Pair<String, Boolean>("(" + (String)PgSqlQueryTranslator.translateExpression((QueryExpression)mul.getExp1(), columnElem, labelExpressions, existsElements, (ExistsType)existsType).first + " * " + (String)PgSqlQueryTranslator.translateExpression((QueryExpression)mul.getExp2(), columnElem, labelExpressions, existsElements, (ExistsType)existsType).first + ")", false);
            }
            case DIV: {
                QueryExpression.ArithmeticExpression.Div div = (QueryExpression.ArithmeticExpression.Div)qe;
                return new Pair<String, Boolean>("(" + (String)PgSqlQueryTranslator.translateExpression((QueryExpression)div.getExp1(), columnElem, labelExpressions, existsElements, (ExistsType)existsType).first + " / " + (String)PgSqlQueryTranslator.translateExpression((QueryExpression)div.getExp2(), columnElem, labelExpressions, existsElements, (ExistsType)existsType).first + ")", false);
            }
            case MOD: {
                QueryExpression.ArithmeticExpression.Mod mod = (QueryExpression.ArithmeticExpression.Mod)qe;
                return new Pair<String, Boolean>("(MOD(" + (String)PgSqlQueryTranslator.translateExpression((QueryExpression)mod.getExp1(), columnElem, labelExpressions, existsElements, (ExistsType)existsType).first + ", " + (String)PgSqlQueryTranslator.translateExpression((QueryExpression)mod.getExp2(), columnElem, labelExpressions, existsElements, (ExistsType)existsType).first + "))", false);
            }
            case UMIN: {
                QueryExpression.ArithmeticExpression.UMin umin = (QueryExpression.ArithmeticExpression.UMin)qe;
                return new Pair<String, Boolean>("-(" + (String)PgSqlQueryTranslator.translateExpression((QueryExpression)umin.getExp(), columnElem, labelExpressions, existsElements, (ExistsType)existsType).first + ")", false);
            }
            case AND: {
                QueryExpression.LogicalExpression.And and = (QueryExpression.LogicalExpression.And)qe;
                Pair<String, Boolean> andExp1 = PgSqlQueryTranslator.translateExpression(and.getExp1(), columnElem, labelExpressions, existsElements, ExistsType.AND);
                Pair<String, Boolean> andExp2 = PgSqlQueryTranslator.translateExpression(and.getExp2(), columnElem, labelExpressions, existsElements, ExistsType.AND);
                if (((Boolean)andExp1.second).booleanValue() && ((Boolean)andExp2.second).booleanValue()) {
                    return new Pair<String, Boolean>("", true);
                }
                if (((Boolean)andExp1.second).booleanValue()) {
                    return new Pair<String, Boolean>("(" + (String)andExp2.first + ")", false);
                }
                if (((Boolean)andExp2.second).booleanValue()) {
                    return new Pair<String, Boolean>("(" + (String)andExp1.first + ")", false);
                }
                return new Pair<String, Boolean>("(" + (String)andExp1.first + " AND " + (String)andExp2.first + ")", false);
            }
            case OR: {
                QueryExpression.LogicalExpression.Or or = (QueryExpression.LogicalExpression.Or)qe;
                Pair<String, Boolean> orExp1 = PgSqlQueryTranslator.translateExpression(or.getExp1(), columnElem, labelExpressions, existsElements, ExistsType.OR);
                Pair<String, Boolean> orExp2 = PgSqlQueryTranslator.translateExpression(or.getExp2(), columnElem, labelExpressions, existsElements, ExistsType.OR);
                if (((Boolean)orExp1.second).booleanValue() && ((Boolean)orExp2.second).booleanValue()) {
                    return new Pair<String, Boolean>("", true);
                }
                if (((Boolean)orExp1.second).booleanValue()) {
                    return new Pair<String, Boolean>("(" + (String)orExp2.first + ")", false);
                }
                if (((Boolean)orExp2.second).booleanValue()) {
                    return new Pair<String, Boolean>("(" + (String)orExp1.first + ")", false);
                }
                return new Pair<String, Boolean>("(" + (String)orExp1.first + " OR " + (String)orExp2.first + ")", false);
            }
            case NOT: {
                QueryExpression.LogicalExpression.Not not = (QueryExpression.LogicalExpression.Not)qe;
                Pair<String, Boolean> notExp = PgSqlQueryTranslator.translateExpression(not.getExp(), columnElem, labelExpressions, existsElements, existsType == ExistsType.AND ? ExistsType.AND_NOT : (existsType == ExistsType.OR ? ExistsType.OR_NOT : existsType));
                return new Pair<String, Boolean>((Boolean)notExp.second != false ? "" : "NOT (" + (String)notExp.first + ")", (Boolean)notExp.second);
            }
            case EQUAL: {
                QueryExpression.RelationalExpression.Equal eq = (QueryExpression.RelationalExpression.Equal)qe;
                return new Pair<String, Boolean>("(" + (String)PgSqlQueryTranslator.translateExpression((QueryExpression)eq.getExp1(), columnElem, labelExpressions, existsElements, (ExistsType)existsType).first + " = " + (String)PgSqlQueryTranslator.translateExpression((QueryExpression)eq.getExp2(), columnElem, labelExpressions, existsElements, (ExistsType)existsType).first + ")", false);
            }
            case NOT_EQUAL: {
                QueryExpression.RelationalExpression.NotEqual neq = (QueryExpression.RelationalExpression.NotEqual)qe;
                return new Pair<String, Boolean>("(" + (String)PgSqlQueryTranslator.translateExpression((QueryExpression)neq.getExp1(), columnElem, labelExpressions, existsElements, (ExistsType)existsType).first + " <> " + (String)PgSqlQueryTranslator.translateExpression((QueryExpression)neq.getExp2(), columnElem, labelExpressions, existsElements, (ExistsType)existsType).first + ")", false);
            }
            case CONCAT: {
                QueryExpression.ConcatExpression concat = (QueryExpression.ConcatExpression)qe;
                return new Pair<String, Boolean>("(" + (String)PgSqlQueryTranslator.translateExpression((QueryExpression)concat.getExp1(), columnElem, labelExpressions, existsElements, (ExistsType)existsType).first + " || " + (String)PgSqlQueryTranslator.translateExpression((QueryExpression)concat.getExp2(), columnElem, labelExpressions, existsElements, (ExistsType)existsType).first + ")", false);
            }
            case AGGR_COUNT: {
                QueryExpression.Aggregation.AggrCount aggrCount = (QueryExpression.Aggregation.AggrCount)qe;
                return new Pair<String, Boolean>("COUNT(" + (aggrCount.isDistinct() ? "DISTINCT " : "") + (String)PgSqlQueryTranslator.translateExpression((QueryExpression)aggrCount.getExp(), columnElem, labelExpressions, existsElements, (ExistsType)existsType).first + ")", false);
            }
            case AGGR_MIN: {
                QueryExpression.Aggregation.AggrMin aggrMin = (QueryExpression.Aggregation.AggrMin)qe;
                return new Pair<String, Boolean>("MIN(" + (aggrMin.isDistinct() ? "DISTINCT " : "") + (String)PgSqlQueryTranslator.translateExpression((QueryExpression)aggrMin.getExp(), columnElem, labelExpressions, existsElements, (ExistsType)existsType).first + ")", false);
            }
            case AGGR_MAX: {
                QueryExpression.Aggregation.AggrMax aggrMax = (QueryExpression.Aggregation.AggrMax)qe;
                return new Pair<String, Boolean>("MAX(" + (aggrMax.isDistinct() ? "DISTINCT " : "") + (String)PgSqlQueryTranslator.translateExpression((QueryExpression)aggrMax.getExp(), columnElem, labelExpressions, existsElements, (ExistsType)existsType).first + ")", false);
            }
            case AGGR_SUM: {
                QueryExpression.Aggregation.AggrSum aggrSum = (QueryExpression.Aggregation.AggrSum)qe;
                return new Pair<String, Boolean>("SUM(" + (aggrSum.isDistinct() ? "DISTINCT " : "") + (String)PgSqlQueryTranslator.translateExpression((QueryExpression)aggrSum.getExp(), columnElem, labelExpressions, existsElements, (ExistsType)existsType).first + ")", false);
            }
            case AGGR_AVG: {
                QueryExpression.Aggregation.AggrAvg aggrAvg = (QueryExpression.Aggregation.AggrAvg)qe;
                return new Pair<String, Boolean>("AVG(" + (aggrAvg.isDistinct() ? "DISTINCT " : "") + (String)PgSqlQueryTranslator.translateExpression((QueryExpression)aggrAvg.getExp(), columnElem, labelExpressions, existsElements, (ExistsType)existsType).first + ")", false);
            }
            case AGGR_LISTAGG: {
                QueryExpression.Aggregation.AggrListagg aggrListagg = (QueryExpression.Aggregation.AggrListagg)qe;
                String rslt = "LISTAGG(" + (aggrListagg.isDistinct() ? "DISTINCT " : "") + (String)PgSqlQueryTranslator.translateExpression((QueryExpression)aggrListagg.getExp(), columnElem, labelExpressions, existsElements, (ExistsType)existsType).first;
                if (aggrListagg.getSeparator() != null) {
                    rslt = rslt + ", " + oracle.pgql.lang.ir.PgqlUtils.printLiteral((String)aggrListagg.getSeparator());
                }
                rslt = rslt + ")";
                return new Pair<String, Boolean>(rslt, false);
            }
            case VARREF: {
                QueryExpression.VarRef varRef = (QueryExpression.VarRef)qe;
                return new Pair<String, Boolean>((String)PgSqlQueryTranslator.translateExpression((QueryExpression)PgSqlQueryTranslator.tryToDereference((QueryExpression)varRef), columnElem, labelExpressions, existsElements, (ExistsType)existsType).first, false);
            }
            case CAST: {
                QueryExpression.Function.Cast cast = (QueryExpression.Function.Cast)qe;
                String normalizedType = cast.getTargetTypeName().replace("TIMEZONE", "TIME ZONE");
                return new Pair<String, Boolean>("CAST(" + (String)PgSqlQueryTranslator.translateExpression((QueryExpression)cast.getExp(), columnElem, labelExpressions, existsElements, (ExistsType)existsType).first + " AS " + normalizedType + ")", false);
            }
            case FUNCTION_CALL: {
                QueryExpression.FunctionCall functionCall = (QueryExpression.FunctionCall)qe;
                if (functionCall.getPackageName() == null && functionCall.getFunctionName().equalsIgnoreCase("has_label")) {
                    String var = ((QueryExpression.VarRef)functionCall.getArgs().get(0)).getVariable().getName();
                    if (!labelExpressions.containsKey(var)) {
                        labelExpressions.put(var, new HashSet());
                    }
                    labelExpressions.get(var).add((String)((QueryExpression.Constant.ConstString)functionCall.getArgs().get(1)).getValue());
                    return new Pair<String, Boolean>("", true);
                }
                String functionName = functionCall.getFunctionName();
                if (functionCall.getPackageName() == null && functionCall.getArgs().size() == 1 && (functionName.equals("VERTEX_ID") || functionName.equals("EDGE_ID") || functionName.equals("ID")) && ((QueryExpression)functionCall.getArgs().get(0)).getExpType() == QueryExpression.ExpressionType.VARREF) {
                    QueryVariable queryVariable = ((QueryExpression.VarRef)functionCall.getArgs().get(0)).getVariable();
                    QueryVariable.VariableType type = queryVariable.getVariableType();
                    if (type == QueryVariable.VariableType.VERTEX && functionName.equals("EDGE_ID") || type == QueryVariable.VariableType.EDGE && functionName.equals("VERTEX_ID")) {
                        throw new PgqlToSqlException("Variable " + queryVariable.getName() + " of type " + type.name() + " and function call " + functionName + " do not match");
                    }
                    if (type == QueryVariable.VariableType.VERTEX || type == QueryVariable.VariableType.EDGE) {
                        functionName = type == QueryVariable.VariableType.VERTEX ? "VERTEX_ID" : "EDGE_ID";
                        if (columnElem == null) {
                            return new Pair<String, Boolean>(functionName + "(" + oracle.pgql.lang.ir.PgqlUtils.printIdentifier((String)queryVariable.getName()) + ")", false);
                        }
                        columnElem.add(new Pair<String, String>(functionName + "(" + oracle.pgql.lang.ir.PgqlUtils.printIdentifier((String)queryVariable.getName()) + ")", oracle.pgql.lang.ir.PgqlUtils.printIdentifier((String)(functionName + "_" + queryVariable.getName()))));
                        return new Pair<String, Boolean>(oracle.pgql.lang.ir.PgqlUtils.printIdentifier((String)(functionName + "_" + queryVariable.getName())), false);
                    }
                }
                String expressions = functionCall.getArgs().stream().map(e -> (String)PgSqlQueryTranslator.translateExpression((QueryExpression)e, (Set<Pair<String, String>>)columnElem, (Map<String, Set<String>>)labelExpressions, (ArrayList<ExistSubQuery>)existsElements, (ExistsType)existsType).first).collect(Collectors.joining(", "));
                String packageNamePart = functionCall.getPackageName() == null ? "" : functionCall.getPackageName() + ".";
                return new Pair<String, Boolean>(packageNamePart + functionCall.getFunctionName() + "(" + expressions + ")", false);
            }
            case EXTRACT_EXPRESSION: {
                QueryExpression.ExtractExpression extractExpression = (QueryExpression.ExtractExpression)qe;
                return new Pair<String, Boolean>("EXTRACT(" + extractExpression.getField().name() + " FROM " + (String)PgSqlQueryTranslator.translateExpression((QueryExpression)extractExpression.getExp(), columnElem, labelExpressions, existsElements, (ExistsType)existsType).first + ")", false);
            }
            case IN_EXPRESSION: {
                QueryExpression.InPredicate ip = (QueryExpression.InPredicate)qe;
                return new Pair<String, Boolean>((String)PgSqlQueryTranslator.translateExpression((QueryExpression)ip.getExp(), columnElem, labelExpressions, existsElements, (ExistsType)existsType).first + " IN " + (String)PgSqlQueryTranslator.translateExpression((QueryExpression)ip.getInValueList(), columnElem, labelExpressions, existsElements, (ExistsType)existsType).first, false);
            }
            case IN_VALUE_LIST: {
                QueryExpression.InPredicate.InValueList ivl = (QueryExpression.InPredicate.InValueList)qe;
                QueryExpression.ExpressionType arrayType = ivl.getArrayElementType();
                String str_ivl = "";
                switch (arrayType) {
                    case INTEGER: {
                        str_ivl = Arrays.stream(ivl.getIntegerValues()).mapToObj(String::valueOf).collect(Collectors.joining(", ", "( ", " )"));
                        break;
                    }
                    case DECIMAL: {
                        str_ivl = Arrays.stream(ivl.getDecimalValues()).mapToObj(String::valueOf).collect(Collectors.joining(", ", "( ", " )"));
                        break;
                    }
                    case DATE: {
                        str_ivl = Arrays.stream(ivl.getDateValues()).map(ld -> {
                            String datetimeStr = ld.atStartOfDay(ZoneOffset.UTC).format(DateTimeFormatter.ofPattern(JAVA_DATETIME_TZ_FMT));
                            return "TO_TIMESTAMP_TZ('" + datetimeStr + "', " + DATETIME_TZ_FMT + ")";
                        }).collect(Collectors.joining(", ", "( ", " )"));
                        break;
                    }
                    case TIMESTAMP: {
                        str_ivl = Arrays.stream(ivl.getTimestampValues()).map(ldt -> {
                            ZoneId zone = ZoneId.systemDefault();
                            OffsetDateTime odt = ldt.atOffset(zone.getRules().getOffset((LocalDateTime)ldt));
                            String datetimeStr = odt.format(DateTimeFormatter.ofPattern(JAVA_DATETIME_FMT));
                            return "TO_TIMESTAMP_TZ('" + datetimeStr + "', " + DATETIME_TZ_FMT + ")";
                        }).collect(Collectors.joining(", ", "( ", " )"));
                        break;
                    }
                    case STRING: {
                        str_ivl = Arrays.stream(ivl.getStringValues()).map(oracle.pgql.lang.ir.PgqlUtils::printLiteral).collect(Collectors.joining(", ", "( ", " )"));
                    }
                }
                return new Pair<String, Boolean>(str_ivl, false);
            }
            case IS_NULL: {
                QueryExpression.IsNull isNull = (QueryExpression.IsNull)qe;
                return new Pair<String, Boolean>((String)PgSqlQueryTranslator.translateExpression((QueryExpression)isNull.getExp(), columnElem, labelExpressions, existsElements, (ExistsType)existsType).first + " IS NULL", false);
            }
            case IF_ELSE: {
                QueryExpression.IfElse ifElse = (QueryExpression.IfElse)qe;
                String elseClause = "";
                if (ifElse.getExp3() != null) {
                    elseClause = elseClause + " ELSE " + (String)PgSqlQueryTranslator.translateExpression((QueryExpression)ifElse.getExp3(), columnElem, labelExpressions, existsElements, (ExistsType)existsType).first;
                }
                return new Pair<String, Boolean>("CASE WHEN " + (String)PgSqlQueryTranslator.translateExpression((QueryExpression)ifElse.getExp1(), columnElem, labelExpressions, existsElements, (ExistsType)existsType).first + " THEN " + (String)PgSqlQueryTranslator.translateExpression((QueryExpression)ifElse.getExp2(), columnElem, labelExpressions, existsElements, (ExistsType)existsType).first + elseClause + " END", false);
            }
            case SIMPLE_CASE: {
                QueryExpression.SimpleCase simpleCase = (QueryExpression.SimpleCase)qe;
                String result = "CASE " + (String)PgSqlQueryTranslator.translateExpression((QueryExpression)simpleCase.getCaseOperand(), columnElem, labelExpressions, existsElements, (ExistsType)existsType).first + " ";
                result = result + simpleCase.getWhenThenExps().stream().map(x -> "WHEN " + (String)PgSqlQueryTranslator.translateExpression((QueryExpression)x.getWhen(), (Set<Pair<String, String>>)columnElem, (Map<String, Set<String>>)labelExpressions, (ArrayList<ExistSubQuery>)existsElements, (ExistsType)existsType).first + " THEN " + (String)PgSqlQueryTranslator.translateExpression((QueryExpression)x.getThen(), (Set<Pair<String, String>>)columnElem, (Map<String, Set<String>>)labelExpressions, (ArrayList<ExistSubQuery>)existsElements, (ExistsType)existsType).first).collect(Collectors.joining(" "));
                if (simpleCase.getElseExp() != null) {
                    result = result + " ELSE " + (String)PgSqlQueryTranslator.translateExpression((QueryExpression)simpleCase.getElseExp(), columnElem, labelExpressions, existsElements, (ExistsType)existsType).first;
                }
                result = result + " END";
                return new Pair<String, Boolean>(result, false);
            }
            case SUBSTRING: {
                QueryExpression.SubstringExpression substring = (QueryExpression.SubstringExpression)qe;
                String res = "SUBSTR(" + (String)PgSqlQueryTranslator.translateExpression((QueryExpression)substring.getExp(), columnElem, labelExpressions, existsElements, (ExistsType)existsType).first + ", " + (String)PgSqlQueryTranslator.translateExpression((QueryExpression)substring.getStartPosition(), columnElem, labelExpressions, existsElements, (ExistsType)existsType).first;
                if (substring.getStringLength() != null) {
                    res = res + ", " + (String)PgSqlQueryTranslator.translateExpression((QueryExpression)substring.getStringLength(), columnElem, labelExpressions, existsElements, (ExistsType)existsType).first;
                }
                res = res + ")";
                return new Pair<String, Boolean>(res, false);
            }
            case EXISTS: {
                if (existsType == ExistsType.OR || existsType == ExistsType.OR_NOT) {
                    throw new PgqlToSqlException("OR operators are not supported with EXISTS/NOT EXISTS when querying SQL property graphs");
                }
                QueryExpression.Function.Exists exists = (QueryExpression.Function.Exists)qe;
                existsElements.add(new ExistSubQuery(exists.getQuery(), existsType));
                return new Pair<String, Boolean>("", true);
            }
        }
        throw new IllegalArgumentException("Unsupported expression " + qe.getExpType());
    }
}

