/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.pg.rdbms.pgql.PgqlConnection;
import oracle.pg.rdbms.pgql.PgqlCreatePgUtils;
import oracle.pg.rdbms.pgql.PgqlCreatePgVerifier;
import oracle.pg.rdbms.pgql.PgqlToSqlException;
import oracle.pg.rdbms.pgql.pgview.util.Pair;
import oracle.pgql.lang.ddl.propertygraph.CreatePropertyGraph;
import oracle.pgql.lang.ddl.propertygraph.EdgeTable;
import oracle.pgql.lang.ddl.propertygraph.ElementTable;
import oracle.pgql.lang.ddl.propertygraph.Key;
import oracle.pgql.lang.ddl.propertygraph.Label;
import oracle.pgql.lang.ddl.propertygraph.Property;
import oracle.pgql.lang.ddl.propertygraph.VertexTable;
import oracle.pgql.lang.ir.ExpAsVar;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.QueryExpressionVisitor;
import oracle.pgql.lang.ir.QueryVariable;
import oracle.pgql.lang.ir.SchemaQualifiedName;
import oracle.pgql.lang.util.AbstractQueryExpressionVisitor;

public class PgqlCpgRdbmsExpander {
    private final PgqlConnection pgqlConn;
    private final boolean forPgView;

    private PgqlCpgRdbmsExpander(PgqlConnection pgqlConn, boolean forPgView) {
        this.pgqlConn = pgqlConn;
        this.forPgView = forPgView;
    }

    public static PgqlCpgRdbmsExpander getPgqlCpgRdbmsExpander(PgqlConnection pgqlConn, boolean forPgView) {
        return new PgqlCpgRdbmsExpander(pgqlConn, forPgView);
    }

    public void expand(CreatePropertyGraph cpg) throws SQLException {
        if (cpg.getGraphName().getSchemaName() == null) {
            cpg.getGraphName().setSchemaName(this.pgqlConn.getSchema());
        }
        if (this.forPgView && cpg.getVertexTables().size() == 0) {
            throw new PgqlToSqlException("At least one vertex table should be specified to create PG view");
        }
        for (VertexTable vt : cpg.getVertexTables()) {
            this.expandElementTable((ElementTable)vt, "vertex");
        }
        for (EdgeTable et : cpg.getEdgeTables()) {
            this.expandElementTable((ElementTable)et, "edge");
            this.expandEdgeTable(et);
        }
    }

    public void expandElementTable(ElementTable et, String tableType) {
        SchemaQualifiedName tableName = et.getTableName();
        if (tableName.getSchemaName() == null) {
            tableName.setSchemaName(this.pgqlConn.getSchema());
        }
        if (!PgqlCreatePgUtils.existsTableOrView(this.pgqlConn, tableName.getSchemaName(), tableName.getName())) {
            this.throwTableError(et, tableType, "does not exist");
        }
        if (et.getKey() == null) {
            List<String> key = PgqlCreatePgUtils.getPrimaryKey(this.pgqlConn, et);
            if (key != null) {
                et.setKey(new Key(key));
            } else {
                this.throwTableError(et, tableType, "does not have a primary key, please provide one");
            }
        } else {
            this.verifyKeyColumnsExist(et.getKey(), et, tableType, "table");
        }
        for (Label l : et.getLabels()) {
            this.expandLabel(l, et, tableType);
        }
    }

    public void expandEdgeTable(EdgeTable et) throws SQLException {
        if (et.getEdgeSourceKey() == null) {
            Pair<Key, Key> srcForeignKeys = this.getForeignKey(et, et.getSourceVertexTable());
            et.setEdgeSourceKey((Key)srcForeignKeys.first);
            et.setSourceVertexKey((Key)srcForeignKeys.second);
        } else {
            this.verifyKeyColumnsExist(et.getEdgeSourceKey(), (ElementTable)et, "edge", "source");
        }
        if (et.getSourceVertexKey() == null) {
            et.setSourceVertexKey(et.getSourceVertexTable().getKey());
        } else {
            this.verifyKeyColumnsExist(et.getSourceVertexKey(), (ElementTable)et.getSourceVertexTable(), "vertex", "source");
        }
        if (et.getEdgeSourceKey().getColumnNames().size() != et.getSourceVertexKey().getColumnNames().size()) {
            throw new PgqlToSqlException("In edge provider " + et.getTableAlias() + ", the edge source key and referenced vertex key do not have matching number of columns");
        }
        if (et.getEdgeDestinationKey() == null) {
            Pair<Key, Key> dstForeignKey = this.getForeignKey(et, et.getDestinationVertexTable());
            et.setEdgeDestinationKey((Key)dstForeignKey.first);
            et.setDestinationVertexKey((Key)dstForeignKey.second);
        } else {
            this.verifyKeyColumnsExist(et.getEdgeDestinationKey(), (ElementTable)et, "edge", "destination");
        }
        if (et.getDestinationVertexKey() == null) {
            et.setDestinationVertexKey(et.getDestinationVertexTable().getKey());
        } else {
            this.verifyKeyColumnsExist(et.getDestinationVertexKey(), (ElementTable)et.getDestinationVertexTable(), "vertex", "destination");
        }
        if (et.getEdgeDestinationKey().getColumnNames().size() != et.getDestinationVertexKey().getColumnNames().size()) {
            throw new PgqlToSqlException("In edge provider " + et.getTableAlias() + ", the edge destination key and referenced vertex key do not have matching number of columns");
        }
        try (PreparedStatement ps = this.pgqlConn.getJdbcConnection().prepareStatement("select data_type, data_length\nfrom sys.all_tab_columns atc\nwhere atc.owner = ?\n  and atc.table_name = ?\n  and atc.column_name = ?");){
            this.verifyKeyColumnsTypes(ps, et.getEdgeSourceKey(), et.getSourceVertexKey(), (ElementTable)et, (ElementTable)et.getSourceVertexTable(), "source");
            this.verifyKeyColumnsTypes(ps, et.getEdgeDestinationKey(), et.getDestinationVertexKey(), (ElementTable)et, (ElementTable)et.getDestinationVertexTable(), "destination");
        }
        catch (SQLException e) {
            throw new PgqlToSqlException(e.getMessage());
        }
    }

    private Pair<Key, Key> getForeignKey(EdgeTable et, VertexTable vt) {
        SchemaQualifiedName etName = et.getTableName();
        SchemaQualifiedName vtName = vt.getTableName();
        List<Pair<List<String>, List<String>>> foreignKeys = PgqlCreatePgUtils.getForeignKeys(this.pgqlConn, et, vt);
        if (foreignKeys == null || foreignKeys.isEmpty()) {
            if (!this.forPgView && etName.equals((Object)vtName) && et.getKey() != null) {
                return new Pair<Key, Key>(et.getKey(), et.getKey());
            }
            this.throwTableError((ElementTable)et, "edge", "does not have a key referencing " + vtName + ", please provide one");
        }
        if (foreignKeys.size() > 1) {
            throw new PgqlToSqlException("Ambiguous key for edge provider " + et.getTableAlias() + ". Edge table " + etName + " has several columns referencing " + vtName + ", please specify a key");
        }
        return new Pair<Key, Key>(new Key((List)foreignKeys.get((int)0).first), new Key((List)foreignKeys.get((int)0).second));
    }

    private void expandLabel(Label l, ElementTable et, String tableType) {
        SchemaQualifiedName tableName = et.getTableName();
        if (l.isPropertiesAreAllColumns()) {
            List<String> columns = PgqlCreatePgUtils.getColumns(this.pgqlConn, tableName.getSchemaName(), tableName.getName());
            ArrayList<Property> properties = new ArrayList<Property>();
            for (String col : columns) {
                if (l.getPropertiesAreAllColumnsExcept() != null && l.getPropertiesAreAllColumnsExcept().contains(col)) continue;
                properties.add(new Property((QueryExpression)new QueryExpression.VarRef((QueryVariable)new ExpAsVar((QueryExpression)new QueryExpression.Constant.ConstString(col), col, true)), col));
            }
            l.setProperties(properties);
            l.setPropertiesAreAllColumns(false);
            l.setPropertiesAreAllColumnsExcept(null);
        } else {
            for (Property property : l.getProperties()) {
                QueryExpression qe = property.getValueExpression();
                this.verifyNestedColumnNames(qe, et, tableType);
            }
        }
    }

    private void verifyNestedColumnNames(QueryExpression exp, final ElementTable et, final String tableType) {
        exp.accept((QueryExpressionVisitor)new AbstractQueryExpressionVisitor(){

            public void visit(QueryExpression.VarRef qe) {
                String columnName = qe.getVariable().getName();
                PgqlCpgRdbmsExpander.this.verifyColumnExists(columnName, et, tableType, "property");
            }
        });
    }

    private void verifyKeyColumnsExist(Key key, ElementTable et, String tableType, String keyType) {
        for (String column : key.getColumnNames()) {
            this.verifyColumnExists(column, et, tableType, keyType + " key");
        }
    }

    private void verifyColumnExists(String column, ElementTable et, String tableType, String columnType) {
        SchemaQualifiedName tableName = et.getTableName();
        if (!PgqlCreatePgUtils.existsColumn(this.pgqlConn, tableName.getSchemaName(), tableName.getName(), column)) {
            this.throwTableError(et, tableType, "does not have a " + columnType + " column " + column);
        }
    }

    private void throwTableError(ElementTable et, String tableType, String errorMessage) {
        throw new PgqlToSqlException("In " + tableType + " provider " + et.getTableAlias() + ", table " + et.getTableName() + " " + errorMessage);
    }

    private void verifyKeyColumnsTypes(PreparedStatement ps, Key edgeKey, Key vertexKey, ElementTable et, ElementTable vt, String keyType) throws SQLException {
        int columnNumber = 0;
        for (String column : edgeKey.getColumnNames()) {
            this.verifyColumnsType(ps, et, vt, column, (String)vertexKey.getColumnNames().get(columnNumber++), keyType);
        }
    }

    private void verifyColumnsType(PreparedStatement ps, ElementTable et, ElementTable vt, String edgeKeyColumn, String vertexKeyColumn, String keyType) throws SQLException {
        String tableSchema1 = et.getTableName().getSchemaName();
        String tableName1 = et.getTableName().getName();
        String tableSchema2 = vt.getTableName().getSchemaName();
        String tableName2 = vt.getTableName().getName();
        if (!PgqlCreatePgVerifier.getColumnType(ps, tableSchema1, tableName1, edgeKeyColumn).equals(PgqlCreatePgVerifier.getColumnType(ps, tableSchema2, tableName2, vertexKeyColumn))) {
            throw new PgqlToSqlException("In edge provider " + tableName1 + ", the " + keyType + " key column " + edgeKeyColumn + " has a data type that is incompatible with column " + vertexKeyColumn + " of the referenced vertex table " + tableName2);
        }
    }
}

