/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons.proxy;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import oracle.ons.CallBack;
import oracle.ons.CallBackMode;
import oracle.ons.Notification;
import oracle.ons.ONS;
import oracle.ons.ONSConfiguration;
import oracle.ons.ONSException;
import oracle.ons.Publisher;
import oracle.ons.Subscriber;
import oracle.ons.rpc.RpcRequest;
import oracle.ons.rpc.RpcRequestListener;
import oracle.ons.rpc.RpcServer;
import oracle.ons.rpc.RpcServerException;

public class Proxy
implements Runnable {
    private ProxyConfig proxyConfig;
    private final Map<String, ClientContext> contexts = new HashMap<String, ClientContext>();
    private final Map<String, Long> subscriptions = new HashMap<String, Long>();
    private long subscriptionId = 0L;
    private ONS ons;
    private Publisher publisher;
    private static final String TENANT_ID_PROPERTY_NAME = "tenant_id";
    private static final String ONS_PROXY = "ONSProxy";
    private static final String ORACLE_CONFIG_HOME = "ORACLE_CONFIG_HOME";
    private static final String ORACLE_HOME = "ORACLE_HOME";
    private static final String ProxyHomeErr = "ORACLE_HOME must be set";
    private static final String ProxyUsage = "Usage: Proxy [<config-file>]";
    private static final Logger logger = Logger.getLogger(Proxy.class.getName());
    private ConsoleHandler consoleHandler;
    private FileHandler fileHandler;
    private File logPath;
    private final SimpleDateFormat stampFormatter = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss");
    private final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private static final int LogFileSize = 0x1400000;
    private static final int LogFileNumber = 10;
    private String oracleHome;
    private String configPath;
    private String onsctliPath;
    private boolean newConfigFile = false;
    private boolean needSubWaits = false;
    private volatile List<ONSConfiguration> netConfigs = new ArrayList<ONSConfiguration>();
    private RpcServer rpcServer;
    private Date proxyStart = null;
    private Date lastReloadSuccess = null;
    private Date lastReloadFail = null;
    private Date lastPingSuccess = null;
    private Date lastPingFail = null;
    private volatile RpcRequest reloadRequest = null;
    private volatile RpcRequest debugRequest = null;
    private volatile boolean proxyRun = true;
    private volatile boolean notified = false;
    private Object lock = new Object();
    private Object confLock = new Object();
    private Object requestLock = new Object();

    public static void main(String[] stringArray) {
        String string = null;
        if (stringArray.length == 0) {
            string = Proxy.setDefaultConfigFile();
        } else if (stringArray.length == 1) {
            string = stringArray[0];
        } else {
            throw new RuntimeException(ProxyUsage);
        }
        new Proxy(string).run();
    }

    private static String setDefaultConfigFile() {
        String string = null;
        String string2 = System.getenv(ORACLE_CONFIG_HOME);
        if (string2 != null) {
            string = Proxy.checkDefaultConfigFile(string2);
        }
        if (string == null) {
            string2 = System.getenv(ORACLE_HOME);
            if (string2 == null) {
                throw new RuntimeException(ProxyHomeErr);
            }
            string = Proxy.checkDefaultConfigFile(string2);
            if (string == null) {
                throw new RuntimeException("No default configuration file -- Usage: Proxy [<config-file>]");
            }
        }
        return string;
    }

    private static String checkDefaultConfigFile(String string) {
        String string2 = string + File.separatorChar + "opmn" + File.separatorChar + "conf" + File.separatorChar + "onsproxy.properties";
        File file = new File(string2);
        if (file.exists() && file.isFile()) {
            return string2;
        }
        return null;
    }

    public Proxy(String string) {
        this.configPath = string;
        this.consoleHandler = new ConsoleHandler();
        this.consoleHandler.setFormatter(new SimpleFormatter());
        logger.addHandler(this.consoleHandler);
        logger.setUseParentHandlers(false);
        this.oracleHome = System.getenv(ORACLE_HOME);
        if (this.oracleHome == null) {
            throw new RuntimeException(ProxyHomeErr);
        }
        this.proxyConfig = new ProxyConfig(string);
        this.setDefaultConfigHome();
        this.setOnsctli();
        this.validateProxyConfig(this.proxyConfig);
        this.checkOnsRunning();
        if (this.proxyConfig.debugLog) {
            this.setDebugLog();
        }
        this.updateProxyConfig(this.proxyConfig);
    }

    private void setDefaultConfigHome() {
        String string = this.proxyConfig.configHome;
        if (string == null && (string = System.getenv(ORACLE_CONFIG_HOME)) == null) {
            string = this.oracleHome;
            logger.log(Level.WARNING, "ORACLE_CONFIG_HOME is not set or configured -- using ORACLE_HOME");
        }
        logger.log(Level.INFO, "ORACLE_CONFIG_HOME set to " + string);
        File file = new File(string);
        if (file.exists() && file.isDirectory()) {
            this.proxyConfig.configHome = string;
            file = this.buildPath(string, "opmn", "logs");
            if (!file.exists()) {
                try {
                    file.mkdir();
                }
                catch (SecurityException securityException) {
                    throw new RuntimeException(file.getAbsolutePath() + ": failed to create log directory -- invalid " + ORACLE_CONFIG_HOME);
                }
            }
            if (!file.isDirectory()) {
                throw new RuntimeException(file.getAbsolutePath() + ": is not a directory -- invalid " + ORACLE_CONFIG_HOME);
            }
        } else {
            throw new RuntimeException("ORACLE_CONFIG_HOME: " + string + ": does not exist or is not a directory");
        }
        this.logPath = file;
    }

    private void setOnsctli() {
        this.onsctliPath = this.buildOnsctli(this.proxyConfig.configHome);
        if (this.onsctliPath == null) {
            this.onsctliPath = this.buildOnsctli(this.oracleHome);
            if (this.onsctliPath == null) {
                throw new RuntimeException(this.onsctliPath + ": script does not exist -- invalid " + ORACLE_CONFIG_HOME + ": " + this.proxyConfig.configHome + " or invalid " + ORACLE_HOME + ": " + this.oracleHome);
            }
            logger.log(Level.FINE, "onsctli set to " + this.onsctliPath);
        }
    }

    private String buildOnsctli(String string) {
        File file;
        String string2 = null;
        String string3 = "onsctli";
        if (File.separatorChar == '\\') {
            string3 = string3 + ".bat";
        }
        if ((file = this.buildPath(string, "opmn", "bin", string3)).exists() && file.isFile()) {
            string2 = file.getAbsolutePath();
        }
        return string2;
    }

    private void validateProxyConfig(ProxyConfig proxyConfig) throws RuntimeException {
        if (proxyConfig.configHome != null && !proxyConfig.configHome.equals(this.proxyConfig.configHome)) {
            throw new RuntimeException("ConfigHome cannot be changed via dynamic reload: current=" + this.proxyConfig.configHome + " -- new=" + proxyConfig.configHome);
        }
        logger.log(Level.INFO, "Validating configuration");
        this.validateOnsConfig(proxyConfig);
    }

    private void validateOnsConfig(ProxyConfig proxyConfig) throws RuntimeException {
        String string;
        if (proxyConfig.configFile.isEmpty()) {
            throw new RuntimeException(proxyConfig.configPath + ": no ONS server configuration");
        }
        if (!proxyConfig.configFile.containsKey("localport") || !proxyConfig.configFile.containsKey("remoteport")) {
            throw new RuntimeException(proxyConfig.configPath + ": ONS server configuration must include 'localport' and 'remoteport'");
        }
        Object object = this.proxyConfig.configFile.get("localport");
        if (!((String)object).equals(string = proxyConfig.configFile.get("localport"))) {
            throw new RuntimeException(proxyConfig.configPath + ": ONS server configuration: 'localport' cannot not be changed dynamically (" + (String)object + "==>" + string + ")");
        }
        object = this.buildStampedConfigPath();
        try {
            this.createConfigFile((File)object, proxyConfig);
        }
        catch (Exception exception) {
            ((File)object).delete();
            throw new RuntimeException(((File)object).getAbsolutePath() + ": failed to create ONS configuration file: " + exception);
        }
        int n = 2;
        try {
            n = this.runOnsctli(true, "validate", ((File)object).getAbsolutePath());
        }
        catch (Exception exception) {
            throw new RuntimeException(proxyConfig.configPath + ": failed to validate ONS configuration: " + exception);
        }
        finally {
            ((File)object).delete();
        }
        if (n != 0) {
            throw new RuntimeException(proxyConfig.configPath + ": ONS configuration validation failed");
        }
    }

    private int pingOnsServer(boolean bl) {
        int n = 2;
        try {
            n = this.runOnsctli(!bl, "ping");
        }
        catch (Exception exception) {
            n = 2;
        }
        if (bl) {
            if (n == 0) {
                this.lastPingSuccess = new Date();
            } else {
                this.lastPingFail = new Date();
            }
        }
        return n;
    }

    private void checkOnsRunning() {
        int n = this.pingOnsServer(false);
        if (n == 0) {
            try {
                n = this.runOnsctli(true, "proxy", "ping");
            }
            catch (Exception exception) {
                n = 2;
            }
            if (n == 0) {
                throw new RuntimeException("ONS proxy is already running for " + this.proxyConfig.configHome);
            }
            logger.log(Level.WARNING, "ONS server is already running for " + this.proxyConfig.configHome + " -- attempting to stop...");
            try {
                n = this.runOnsctli(true, "shutdown");
            }
            catch (Exception exception) {
                n = 2;
            }
            if (n != 0) {
                throw new RuntimeException("Failed to stop ONS server for " + this.proxyConfig.configHome);
            }
            logger.log(Level.INFO, "ONS server stopped");
        }
    }

    private void updateProxyConfig(ProxyConfig proxyConfig) {
        logger.log(Level.INFO, "Updating configuration");
        if (this.proxyConfig.debugLog != proxyConfig.debugLog) {
            logger.log(Level.FINE, proxyConfig.configPath + ": updating debug");
            if (proxyConfig.debugLog) {
                this.setDebugLog();
            } else {
                this.clearDebugLog();
            }
        }
        this.updateSubscriptions(proxyConfig.subscriptions);
        this.updateContexts(proxyConfig.internalConfigs, proxyConfig.runtimeNetworkSubscription);
        this.updateRuntimeNetworkSub(proxyConfig.runtimeNetworkSubscription);
        this.updateConfigFile(proxyConfig.configFile);
    }

    private void updateSubscriptions(List<String> list) {
        logger.log(Level.FINE, "Updating subscriptions");
        logger.log(Level.FINER, "Checking for removed subscriptions");
        Iterator<Map.Entry<String, Long>> iterator = this.subscriptions.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Long> entry = iterator.next();
            if (list.contains(entry.getKey())) continue;
            this.contextsRemoveSubscription((Long)entry.getValue());
            iterator.remove();
        }
        logger.log(Level.FINER, "Checking for new subscriptions");
        for (String string : list) {
            if (this.subscriptions.containsKey(string)) continue;
            ++this.subscriptionId;
            this.subscriptions.put(string, this.subscriptionId);
        }
    }

    private void updateContexts(Map<String, ONSConfiguration> map, String string) {
        Object object;
        logger.log(Level.FINE, "Updating networks");
        logger.log(Level.FINER, "Checking for removed networks");
        Iterator<Map.Entry<String, ClientContext>> iterator = this.contexts.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ClientContext> entry = iterator.next();
            String object2 = entry.getKey();
            if (map.containsKey(object2)) continue;
            object = (ClientContext)entry.getValue();
            if (((ClientContext)object).discovered && !string.isEmpty() && this.proxyConfig.runtimeNetworkSubscription.equals(string)) continue;
            ((ClientContext)object).close();
            iterator.remove();
        }
        logger.log(Level.FINER, "Checking for new networks");
        for (Map.Entry entry : map.entrySet()) {
            object = (String)entry.getKey();
            if (this.contexts.containsKey(object)) continue;
            this.contexts.put((String)object, new ClientContext((ONSConfiguration)entry.getValue(), false));
        }
    }

    private void updateRuntimeNetworkSub(String string) {
        if (!this.proxyConfig.runtimeNetworkSubscription.equals(string)) {
            logger.log(Level.FINE, "Updating run time network subscription");
            this.proxyConfig.runtimeNetworkSubscription = string;
            for (Map.Entry<String, ClientContext> entry : this.contexts.entrySet()) {
                ClientContext clientContext = entry.getValue();
                clientContext.addRtNetSubcriber(string);
            }
        }
    }

    private void updateConfigFile(Map<String, String> map) {
        if (!this.proxyConfig.configFile.equals(map)) {
            logger.log(Level.FINE, "Updating ONS server config file");
            this.newConfigFile = true;
            this.proxyConfig.configFile.clear();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.proxyConfig.configFile.put(entry.getKey(), entry.getValue());
            }
        } else {
            this.newConfigFile = false;
        }
    }

    private void contextsRemoveSubscription(long l) {
        for (Map.Entry<String, ClientContext> entry : this.contexts.entrySet()) {
            ClientContext clientContext = entry.getValue();
            clientContext.removeSubscriber(l);
        }
    }

    private void contextsAddSubscriptions() {
        for (Map.Entry<String, ClientContext> entry : this.contexts.entrySet()) {
            ClientContext clientContext = entry.getValue();
            if (!this.proxyConfig.runtimeNetworkSubscription.isEmpty()) {
                clientContext.addRtNetSubcriber(this.proxyConfig.runtimeNetworkSubscription);
            }
            for (Map.Entry<String, Long> entry2 : this.subscriptions.entrySet()) {
                String string = entry2.getKey();
                long l = entry2.getValue();
                clientContext.addSubscriber(l, string);
            }
        }
        this.contextsWaitSubscriptions();
    }

    private void contextsWaitSubscriptions() {
        this.needSubWaits = false;
        for (Map.Entry<String, ClientContext> entry : this.contexts.entrySet()) {
            ClientContext clientContext = entry.getValue();
            if (clientContext.waitSubscriber(0L, this.proxyConfig.runtimeNetworkSubscription)) {
                this.needSubWaits = true;
            }
            for (Map.Entry<String, Long> entry2 : this.subscriptions.entrySet()) {
                long l = entry2.getValue();
                boolean bl = clientContext.waitSubscriber(l, entry2.getKey());
                if (!bl) continue;
                this.needSubWaits = true;
            }
        }
    }

    private void setDebugLog() {
        logger.setLevel(Level.FINEST);
        if (this.fileHandler != null) {
            this.fileHandler.setLevel(Level.FINEST);
        }
    }

    private void clearDebugLog() {
        logger.setLevel(Level.INFO);
        if (this.fileHandler != null) {
            this.fileHandler.setLevel(Level.INFO);
        }
    }

    private void cleanup() {
        logger.log(Level.FINE, "Closing networks");
        for (Map.Entry<String, ClientContext> entry : this.contexts.entrySet()) {
            ClientContext clientContext = entry.getValue();
            clientContext.close();
        }
        logger.log(Level.FINE, "Shutting down ONS server");
        int n = 2;
        try {
            n = this.runOnsctli(true, "shutdown");
        }
        catch (Exception exception) {
            n = 2;
        }
        if (n != 0) {
            logger.log(Level.SEVERE, "Failed to shutdown ONS server for " + this.proxyConfig.configHome);
        }
        logger.log(Level.FINE, "Closing ONS client");
        this.publisher.close();
        this.ons.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runOnsctli(boolean bl, String ... stringArray) {
        String string = "";
        ArrayList<String> arrayList = new ArrayList<String>();
        if (File.separatorChar == '\\') {
            arrayList.add("cmd.exe");
            arrayList.add("/c");
            string = string + "cmd.exe /c ";
        }
        arrayList.add(this.onsctliPath);
        string = string + this.onsctliPath;
        if (!bl) {
            arrayList.add("quiet");
            string = string + " quiet";
        }
        for (String string2 : stringArray) {
            arrayList.add(string2);
            string = string + " " + string2;
        }
        logger.log(Level.FINEST, "Invoking: " + string);
        ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
        File file = new File(this.logPath, "proxy_ons.out");
        processBuilder.redirectError(ProcessBuilder.Redirect.appendTo(file));
        processBuilder.redirectOutput(ProcessBuilder.Redirect.appendTo(file));
        processBuilder.environment().put(ORACLE_CONFIG_HOME, this.proxyConfig.configHome);
        if (bl) {
            FileWriter fileWriter = null;
            try {
                String string2;
                fileWriter = new FileWriter(file, true);
                string2 = this.getDateStamp(new Date());
                fileWriter.write(string2 + ": " + string + "\n");
                fileWriter.flush();
            }
            catch (Exception exception) {
                exception.getMessage();
            }
            finally {
                if (fileWriter != null) {
                    try {
                        fileWriter.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        int n = 2;
        try {
            n = processBuilder.start().waitFor();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return n;
    }

    private void createServerConfigFile() throws RuntimeException {
        logger.log(Level.FINE, "Creating ONS server configuration file");
        File file = this.buildOnsConfigPath();
        try {
            this.createConfigFile(file, this.proxyConfig);
        }
        catch (Exception exception) {
            throw new RuntimeException(file.getAbsolutePath() + ": failed to create ONS configuration file: " + exception);
        }
    }

    private void putConfigFile(ProxyConfig proxyConfig, String string, String string2) {
        if (!proxyConfig.configFile.containsKey(string)) {
            proxyConfig.configFile.put(string, string2);
        }
    }

    private void createConfigFile(File file, ProxyConfig proxyConfig) throws IOException {
        this.putConfigFile(proxyConfig, "extendedsecuritymode", "strict");
        this.putConfigFile(proxyConfig, "extendedsecurityheader", TENANT_ID_PROPERTY_NAME);
        this.putConfigFile(proxyConfig, "allowunsecuresubscriber", "false");
        this.putConfigFile(proxyConfig, "allowpublish", "127.0.0.1,::1");
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            fileOutputStream.write("# Generated by ONS Proxy\n".getBytes());
            fileOutputStream.write(this.buildConfigFile(new StringBuilder(), proxyConfig).toString().getBytes());
        }
    }

    private StringBuilder buildConfigFile(StringBuilder stringBuilder, ProxyConfig proxyConfig) {
        for (Map.Entry<String, String> entry : proxyConfig.configFile.entrySet()) {
            stringBuilder.append(entry.getKey().toLowerCase()).append("=").append(entry.getValue()).append('\n');
        }
        return stringBuilder;
    }

    private File buildStampedConfigPath() {
        File file = this.buildOnsConfigPath();
        String string = file.getAbsolutePath() + "." + String.valueOf(System.currentTimeMillis());
        int n = 0;
        file = new File(string);
        while (file.exists()) {
            String string2 = string = string + "." + String.valueOf(n);
            ++n;
            file = new File(string2);
        }
        return file;
    }

    private File buildOnsConfigPath() {
        String string = "ons.config";
        if (this.proxyConfig.configFile.containsKey("usesharedinstall") && this.proxyConfig.configFile.get("usesharedinstall").equals("true")) {
            string = string + "." + ONSConfiguration.getHostname();
        }
        return this.buildPath(this.proxyConfig.configHome, "opmn", "conf", string);
    }

    private File buildPath(String string, String ... stringArray) {
        File file = new File(string);
        for (String string2 : stringArray) {
            file = new File(file, string2);
        }
        return file;
    }

    private void initProxy() {
        String string;
        ONSConfiguration oNSConfiguration;
        logger.log(Level.INFO, "Initializing");
        this.createServerConfigFile();
        logger.log(Level.FINE, "Starting ONS server");
        int n = 2;
        try {
            n = this.runOnsctli(true, "start");
        }
        catch (Exception exception) {
            n = 2;
        }
        if (n != 0) {
            this.lastPingFail = new Date();
            throw new RuntimeException("Failed to start ONS server for " + this.proxyConfig.configHome);
        }
        this.lastPingSuccess = new Date();
        logger.log(Level.FINE, "Creating client for ONS server");
        try {
            oNSConfiguration = ONSConfiguration.getLocalConfigFromFile(this.proxyConfig.configHome, null, null);
        }
        catch (ONSException oNSException) {
            throw new RuntimeException("Failed to initialize ONS client for " + this.proxyConfig.configHome);
        }
        this.ons = new ONS(oNSConfiguration);
        this.publisher = new Publisher(this.ons.config, "public");
        logger.log(Level.FINE, "Adding network subscribers");
        this.contextsAddSubscriptions();
        if (!this.proxyConfig.runtimeNetworkSubscription.isEmpty()) {
            string = this.proxyConfig.runtimeNetworkSubscription;
            this.proxyConfig.runtimeNetworkSubscription = "";
            this.updateRuntimeNetworkSub(string);
        }
        logger.log(Level.FINE, "Initializing RPC");
        this.initRPC();
        string = this.logPath.getAbsolutePath() + File.separatorChar + "proxy.log";
        logger.log(Level.FINE, "Setting log directory: " + this.logPath.getAbsolutePath());
        try {
            this.fileHandler = new FileHandler(string, 0x1400000, 10, true);
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to initialize log file: " + exception);
        }
        this.fileHandler.setFormatter(new SimpleFormatter());
        if (this.proxyConfig.debugLog) {
            this.fileHandler.setLevel(Level.FINEST);
        }
        logger.removeHandler(this.consoleHandler);
        logger.addHandler(this.fileHandler);
        logger.setUseParentHandlers(false);
        this.consoleHandler.close();
        this.consoleHandler = null;
        logger.log(Level.INFO, "Proxy starting. Build: ONS_23.0.0.0.0_LINUX.X64_250307.1 2025/3/8 0:8:31 UTC");
    }

    private void initRPC() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(ONS_PROXY, "proxy");
        this.rpcServer = this.ons.createRpcServer("ONSProxyServer", ONS_PROXY, hashMap, CallBackMode.SERIAL, true);
        this.rpcServer.addRequestListener("ping", new PingRequest());
        this.rpcServer.addRequestListener("shutdown", new ShutdownRequest());
        this.rpcServer.addRequestListener("debug", new DebugRequest());
        this.rpcServer.addRequestListener("reload", new ReloadRequest());
        try {
            this.rpcServer.launch();
        }
        catch (RpcServerException rpcServerException) {
            throw new RuntimeException("Failed to start RPC server: " + rpcServerException);
        }
    }

    private void proxyReload() {
        ProxyConfig proxyConfig;
        String string = "Reloading configuration";
        logger.log(Level.INFO, string);
        this.rpcReply(this.reloadRequest, string);
        try {
            proxyConfig = new ProxyConfig(this.configPath);
            this.rpcReply(this.reloadRequest, "Validating configuration");
            this.validateProxyConfig(proxyConfig);
        }
        catch (RuntimeException runtimeException) {
            String string2 = "Configuration validation failed -- reload aborted: " + runtimeException.getMessage();
            logger.log(Level.SEVERE, string2);
            this.lastReloadFail = new Date();
            this.rpcReply(this.reloadRequest, string2, true, false);
            return;
        }
        this.rpcReply(this.reloadRequest, "Updating configuration");
        this.updateProxyConfig(proxyConfig);
        this.contextsAddSubscriptions();
        if (this.newConfigFile) {
            String string3;
            string = "Updating ONS server configuration";
            logger.log(Level.FINE, string);
            this.rpcReply(this.reloadRequest, string);
            this.newConfigFile = false;
            File file = null;
            File file2 = this.buildOnsConfigPath();
            if (file2.exists()) {
                file = this.buildStampedConfigPath();
                logger.log(Level.FINE, "Renaming existing ONS server configuration file: " + file.getAbsolutePath());
                try {
                    file2.renameTo(file);
                }
                catch (Exception exception) {
                    string3 = "Failed to rename ONS configuration file (" + file2.getAbsolutePath() + " to " + file.getAbsolutePath() + "): " + exception.getMessage();
                    logger.log(Level.SEVERE, string3);
                    this.lastReloadFail = new Date();
                    this.rpcReply(this.reloadRequest, string3, true, false);
                }
            }
            logger.log(Level.FINE, "Creating ONS server configuration file: " + file2.getAbsolutePath());
            try {
                this.createServerConfigFile();
            }
            catch (RuntimeException runtimeException) {
                string3 = "Failed to update the ONS configuration file (" + file2.getAbsolutePath() + "): " + runtimeException.getMessage();
                logger.log(Level.SEVERE, string3);
                this.lastReloadFail = new Date();
                this.rpcReply(this.reloadRequest, string3, true, false);
                if (file != null) {
                    try {
                        file.renameTo(file2);
                    }
                    catch (Exception exception) {
                        logger.log(Level.SEVERE, "Failed to restore the ONS configuration file (" + file2.getAbsolutePath() + "): " + exception.getMessage());
                    }
                }
                return;
            }
            logger.log(Level.FINE, "Reloading the ONS server");
            this.rpcReply(this.reloadRequest, "Reloading ONS server", true, true);
            this.proxySleep(100);
            int n = 2;
            try {
                n = this.runOnsctli(true, "reload");
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, "Failed to reload ONS server for " + this.proxyConfig.configHome + " : " + exception.getMessage());
                this.lastReloadFail = new Date();
                n = 2;
            }
            if (n != 0) {
                this.lastReloadFail = this.lastPingFail = new Date();
                logger.log(Level.SEVERE, "Failed to reload ONS server for " + this.proxyConfig.configHome);
            } else {
                this.lastReloadSuccess = this.lastPingSuccess = new Date();
            }
        } else {
            this.rpcReply(this.reloadRequest, "Reload succeeded", true, true);
            this.lastReloadSuccess = new Date();
        }
    }

    private void proxyDebug() {
        byte[] byArray = this.debugRequest.getArgBytes();
        this.rpcReply(this.debugRequest, "ONS Proxy ONS_23.0.0.0.0_LINUX.X64_250307.1 2025/3/8 0:8:31 UTC\n\nRequest time: " + this.getDateStamp(new Date()));
        this.rpcReply(this.debugRequest, "\nProxy start: " + this.getDateStamp(this.proxyStart) + "\nLast successful proxy reload: " + this.getDateStamp(this.lastReloadSuccess) + "\nLast failed proxy reload: " + this.getDateStamp(this.lastReloadFail));
        int n = 0;
        this.rpcReply(this.debugRequest, "\nSubscriptions:");
        if (!this.proxyConfig.runtimeNetworkSubscription.isEmpty()) {
            ++n;
            this.rpcReply(this.debugRequest, "  0  " + this.proxyConfig.runtimeNetworkSubscription);
        }
        for (Map.Entry<String, Long> object : this.subscriptions.entrySet()) {
            ++n;
            String string = object.getKey();
            long l = object.getValue();
            this.rpcReply(this.debugRequest, "  " + l + "  " + string);
        }
        this.rpcReply(this.debugRequest, "Total number of subscriptions: " + n);
        this.rpcReply(this.debugRequest, "\nNetwork Contexts:");
        int n2 = 0;
        n = 0;
        for (Map.Entry<String, ClientContext> entry : this.contexts.entrySet()) {
            ++n;
            ClientContext clientContext = entry.getValue();
            String string = clientContext.discovered ? "discovered" : "configured";
            long l = clientContext.getNotificationsReceived();
            n2 = (int)((long)n2 + l);
            this.rpcReply(this.debugRequest, clientContext.config + "\n    Type: '" + string + "'  Subscribers: " + clientContext.countSubscribers() + "  Waiting: " + clientContext.countWaiters() + "\n    Notifications received: " + l + "  RTN received: " + clientContext.getRtNetReceived());
        }
        this.rpcReply(this.debugRequest, "Total number of network contexts: " + n + "\nTotal notifications received: " + n2);
        this.rpcReply(this.debugRequest, "\nLast successful ONS server ping: " + this.getDateStamp(this.lastPingSuccess) + "\nLast failed ONS server ping: " + this.getDateStamp(this.lastPingFail), true, true);
    }

    private String getDateStamp(Date date) {
        String string = "none";
        if (date != null) {
            string = this.dateFormatter.format(date);
        }
        return string;
    }

    private void setStartState() {
        String string = System.getenv("ORACLE_ONS_PROXY_TMPFILE");
        if (string != null) {
            boolean bl = false;
            String string2 = "unknown error";
            File file = new File(string);
            try {
                bl = file.createNewFile();
            }
            catch (Exception exception) {
                bl = false;
                string2 = exception.getMessage();
            }
            if (!bl) {
                logger.log(Level.WARNING, "Failed to create start state file: " + string + " : " + string2);
            }
        }
    }

    private void proxySleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeMain() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.notified) {
                this.notified = true;
                this.lock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean bl = false;
        this.initProxy();
        long l = System.currentTimeMillis();
        long l2 = 60000L;
        int n = 0;
        logger.log(Level.INFO, "Proxy started");
        this.proxyStart = new Date();
        this.setStartState();
        while (this.proxyRun) {
            long l3;
            Object object = this.lock;
            synchronized (object) {
                if (!this.notified) {
                    int n2 = 60000;
                    if (this.needSubWaits || n != 0) {
                        n2 = 5000;
                    }
                    try {
                        this.lock.wait(n2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.notified = false;
            }
            object = this.confLock;
            synchronized (object) {
                while (this.netConfigs.size() != 0) {
                    ONSConfiguration oNSConfiguration = this.netConfigs.remove(0);
                    String string = oNSConfiguration.toString();
                    if (this.contexts.containsKey(string)) continue;
                    this.contexts.put(string, new ClientContext(oNSConfiguration, true));
                    bl = true;
                }
            }
            if (bl) {
                this.contextsAddSubscriptions();
                bl = false;
            }
            object = this.requestLock;
            synchronized (object) {
                if (this.reloadRequest != null) {
                    this.proxyReload();
                    this.reloadRequest = null;
                    this.requestLock.notify();
                }
                if (this.debugRequest != null) {
                    this.proxyDebug();
                    this.debugRequest = null;
                    this.requestLock.notify();
                }
            }
            if (this.needSubWaits) {
                this.contextsWaitSubscriptions();
            }
            if ((l3 = System.currentTimeMillis()) - l < l2) continue;
            l = l3;
            int n3 = this.pingOnsServer(true);
            if (n3 != 0) {
                if (++n == 3) {
                    logger.log(Level.SEVERE, "ONS server ping failed " + n + " consecutive times -- aborting");
                    this.proxyRun = false;
                    continue;
                }
                logger.log(Level.WARNING, "ONS server ping failed");
                l2 = 5000L;
                continue;
            }
            if (n == 0) continue;
            logger.log(Level.INFO, "ONS server ping succeeded");
            n = 0;
            l2 = 60000L;
        }
        logger.log(Level.INFO, "Proxy stopping");
        this.cleanup();
        logger.log(Level.INFO, "Proxy terminating");
        this.rpcServer.shutdown();
    }

    private void rpcReply(RpcRequest rpcRequest, String string, boolean bl, boolean bl2) {
        if (!string.endsWith("\n")) {
            string = string + "\n";
        }
        if (!bl2) {
            bl = true;
            string = string + "!>proxy-result: failure\n";
        }
        if (bl) {
            rpcRequest.sendResult(string.getBytes(), true);
        } else {
            rpcRequest.sendResponse(string.getBytes(), false, true);
        }
    }

    private void rpcReply(RpcRequest rpcRequest, String string) {
        this.rpcReply(rpcRequest, string, false, true);
    }

    private static class PropertiesParser {
        private static final int EXPAND_LINE_CONTINUE = 0;

        protected PropertiesParser() {
        }

        protected static Map<String, List<String>> parse(String string) {
            HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
            HashMap<Integer, Boolean> hashMap2 = new HashMap<Integer, Boolean>();
            String string2 = null;
            int n = 0;
            int n2 = 0;
            BufferedReader bufferedReader = null;
            try {
                String string3;
                FileReader fileReader = new FileReader(string);
                bufferedReader = new BufferedReader(fileReader);
                String string4 = "";
                while ((string3 = bufferedReader.readLine()) != null) {
                    List<String> list;
                    ++n;
                    if (string3.startsWith("!") || string3.startsWith("#")) continue;
                    hashMap2.clear();
                    string3 = PropertiesParser.stringExpand(string3, hashMap2);
                    boolean bl = false;
                    if (hashMap2.containsKey(0)) {
                        bl = true;
                    }
                    if (string2 == null) {
                        if (string3.length() == 0) continue;
                        int n3 = string3.indexOf(61);
                        if (n3 == -1) {
                            n3 = string3.indexOf(58);
                            if (n3 == -1) {
                                throw new RuntimeException("invalid syntax at line: " + n);
                            }
                        } else {
                            int n4 = string3.indexOf(58);
                            if (n4 != -1 && n4 < n3) {
                                n3 = n4;
                            }
                        }
                        if ((string2 = string3.substring(0, n3).trim()).length() == 0) {
                            throw new RuntimeException("empty property key at line: " + n);
                        }
                        string4 = ++n3 < string3.length() ? string3.substring(n3).replaceAll("^\\s+", "") : "";
                        n2 = n;
                    } else {
                        string4 = string4 + string3.replaceAll("^\\s+", "");
                    }
                    if (bl) continue;
                    if (hashMap.containsKey(string2)) {
                        list = (List)hashMap.get(string2);
                    } else {
                        list = new ArrayList();
                        hashMap.put(string2, list);
                    }
                    list.add(string4);
                    string2 = null;
                }
            }
            catch (Exception exception) {
                throw new RuntimeException(string + ": " + exception.getMessage());
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception exception) {}
                }
            }
            if (string2 != null) {
                throw new RuntimeException(string + " incomplete value for property key '" + string2 + "' defined at line: " + n2);
            }
            return hashMap;
        }

        private static String stringExpand(String string, Map<Integer, Boolean> map) {
            string = string.replace("\\\\", "\b");
            string = string.replace("\\n", "\n");
            string = string.replace("\\r", "\r");
            if ((string = string.replace("\\t", "\t")).endsWith("\\")) {
                string = string.substring(0, string.length() - 1);
                map.put(0, true);
            }
            string = string.replace("\\", "");
            string = string.replace("\b", "\\");
            return string;
        }
    }

    private class ReloadRequest
    implements RpcRequestListener {
        protected ReloadRequest() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRequest(RpcRequest rpcRequest) {
            logger.log(Level.INFO, "Reload request begin");
            Object object = Proxy.this.requestLock;
            synchronized (object) {
                Proxy.this.reloadRequest = rpcRequest;
            }
            Proxy.this.wakeMain();
            object = Proxy.this.requestLock;
            synchronized (object) {
                while (Proxy.this.reloadRequest != null) {
                    try {
                        Proxy.this.requestLock.wait();
                    }
                    catch (Exception exception) {}
                }
            }
            logger.log(Level.INFO, "Reload request completed");
        }
    }

    private class DebugRequest
    implements RpcRequestListener {
        protected DebugRequest() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRequest(RpcRequest rpcRequest) {
            logger.log(Level.FINER, "Debug request begin");
            Object object = Proxy.this.requestLock;
            synchronized (object) {
                Proxy.this.debugRequest = rpcRequest;
            }
            Proxy.this.wakeMain();
            object = Proxy.this.requestLock;
            synchronized (object) {
                while (Proxy.this.debugRequest != null) {
                    try {
                        Proxy.this.requestLock.wait();
                    }
                    catch (Exception exception) {}
                }
            }
            logger.log(Level.FINER, "Debug request completed");
        }
    }

    private class ShutdownRequest
    implements RpcRequestListener {
        protected ShutdownRequest() {
        }

        @Override
        public void onRequest(RpcRequest rpcRequest) {
            logger.log(Level.INFO, "Shutdown request begin");
            Proxy.this.proxyRun = false;
            Proxy.this.wakeMain();
            Proxy.this.proxySleep(120000);
            Proxy.this.rpcReply(rpcRequest, "Shutdown timeout", true, false);
            logger.log(Level.SEVERE, "Shutdown request failed");
        }
    }

    private class PingRequest
    implements RpcRequestListener {
        protected PingRequest() {
        }

        @Override
        public void onRequest(RpcRequest rpcRequest) {
            logger.log(Level.FINER, "Ping request begin");
            Proxy.this.rpcReply(rpcRequest, "!>proxy-result: success", true, true);
            logger.log(Level.FINER, "Ping request completed");
        }
    }

    private class ClientContext {
        protected boolean discovered;
        private ONS ons = null;
        private String config;
        private final Map<Long, Subscriber> subscribers = new HashMap<Long, Subscriber>();
        private final Map<Long, Boolean> registered = new HashMap<Long, Boolean>();
        private CallBack callback;
        private CallBack rtCB;
        private Object statLock = new Object();
        private long notificationsReceived = 0L;
        private long rtNetReceived = 0L;

        protected ClientContext(ONSConfiguration oNSConfiguration, boolean bl) {
            this.ons = new ONS(oNSConfiguration);
            this.discovered = bl;
            this.callback = CallBack.create(this::publishCallBack);
            this.rtCB = CallBack.create(this::onNewNetworkNotification);
            this.config = oNSConfiguration.toString();
            logger.log(Level.FINE, oNSConfiguration + ": created context");
        }

        protected void close() {
            logger.log(Level.FINE, this.config + ": closing context");
            if (this.ons != null) {
                for (Map.Entry<Long, Subscriber> entry : this.subscribers.entrySet()) {
                    Subscriber subscriber = entry.getValue();
                    subscriber.close();
                }
                this.ons.close();
                this.ons = null;
            }
        }

        protected void addSubscriber(long l, String string) {
            this.addSubscriber(l, string, this.callback);
            logger.log(Level.FINER, this.config + ": added subscription (" + l + "): " + string);
        }

        protected void addSubscriber(long l, String string, CallBack callBack) {
            if (!this.subscribers.containsKey(l)) {
                Subscriber subscriber = Subscriber.backgroundSubscriber(this.ons.config, string, callBack);
                this.subscribers.put(l, subscriber);
                this.registered.put(l, false);
            }
        }

        protected void removeSubscriber(long l) {
            if (this.subscribers.containsKey(l)) {
                this.subscribers.get(l).close();
                this.subscribers.remove(l);
                logger.log(Level.FINER, this.config + ": removed subscription (" + l + ")");
            }
            if (this.registered.containsKey(l)) {
                this.registered.remove(l);
            }
        }

        protected boolean waitSubscriber(long l, String string) {
            boolean bl;
            boolean bl2 = false;
            if (this.registered.containsKey(l) && this.subscribers.containsKey(l) && !(bl = this.registered.get(l).booleanValue())) {
                logger.log(Level.FINEST, this.config + ": register wait (" + l + ")");
                bl2 = true;
                try {
                    Subscriber subscriber = this.subscribers.get(l);
                    bl = subscriber.waitUntilRegistered(10L, false);
                    if (bl) {
                        this.registered.put(l, true);
                        bl2 = false;
                        logger.log(Level.FINEST, this.config + ": registered (" + l + ")");
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, "Subscription: " + string + " subscriber creation failed: " + exception);
                    this.removeSubscriber(l);
                }
            }
            return bl2;
        }

        protected int countWaiters() {
            int n = 0;
            for (Map.Entry<Long, Boolean> entry : this.registered.entrySet()) {
                boolean bl = entry.getValue();
                if (bl) continue;
                ++n;
            }
            return n;
        }

        protected int countSubscribers() {
            return this.subscribers.size();
        }

        protected void addRtNetSubcriber(String string) {
            this.removeSubscriber(0L);
            this.addSubscriber(0L, string, this.rtCB);
            logger.log(Level.FINER, this.config + ": added run time network subscription: " + string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void publishCallBack(Notification notification) {
            if (notification.getVerb().equals("event")) {
                Notification notification2 = new Notification(notification);
                Proxy.this.publisher.publish(notification2);
                Object object = this.statLock;
                synchronized (object) {
                    ++this.notificationsReceived;
                }
                logger.log(Level.FINEST, this.config + ": received and published: " + notification.getEventType());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onNewNetworkNotification(Notification notification) {
            block10: {
                if (!((Proxy)Proxy.this).proxyConfig.runtimeNetworkSubscription.isEmpty() && notification.hasProperty("configuration")) {
                    String string = notification.get("configuration");
                    logger.log(Level.FINEST, this.config + ": received: " + string);
                    try {
                        boolean bl = false;
                        ONSConfiguration oNSConfiguration = ONSConfiguration.getRemoteConfigFromString(string);
                        Object object = Proxy.this.confLock;
                        synchronized (object) {
                            if (!Proxy.this.netConfigs.contains(oNSConfiguration)) {
                                Proxy.this.netConfigs.add(oNSConfiguration);
                                bl = true;
                            }
                        }
                        if (!bl) break block10;
                        logger.log(Level.FINEST, oNSConfiguration + ": sending new network: " + string);
                        Proxy.this.wakeMain();
                        object = this.statLock;
                        synchronized (object) {
                            ++this.rtNetReceived;
                        }
                    }
                    catch (ONSException oNSException) {
                        logger.log(Level.WARNING, "Invalid discovered configuration: " + string + " : " + oNSException);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected long getNotificationsReceived() {
            long l;
            Object object = this.statLock;
            synchronized (object) {
                l = this.notificationsReceived;
            }
            return l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected long getRtNetReceived() {
            long l;
            Object object = this.statLock;
            synchronized (object) {
                l = this.rtNetReceived;
            }
            return l;
        }
    }

    private class ProxyConfig {
        protected String configHome;
        protected boolean debugLog = false;
        protected final List<String> subscriptions = new ArrayList<String>();
        protected final Map<String, ONSConfiguration> internalConfigs = new HashMap<String, ONSConfiguration>();
        protected final Map<String, String> configFile = new HashMap<String, String>();
        protected String runtimeNetworkSubscription = "";
        private String configPath;

        protected ProxyConfig(String string) throws RuntimeException {
            Map<String, List<String>> map;
            this.configPath = string;
            logger.log(Level.INFO, "Loading configuration: " + string);
            try {
                map = PropertiesParser.parse(string);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                String string2 = entry.getKey();
                List<String> list = entry.getValue();
                ParseInterface parseInterface = null;
                if (string2.equals("addConfig")) {
                    parseInterface = this::addConfig;
                } else if (string2.equals("addNetwork")) {
                    parseInterface = this::addNetwork;
                } else if (string2.equals("addSubscription")) {
                    parseInterface = this::addSubscription;
                } else if (string2.equals("setConfigHome")) {
                    parseInterface = this::setConfigHome;
                } else if (string2.equals("enableDynamicNetworkSubscription")) {
                    parseInterface = this::setDynamicNetworkSubscription;
                } else if (string2.equals("debug")) {
                    parseInterface = this::setDebug;
                } else if (string2.equals("echo")) {
                    parseInterface = this::echoValue;
                } else {
                    throw new RuntimeException(string + ": unknown property: " + string2);
                }
                for (String string3 : list) {
                    logger.log(Level.FINEST, "Property: " + string2 + "=" + string3);
                    parseInterface.parseMethod(string2, string3);
                }
            }
        }

        private void logDuplicateKey(String string, String string2) {
            logger.log(Level.WARNING, this.configPath + ": ignoring duplicate " + string + ": using value: " + string2);
        }

        protected void addConfig(String string, String string2) {
            int n = string2.indexOf(61);
            if (n < 0) {
                n = string2.indexOf(58);
            }
            if (n <= 0 || n >= string2.length() - 1) {
                throw new RuntimeException(this.configPath + ": invalid syntax for " + string);
            }
            String string3 = string2.substring(0, n).trim().toLowerCase();
            String string4 = string2.substring(n + 1).trim();
            if (string3.length() == 0 || string4.length() == 0) {
                throw new RuntimeException(this.configPath + ": " + string + ": missing key or value");
            }
            if (this.configFile.containsKey(string3)) {
                if (string3.equals("nodes")) {
                    this.configFile.put(string3, this.configFile.get(string3) + "," + string4);
                    logger.log(Level.FINE, this.configPath + ": updated ONS server configuration: " + string4);
                } else {
                    logger.log(Level.WARNING, this.configPath + ": " + string + ": ignoring duplicate property " + string3 + ": using value: " + this.configFile.get(string3));
                }
            } else {
                this.configFile.put(string3.toLowerCase(), string4);
                logger.log(Level.FINE, this.configPath + ": added ONS server configuration: " + string4);
            }
        }

        private void addNetwork(String string, String string2) {
            ONSConfiguration oNSConfiguration = null;
            try {
                oNSConfiguration = ONSConfiguration.getRemoteConfigFromString(string2);
            }
            catch (ONSException oNSException) {
                logger.log(Level.WARNING, this.configPath + ": " + string + ": invalid value: " + string2 + " : " + oNSException);
            }
            if (oNSConfiguration != null) {
                String string3 = oNSConfiguration.toString();
                if (this.internalConfigs.containsKey(string3)) {
                    this.logDuplicateKey(string + ": " + string3, string2);
                } else {
                    this.internalConfigs.put(string3, oNSConfiguration);
                    logger.log(Level.FINE, this.configPath + ": added network: " + string2);
                }
            }
        }

        private void addSubscription(String string, String string2) {
            if (this.subscriptions.contains(string2)) {
                this.logDuplicateKey(string, string2);
            } else {
                this.subscriptions.add(string2);
                logger.log(Level.FINE, this.configPath + ": added subscription: " + string2);
            }
        }

        protected void setConfigHome(String string, String string2) {
            if (this.configHome != null && !this.configHome.equals(string2)) {
                this.logDuplicateKey(string, this.configHome);
            } else {
                this.configHome = string2;
                logger.log(Level.FINE, this.configPath + ": configHome=" + this.configHome);
            }
        }

        private void setDynamicNetworkSubscription(String string, String string2) {
            if (!this.runtimeNetworkSubscription.isEmpty()) {
                this.logDuplicateKey(string, string2);
            } else {
                this.runtimeNetworkSubscription = string2;
                logger.log(Level.FINE, this.configPath + ": set run time network subscription: " + string2);
            }
        }

        private void setDebug(String string, String string2) {
            if (string2.toLowerCase().equals("true")) {
                this.debugLog = true;
            }
        }

        private void echoValue(String string, String string2) {
            logger.log(Level.INFO, string2);
        }
    }

    @FunctionalInterface
    protected static interface ParseInterface {
        public void parseMethod(String var1, String var2);
    }
}

