/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.graphviz.driver;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosAuthentication {
    public static final String KERBEROS_AUTH = "graphviz.driver.auth.kerberos";
    public static final String KERBEROS_OKINIT_LOCATION = "graphviz.driver.auth.kerberos.okinit-location";
    public static final String KERBEROS_OKINIT_DIR = "graphviz.driver.auth.kerberos.okinit-directory";
    public static final String KERBEROS_CACHE_DIR = "graphviz.driver.auth.kerberos.cache_dir";
    public static final String KERBEROS_MAX_CACHE_SIZE = "graphviz.driver.auth.kerberos.max_cache_size";
    private static final Logger LOG = LoggerFactory.getLogger(KerberosAuthentication.class);

    private static void verifyCacheSize(Map<String, Object> props) {
        String directoryCache = (String)props.get(KERBEROS_CACHE_DIR);
        int maxCacheSize = Integer.parseInt((String)props.get(KERBEROS_MAX_CACHE_SIZE));
        int directoryLength = new File(directoryCache).list().length;
        if (directoryLength >= maxCacheSize) {
            throw new RuntimeException("Maximum number of kerberos sessions reached. To fix this issue, wait for active sessions to stop using the graph visualization webapp or have graph server administrator increase the graphviz.driver.auth.kerberos.max_cache_size parameter on web.xml");
        }
    }

    public static String getKerberosTicket(Map<String, Object> props, String ticketPath, String username, String password) {
        byte[] bytes;
        KerberosAuthentication.verifyCacheSize(props);
        boolean isPgxUsed = false;
        if (ticketPath == null) {
            ticketPath = KerberosAuthentication.getUniqueFileName(props);
            isPgxUsed = true;
        }
        String okinitPath = (String)props.get(KERBEROS_OKINIT_LOCATION);
        String[] commands = new String[]{"sh", "-c", String.format("%s -c %s %s", okinitPath, ticketPath, username)};
        Process cmdProc = null;
        try {
            cmdProc = Runtime.getRuntime().exec(commands);
            byte[] passwordAsBytes = (password + "\n").getBytes();
            cmdProc.getOutputStream().write(passwordAsBytes);
            cmdProc.getOutputStream().flush();
            cmdProc.waitFor();
            int exitValue = cmdProc.exitValue();
            if (exitValue != 0) {
                String line;
                BufferedReader stdoutReader = new BufferedReader(new InputStreamReader(cmdProc.getInputStream()));
                while ((line = stdoutReader.readLine()) != null) {
                    LOG.info(line);
                }
                BufferedReader stderrReader = new BufferedReader(new InputStreamReader(cmdProc.getErrorStream()));
                while ((line = stderrReader.readLine()) != null) {
                    LOG.info(line);
                }
                throw new IllegalArgumentException("Kerberos ticket could not be generated.");
            }
        }
        catch (IOException | InterruptedException ex) {
            throw new RuntimeException("Error trying to generated kerberos ticket.", ex);
        }
        try {
            bytes = Files.readAllBytes(Paths.get(ticketPath, new String[0]));
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Kerberos ticket not found.", ex);
        }
        if (isPgxUsed) {
            KerberosAuthentication.deleteKerberosTicket(ticketPath);
        }
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static void deleteKerberosTicket(String kerberosTicketPath) {
        File file = new File(kerberosTicketPath);
        if (file.exists()) {
            file.delete();
        }
    }

    public static String getUniqueFileName(Map<String, Object> props) {
        String directoryCache = (String)props.get(KERBEROS_CACHE_DIR);
        String uniqueName = null;
        while (new File(uniqueName = directoryCache + "/GRAPH_" + UUID.randomUUID().toString()).exists()) {
        }
        return uniqueName;
    }
}

