/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert.ext;

import java.io.IOException;
import java.io.InputStream;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.cert.AuthorityInfoAccess;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class AuthorityInfoAccessExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_pe_authorityInfoAccess;
    private AuthorityInfoAccess access;

    public AuthorityInfoAccessExtension() {
        super(TYPE);
    }

    public AuthorityInfoAccessExtension(AuthorityInfoAccess access) {
        this(access, false);
    }

    public AuthorityInfoAccessExtension(AuthorityInfoAccess access, boolean critical) {
        super(TYPE, critical);
        this.setAuthorityInfoAccess(access);
    }

    public AuthorityInfoAccessExtension(InputStream is) throws IOException {
        super(is);
    }

    public void setAuthorityInfoAccess(AuthorityInfoAccess access) {
        this.access = access;
        this.setValue(this.toByteArray());
    }

    public AuthorityInfoAccess getAuthorityInfoAccess() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.access;
    }

    private byte[] toByteArray() {
        byte[] b = Utils.toBytes((Streamable)this.access);
        this.isDecoded = true;
        return b;
    }

    private void decodeValue() {
        try {
            this.access = new AuthorityInfoAccess((InputStream)new UnsyncByteArrayInputStream(this.getValue()));
            if (this.access.methodCount() == 0) {
                throw new ASN1FormatException("Malformed extension contents");
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.toString());
        }
        this.isDecoded = true;
    }

    @Override
    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return "authorityInfoAccessExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = " + this.getAuthorityInfoAccess() + "}";
    }
}

