/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.util;

import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.zip.CRC32;
import oracle.pgx.common.PgxCharset;
import oracle.pgx.common.util.ErrorMessages;

public final class ObfuscationFacade {
    private static final int CHECKSUM_LENGTH = 8;

    private static void xorDataWithPattern(byte[] data, String pattern) {
        ErrorMessages.requireNonNull(pattern, "pattern");
        byte[] passwordBytes = pattern.getBytes(PgxCharset.getCharset());
        for (int i = 0; i < data.length; ++i) {
            int n = i;
            data[n] = (byte)(data[n] ^ passwordBytes[i % passwordBytes.length]);
        }
    }

    public static long checksum(byte[] dataBytes) {
        CRC32 crc32 = new CRC32();
        crc32.update(dataBytes);
        return crc32.getValue();
    }

    public static byte[] buildPayload(String data) {
        byte[] dataBytes = data.getBytes(PgxCharset.getCharset());
        long checksum = ObfuscationFacade.checksum(dataBytes);
        return ByteBuffer.allocate(dataBytes.length + 8).put(dataBytes).putLong(checksum).array();
    }

    public static byte[] getAndVerifyPayload(byte[] encBytes) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(encBytes);
        byte[] dataBytes = new byte[byteBuffer.remaining() - 8];
        byteBuffer.get(dataBytes);
        long expectedChecksum = byteBuffer.getLong();
        long checksum = ObfuscationFacade.checksum(dataBytes);
        if (expectedChecksum != checksum) {
            throw new IllegalArgumentException(ErrorMessages.getMessage("INVALID_CHECKSUM", new Object[0]));
        }
        return dataBytes;
    }

    public String obfuscate(String data, String pattern) {
        byte[] encBytes = ObfuscationFacade.buildPayload(data);
        ObfuscationFacade.xorDataWithPattern(encBytes, pattern);
        return Base64.getEncoder().encodeToString(encBytes);
    }

    public String deobfuscate(String encData, String pattern) {
        byte[] encBytes = Base64.getDecoder().decode(encData);
        ObfuscationFacade.xorDataWithPattern(encBytes, pattern);
        byte[] dataBytes = ObfuscationFacade.getAndVerifyPayload(encBytes);
        return new String(dataBytes, PgxCharset.getCharset());
    }
}

