/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleDriver;
import oracle.pg.rdbms.pgql.jdbc.PgqlJdbcRdbmsConnection;

public class PgqlJdbcRdbmsDriver
extends OracleDriver {
    private static PgqlJdbcRdbmsDriver registeredDriver;
    private static final String JDBC_URL_PREFIX = "jdbc:oracle:pgql:";

    public static void register() throws SQLException {
        if (PgqlJdbcRdbmsDriver.isRegistered()) {
            throw new IllegalStateException("Driver is already registered");
        }
        PgqlJdbcRdbmsDriver driver = new PgqlJdbcRdbmsDriver();
        DriverManager.registerDriver((Driver)((Object)driver));
        registeredDriver = driver;
    }

    public static boolean isRegistered() {
        return registeredDriver != null;
    }

    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            throw new SQLException("null is not a valid url");
        }
        return url.split(":").length > 3 && url.startsWith(JDBC_URL_PREFIX);
    }

    public Connection connect(String url, Properties info) throws SQLException {
        String oracleJdbcUrl = url.replace(":pgql:@", ":thin:@");
        OracleConnection conn = (OracleConnection)DriverManager.getConnection(oracleJdbcUrl, info.getProperty("user"), info.getProperty("password"));
        return new PgqlJdbcRdbmsConnection(conn);
    }

    static {
        try {
            PgqlJdbcRdbmsDriver.register();
        }
        catch (SQLException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

