/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.client;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import oracle.pgx.common.util.ErrorMessages;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgxUrlEncoder {
    private static final Logger LOG = LoggerFactory.getLogger(PgxUrlEncoder.class);

    public static String encode(String str) {
        if (str == null) {
            return null;
        }
        try {
            String encoded = URLEncoder.encode(str, "UTF-8");
            return encoded.replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String encodeUrl(String url, Object ... params) {
        assert (!url.contains(" "));
        int expectedParameterCount = StringUtils.countMatches((CharSequence)url, (CharSequence)"%s");
        if (expectedParameterCount != params.length) {
            LOG.warn("Request at {} expects {} parameters, but got {}", new Object[]{url, expectedParameterCount, params.length});
        }
        for (int i = 0; i < params.length; ++i) {
            PgxUrlEncoder.validateParameter(url, params[i], i + 1, expectedParameterCount);
            params[i] = PgxUrlEncoder.encode(params[i].toString());
        }
        return String.format(url, params);
    }

    private static void validateParameter(String url, Object param, int index, int expectedParameterCount) {
        if (param == null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"URL_PARAMETER_MISMATCH", (Object[])new Object[]{url, expectedParameterCount, index}));
        }
    }
}

