/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.config.AbstractConfig;
import oracle.pgx.config.AbstractStaticConfig;
import oracle.pgx.config.ConfigField;
import oracle.pgx.config.ConfigParser;
import oracle.pgx.config.ParseResult;
import oracle.pgx.config.PropertiesConfigParser;

public class StaticConfig
extends AbstractStaticConfig {
    private final Map<Field, Object> values;
    private final Set<Field> defaults;
    private final Map<String, Object> leftoverValues;

    public static StaticConfig parse(InputStream is, boolean strict, String parentPath) throws IOException {
        return StaticConfig.parse(ConfigParser.parseRaw(is), strict, parentPath);
    }

    static StaticConfig parse(InputStream is, boolean strict, String parentPath, boolean parseHiddenValues) throws IOException {
        return StaticConfig.parse(ConfigParser.parseRaw(is), strict, parentPath, parseHiddenValues);
    }

    public static StaticConfig parse(Map<String, Object> raw, boolean strict, String parentPath) {
        ParseResult pr = ConfigParser.parse(raw, (ConfigField[])Field.values(), (boolean)strict, (String)parentPath);
        return new StaticConfig(pr.getValues(), raw, pr.getDefaults());
    }

    static StaticConfig parse(Map<String, Object> raw, boolean strict, String parentPath, boolean parseHiddenValues) {
        ParseResult pr = ConfigParser.parse(raw, (ConfigField[])Field.values(), (boolean)strict, (String)parentPath, (boolean)parseHiddenValues);
        return new StaticConfig(pr.getValues(), raw, pr.getDefaults());
    }

    public static StaticConfig parse(Properties props, boolean strict) {
        ParseResult pr = PropertiesConfigParser.parse((Properties)props, (ConfigField[])Field.values(), (boolean)strict);
        return new StaticConfig(pr.getValues(), null, pr.getDefaults());
    }

    public static Field[] getConfigFields() {
        return Field.values();
    }

    protected StaticConfig(Map<Field, Object> values, Map<String, Object> leftoverValues, Set<Field> defaults) {
        this.values = values;
        this.leftoverValues = leftoverValues == null ? Collections.emptyMap() : leftoverValues;
        this.defaults = defaults;
        this.initialize();
    }

    public Map<Field, Object> getValues() {
        return this.values;
    }

    public boolean isEmpty() {
        return this.getValuesWithoutDefaults().isEmpty();
    }

    public boolean hasDefaultValue(Field field) {
        return this.defaults.contains(field);
    }

    @JsonValue
    public Map<Field, Object> getValuesWithoutDefaults() {
        HashMap<Field, Object> valuesWithoutDefaults = new HashMap<Field, Object>(this.values);
        for (Field field : this.defaults) {
            valuesWithoutDefaults.remove(field);
        }
        return valuesWithoutDefaults;
    }

    public Map<String, Object> getLeftoverValues() {
        return this.leftoverValues;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean hideSensitiveData) {
        if (!this.canSerialize()) {
            throw new UnsupportedOperationException("some objects part of this config cannot be serialized");
        }
        try {
            Object configValues = hideSensitiveData ? this.hiddenSensitiveData() : this;
            return ConfigJsonUtil.toJson(configValues);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private final Map<Field, Object> hiddenSensitiveData() {
        HashMap<Field, Object> hiddenValues = new HashMap<Field, Object>(this.getValuesWithoutDefaults());
        for (Field f : this.values.keySet()) {
            if (!f.isSensitive()) continue;
            hiddenValues.put(f, "*******");
        }
        return hiddenValues;
    }

    public Boolean isRelease() {
        return (Boolean)this.values.get(Field.RELEASE);
    }

    public Boolean isLimitGraphSize() {
        return (Boolean)this.values.get(Field.LIMIT_GRAPH_SIZE);
    }

    public Integer getMaxNumEdges() {
        return (Integer)this.values.get(Field.MAX_NUM_EDGES);
    }

    public Boolean isEnablePluginVersionChecks() {
        return (Boolean)this.values.get(Field.ENABLE_PLUGIN_VERSION_CHECKS);
    }

    public Boolean isLogSensitiveData() {
        return (Boolean)this.values.get(Field.LOG_SENSITIVE_DATA);
    }

    public Boolean isEnablePgqlUpdateQueries() {
        return (Boolean)this.values.get(Field.ENABLE_PGQL_UPDATE_QUERIES);
    }

    public Boolean isEnablePartitionedGraphLoading() {
        return (Boolean)this.values.get(Field.ENABLE_PARTITIONED_GRAPH_LOADING);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StaticConfig other = (StaticConfig)obj;
        if (!Objects.equals(this.isRelease(), other.isRelease())) {
            return false;
        }
        if (!Objects.equals(this.isLimitGraphSize(), other.isLimitGraphSize())) {
            return false;
        }
        if (!Objects.equals(this.getMaxNumEdges(), other.getMaxNumEdges())) {
            return false;
        }
        if (!Objects.equals(this.isEnablePluginVersionChecks(), other.isEnablePluginVersionChecks())) {
            return false;
        }
        if (!Objects.equals(this.isLogSensitiveData(), other.isLogSensitiveData())) {
            return false;
        }
        if (!Objects.equals(this.isEnablePgqlUpdateQueries(), other.isEnablePgqlUpdateQueries())) {
            return false;
        }
        return Objects.equals(this.isEnablePartitionedGraphLoading(), other.isEnablePartitionedGraphLoading());
    }

    public static enum Field implements ConfigField
    {
        RELEASE(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, false, false, false, false, false),
        LIMIT_GRAPH_SIZE(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, false, false, false, false, false),
        MAX_NUM_EDGES(Collections.emptyList(), Collections.emptyList(), Integer.class, false, -1, false, false, false, false),
        ENABLE_PLUGIN_VERSION_CHECKS(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, true, false, false, false, false),
        LOG_SENSITIVE_DATA(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, false, false, false, false, false),
        ENABLE_PGQL_UPDATE_QUERIES(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, true, false, false, false, false),
        ENABLE_PARTITIONED_GRAPH_LOADING(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, true, false, false, false, false);

        private final List<String> aliases;
        private final List<String> singletonListAliases;
        private final Class<?> type;
        private final boolean required;
        private final Object defaultVal;
        private final boolean array;
        private final boolean path;
        private final boolean sensitive;
        private final boolean hidden;

        private Field(List<String> aliases, List<String> singletonListAliases, Class<?> type, boolean required, Object factoryDefaultVal, boolean array, boolean path, boolean sensitive, boolean hidden) {
            this.aliases = aliases;
            this.singletonListAliases = singletonListAliases;
            this.type = type;
            this.required = required;
            this.defaultVal = AbstractConfig.getDefault("static.json", this, factoryDefaultVal);
            this.array = array;
            this.path = path;
            this.sensitive = sensitive;
            this.hidden = hidden;
        }

        @Override
        public List<String> getKeyAliases() {
            return this.aliases;
        }

        @Override
        public List<String> getSingletonListKeyAliases() {
            return this.singletonListAliases;
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }

        @Override
        public boolean isRequired() {
            return this.required;
        }

        @Override
        public boolean isArray() {
            return this.array;
        }

        @Override
        public boolean isPath() {
            return this.path;
        }

        @Override
        public Object getDefaultVal() {
            return this.defaultVal;
        }

        @Override
        @JsonValue
        public String toKey() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.toKey();
        }

        @Override
        public boolean isSensitive() {
            return this.sensitive;
        }

        @Override
        public boolean isHidden() {
            return this.hidden;
        }
    }
}

