/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import oracle.pgx.common.types.IdType;
import oracle.pgx.config.AbstractEntityProviderConfigFactory;
import oracle.pgx.config.ProviderFormat;
import oracle.pgx.config.ProviderLoadingConfig;
import oracle.pgx.config.RdbmsEntityProviderConfig;

public class RdbmsEntityProviderConfigFactory
extends AbstractEntityProviderConfigFactory<RdbmsEntityProviderConfig> {
    private final boolean strict;

    public RdbmsEntityProviderConfigFactory(boolean strict) {
        this.strict = strict;
    }

    RdbmsEntityProviderConfigFactory(boolean strict, boolean parseHiddenValues) {
        super(parseHiddenValues);
        this.strict = strict;
    }

    @Override
    protected final boolean supports(ProviderFormat type) {
        return type == ProviderFormat.RDBMS;
    }

    @Override
    protected RdbmsEntityProviderConfig fromMap(Map<String, Object> raw, String parent) throws IOException {
        this.addDefaultIdTypeIfMissing(raw);
        this.addDefaultCreateIndexMappingIfMissing(raw);
        return RdbmsEntityProviderConfig.parse(raw, this.strict, parent, this.parseHiddenValues);
    }

    @Override
    protected void addDefaultIdTypeIfMissing(Map<String, Object> raw) {
        Function<String, Object> valGetter = raw::get;
        if (this.hasValue(RdbmsEntityProviderConfig.Field.KEY_COLUMNS, valGetter)) {
            return;
        }
        if (!this.hasValue(RdbmsEntityProviderConfig.Field.KEY_TYPE, valGetter)) {
            boolean isEdgeTable = this.hasValue(RdbmsEntityProviderConfig.Field.SOURCE_VERTEX_PROVIDER, valGetter) && this.hasValue(RdbmsEntityProviderConfig.Field.DESTINATION_VERTEX_PROVIDER, valGetter);
            IdType defaultKeyType = isEdgeTable ? IdType.LONG : IdType.INTEGER;
            raw.put(RdbmsEntityProviderConfig.Field.KEY_TYPE.toKey(), defaultKeyType);
        }
    }

    @Override
    protected void addDefaultCreateIndexMappingIfMissing(Map<String, Object> raw) {
        boolean createIndexMapping;
        Function<String, Object> valGetter = raw::get;
        boolean isEdgeTable = this.hasValue(RdbmsEntityProviderConfig.Field.SOURCE_VERTEX_PROVIDER, valGetter) && this.hasValue(RdbmsEntityProviderConfig.Field.DESTINATION_VERTEX_PROVIDER, valGetter);
        boolean bl = createIndexMapping = !isEdgeTable;
        if (!this.hasValue(RdbmsEntityProviderConfig.Field.LOADING, valGetter)) {
            raw.put(RdbmsEntityProviderConfig.Field.LOADING.toKey(), new LinkedHashMap());
        }
        Object loadingSectionObject = valGetter.apply(RdbmsEntityProviderConfig.Field.LOADING.toKey());
        Map loadingSection = (Map)loadingSectionObject;
        loadingSection.putIfAbsent(ProviderLoadingConfig.Field.CREATE_KEY_MAPPING.toKey(), createIndexMapping);
    }
}

