/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.pgx.common.util.ErrorMessages;

public class PropertyFilterBuilder {
    private final Map<String, List<String>> propertyMap = new HashMap<String, List<String>>();

    public PropertyFilterBuilder() {
    }

    public PropertyFilterBuilder(Map<String, List<String>> initialMap) {
        if (initialMap != null) {
            this.propertyMap.putAll(initialMap);
        }
    }

    public PropertyFilterBuilder addProperty(String providerName, String propertyName) {
        ErrorMessages.requireNonNull((Object)providerName, (String)"provider name");
        this.propertyMap.computeIfAbsent(providerName, k -> new ArrayList()).add(propertyName);
        return this;
    }

    public PropertyFilterBuilder addProperties(String providerName, List<String> propertyNames) {
        ErrorMessages.requireNonNull((Object)providerName, (String)"provider name");
        this.propertyMap.computeIfAbsent(providerName, k -> new ArrayList()).addAll(propertyNames);
        return this;
    }

    public PropertyFilterBuilder addProperties(String providerName, String ... propertyNames) {
        ErrorMessages.requireNonNull((Object)providerName, (String)"provider name");
        return this.addProperties(providerName, List.of(propertyNames));
    }

    public PropertyFilterBuilder removePropertyForProvider(String providerName, String propertyName) {
        ErrorMessages.requireNonNull((Object)providerName, (String)"provider name");
        if (this.propertyMap.containsKey(providerName)) {
            this.propertyMap.get(providerName).remove(propertyName);
        }
        return this;
    }

    public PropertyFilterBuilder removeProvider(String providerName) {
        ErrorMessages.requireNonNull((Object)providerName, (String)"provider name");
        this.propertyMap.remove(providerName);
        return this;
    }

    public Map<String, List<String>> build() {
        return Collections.unmodifiableMap(this.propertyMap);
    }
}

