/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.config.AbstractConfig;
import oracle.pgx.config.AbstractGraphPropertyConfig;
import oracle.pgx.config.Aggregate;
import oracle.pgx.config.ConfigField;
import oracle.pgx.config.ConfigParser;
import oracle.pgx.config.ParseResult;
import oracle.pgx.config.PropertiesConfigParser;
import oracle.pgx.config.StringPoolingStrategy;

public class GraphPropertyConfig
extends AbstractGraphPropertyConfig {
    private final Map<Field, Object> values;
    private final Set<Field> defaults;
    private final Map<String, Object> leftoverValues;

    public static GraphPropertyConfig parse(InputStream is, boolean strict, String parentPath) throws IOException {
        return GraphPropertyConfig.parse(ConfigParser.parseRaw(is), strict, parentPath);
    }

    static GraphPropertyConfig parse(InputStream is, boolean strict, String parentPath, boolean parseHiddenValues) throws IOException {
        return GraphPropertyConfig.parse(ConfigParser.parseRaw(is), strict, parentPath, parseHiddenValues);
    }

    public static GraphPropertyConfig parse(Map<String, Object> raw, boolean strict, String parentPath) {
        ParseResult pr = ConfigParser.parse(raw, (ConfigField[])Field.values(), (boolean)strict, (String)parentPath);
        return new GraphPropertyConfig(pr.getValues(), raw, pr.getDefaults());
    }

    static GraphPropertyConfig parse(Map<String, Object> raw, boolean strict, String parentPath, boolean parseHiddenValues) {
        ParseResult pr = ConfigParser.parse(raw, (ConfigField[])Field.values(), (boolean)strict, (String)parentPath, (boolean)parseHiddenValues);
        return new GraphPropertyConfig(pr.getValues(), raw, pr.getDefaults());
    }

    public static GraphPropertyConfig parse(Properties props, boolean strict) {
        ParseResult pr = PropertiesConfigParser.parse((Properties)props, (ConfigField[])Field.values(), (boolean)strict);
        return new GraphPropertyConfig(pr.getValues(), null, pr.getDefaults());
    }

    public static Field[] getConfigFields() {
        return Field.values();
    }

    protected GraphPropertyConfig(Map<Field, Object> values, Map<String, Object> leftoverValues, Set<Field> defaults) {
        this.values = values;
        this.leftoverValues = leftoverValues == null ? Collections.emptyMap() : leftoverValues;
        this.defaults = defaults;
        this.initialize();
    }

    public Map<Field, Object> getValues() {
        return this.values;
    }

    public boolean isEmpty() {
        return this.getValuesWithoutDefaults().isEmpty();
    }

    public boolean hasDefaultValue(Field field) {
        return this.defaults.contains(field);
    }

    @JsonValue
    public Map<Field, Object> getValuesWithoutDefaults() {
        HashMap<Field, Object> valuesWithoutDefaults = new HashMap<Field, Object>(this.values);
        for (Field field : this.defaults) {
            valuesWithoutDefaults.remove(field);
        }
        return valuesWithoutDefaults;
    }

    public Map<String, Object> getLeftoverValues() {
        return this.leftoverValues;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean hideSensitiveData) {
        if (!this.canSerialize()) {
            throw new UnsupportedOperationException("some objects part of this config cannot be serialized");
        }
        try {
            Object configValues = hideSensitiveData ? this.hiddenSensitiveData() : this;
            return ConfigJsonUtil.toJson(configValues);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private final Map<Field, Object> hiddenSensitiveData() {
        HashMap<Field, Object> hiddenValues = new HashMap<Field, Object>(this.getValuesWithoutDefaults());
        for (Field f : this.values.keySet()) {
            if (!f.isSensitive()) continue;
            hiddenValues.put(f, "*******");
        }
        return hiddenValues;
    }

    @Override
    public String getName() {
        return (String)this.values.get(Field.NAME);
    }

    @Override
    public Integer getDimension() {
        return (Integer)this.values.get(Field.DIMENSION);
    }

    @Override
    public List<String> getFormat() {
        return (List)this.values.get(Field.FORMAT);
    }

    @Override
    public PropertyType getType() {
        return (PropertyType)this.values.get(Field.TYPE);
    }

    @Override
    public Object getDefault() {
        return this.values.get(Field.DEFAULT);
    }

    @Override
    public Object getColumn() {
        return this.values.get(Field.COLUMN);
    }

    @Override
    public List<Map> getStores() {
        return (List)this.values.get(Field.STORES);
    }

    public Integer getMaxDistinctStringsPerPool() {
        return (Integer)this.values.get(Field.MAX_DISTINCT_STRINGS_PER_POOL);
    }

    @Override
    public StringPoolingStrategy getStringPoolingStrategy() {
        return (StringPoolingStrategy)((Object)this.values.get(Field.STRING_POOLING_STRATEGY));
    }

    public Aggregate getAggregate() {
        return (Aggregate)((Object)this.values.get(Field.AGGREGATE));
    }

    public Object getField() {
        return this.values.get(Field.FIELD);
    }

    public String getGroupKey() {
        return (String)this.values.get(Field.GROUP_KEY);
    }

    public Boolean isDropAfterLoading() {
        return (Boolean)this.values.get(Field.DROP_AFTER_LOADING);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GraphPropertyConfig other = (GraphPropertyConfig)obj;
        if (!Objects.equals(this.getName(), other.getName())) {
            return false;
        }
        if (!Objects.equals(this.getDimension(), other.getDimension())) {
            return false;
        }
        if (!Objects.equals(this.getFormat(), other.getFormat())) {
            return false;
        }
        if (!Objects.equals(this.getType(), other.getType())) {
            return false;
        }
        if (!Objects.equals(this.getDefault(), other.getDefault())) {
            return false;
        }
        if (!Objects.equals(this.getColumn(), other.getColumn())) {
            return false;
        }
        if (!Objects.equals(this.getStores(), other.getStores())) {
            return false;
        }
        if (!Objects.equals(this.getMaxDistinctStringsPerPool(), other.getMaxDistinctStringsPerPool())) {
            return false;
        }
        if (!Objects.equals((Object)this.getStringPoolingStrategy(), (Object)other.getStringPoolingStrategy())) {
            return false;
        }
        if (!Objects.equals((Object)this.getAggregate(), (Object)other.getAggregate())) {
            return false;
        }
        if (!Objects.equals(this.getField(), other.getField())) {
            return false;
        }
        if (!Objects.equals(this.getGroupKey(), other.getGroupKey())) {
            return false;
        }
        return Objects.equals(this.isDropAfterLoading(), other.isDropAfterLoading());
    }

    public static enum Field implements ConfigField
    {
        NAME(Collections.emptyList(), Collections.emptyList(), String.class, true, null, false, false, false, false),
        DIMENSION(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 0, false, false, false, false),
        FORMAT(Collections.emptyList(), Collections.emptyList(), String.class, false, Collections.emptyList(), true, false, false, false),
        TYPE(Collections.emptyList(), Collections.emptyList(), PropertyType.class, true, null, false, false, false, false),
        DEFAULT(Collections.emptyList(), Collections.emptyList(), Object.class, false, null, false, false, false, false),
        COLUMN(Collections.emptyList(), Collections.emptyList(), Object.class, false, null, false, false, false, false),
        STORES(Collections.emptyList(), Collections.emptyList(), Map.class, false, Collections.emptyList(), true, false, false, false),
        MAX_DISTINCT_STRINGS_PER_POOL(Collections.emptyList(), Collections.emptyList(), Integer.class, false, null, false, false, false, false),
        STRING_POOLING_STRATEGY(Collections.emptyList(), Collections.emptyList(), StringPoolingStrategy.class, false, null, false, false, false, false),
        AGGREGATE(Collections.emptyList(), Collections.emptyList(), Aggregate.class, false, null, false, false, false, false),
        FIELD(Collections.emptyList(), Collections.emptyList(), Object.class, false, null, false, false, false, false),
        GROUP_KEY(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        DROP_AFTER_LOADING(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, false, false, false, false, false);

        private final List<String> aliases;
        private final List<String> singletonListAliases;
        private final Class<?> type;
        private final boolean required;
        private final Object defaultVal;
        private final boolean array;
        private final boolean path;
        private final boolean sensitive;
        private final boolean hidden;

        private Field(List<String> aliases, List<String> singletonListAliases, Class<?> type, boolean required, Object factoryDefaultVal, boolean array, boolean path, boolean sensitive, boolean hidden) {
            this.aliases = aliases;
            this.singletonListAliases = singletonListAliases;
            this.type = type;
            this.required = required;
            this.defaultVal = AbstractConfig.getDefault("graph.property.json", this, factoryDefaultVal);
            this.array = array;
            this.path = path;
            this.sensitive = sensitive;
            this.hidden = hidden;
        }

        @Override
        public List<String> getKeyAliases() {
            return this.aliases;
        }

        @Override
        public List<String> getSingletonListKeyAliases() {
            return this.singletonListAliases;
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }

        @Override
        public boolean isRequired() {
            return this.required;
        }

        @Override
        public boolean isArray() {
            return this.array;
        }

        @Override
        public boolean isPath() {
            return this.path;
        }

        @Override
        public Object getDefaultVal() {
            return this.defaultVal;
        }

        @Override
        @JsonValue
        public String toKey() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.toKey();
        }

        @Override
        public boolean isSensitive() {
            return this.sensitive;
        }

        @Override
        public boolean isHidden() {
            return this.hidden;
        }
    }
}

