/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum Format {
    PGB,
    EDGE_LIST,
    TWO_TABLES,
    ADJ_LIST,
    FLAT_FILE,
    GRAPHML,
    PG,
    RDF,
    CSV;


    public boolean isFileFormat() {
        switch (this) {
            case PGB: 
            case EDGE_LIST: 
            case TWO_TABLES: 
            case ADJ_LIST: 
            case FLAT_FILE: 
            case GRAPHML: 
            case CSV: {
                return true;
            }
        }
        return false;
    }

    public boolean isTextFormat() {
        switch (this) {
            case EDGE_LIST: 
            case ADJ_LIST: 
            case FLAT_FILE: 
            case CSV: {
                return true;
            }
        }
        return false;
    }

    public boolean hasVerticesAndEdgesSeparatedFileFormat() {
        return this.hasVerticesAndEdgesSeparatedFormat() && this.isFileFormat();
    }

    public boolean hasVerticesAndEdgesSeparatedFormat() {
        switch (this) {
            case TWO_TABLES: 
            case FLAT_FILE: 
            case CSV: 
            case PG: {
                return true;
            }
        }
        return false;
    }

    public boolean supportsLoadingVertexLabelFromProperty() {
        switch (this) {
            case PG: {
                return true;
            }
        }
        return false;
    }

    public boolean supportsSkippingEdges() {
        switch (this) {
            case EDGE_LIST: 
            case TWO_TABLES: 
            case ADJ_LIST: 
            case FLAT_FILE: 
            case PG: {
                return true;
            }
        }
        return false;
    }

    public boolean supportsSkippingVertices() {
        switch (this) {
            case EDGE_LIST: 
            case TWO_TABLES: 
            case ADJ_LIST: 
            case FLAT_FILE: 
            case PG: {
                return true;
            }
        }
        return false;
    }

    public boolean supportsPropertyConversion() {
        switch (this) {
            case TWO_TABLES: 
            case FLAT_FILE: 
            case PG: {
                return true;
            }
        }
        return false;
    }

    public boolean supportsVertexLabels() {
        switch (this) {
            case PGB: 
            case EDGE_LIST: 
            case TWO_TABLES: 
            case CSV: 
            case RDF: {
                return true;
            }
        }
        return false;
    }

    public boolean supportsEdgeLabel() {
        switch (this) {
            case PGB: 
            case EDGE_LIST: 
            case TWO_TABLES: 
            case FLAT_FILE: 
            case CSV: 
            case PG: 
            case RDF: {
                return true;
            }
        }
        return false;
    }

    public boolean supportsPartitioningWhileLoading() {
        switch (this) {
            case TWO_TABLES: 
            case FLAT_FILE: 
            case CSV: 
            case PG: {
                return true;
            }
        }
        return false;
    }

    public boolean supportsVectorProperties() {
        switch (this) {
            case PGB: 
            case EDGE_LIST: 
            case TWO_TABLES: 
            case ADJ_LIST: 
            case CSV: {
                return true;
            }
        }
        return false;
    }

    public boolean supportsPropertyColumn() {
        switch (this) {
            case TWO_TABLES: 
            case CSV: {
                return true;
            }
        }
        return false;
    }

    @JsonValue
    public String toKey() {
        return this.name().toLowerCase();
    }

    public String toString() {
        return this.toKey();
    }

    @JsonCreator
    public static Format parseFormat(String input) {
        return Format.valueOf(input.toUpperCase());
    }
}

