/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import oracle.pgx.common.types.IdType;
import oracle.pgx.config.AbstractEntityProviderConfigFactory;
import oracle.pgx.config.FileEntityProviderConfig;
import oracle.pgx.config.ProviderFormat;
import oracle.pgx.config.ProviderLoadingConfig;

public class FileEntityProviderConfigFactory
extends AbstractEntityProviderConfigFactory<FileEntityProviderConfig> {
    private final boolean strict;

    public FileEntityProviderConfigFactory() {
        this(true);
    }

    public FileEntityProviderConfigFactory(boolean strict) {
        this.strict = strict;
    }

    FileEntityProviderConfigFactory(boolean strict, boolean parseHiddenValues) {
        super(parseHiddenValues);
        this.strict = strict;
    }

    @Override
    protected boolean supports(ProviderFormat format) {
        return format.isFileFormat();
    }

    @Override
    protected FileEntityProviderConfig fromMap(Map<String, Object> raw, String parentPath) throws IOException {
        this.addDefaultIdTypeIfMissing(raw);
        this.addDefaultCreateIndexMappingIfMissing(raw);
        return FileEntityProviderConfig.parse(raw, this.strict, parentPath, this.parseHiddenValues);
    }

    @Override
    @Deprecated
    protected void addDefaultIdTypeIfMissing(Map<String, Object> raw) {
        Function<String, Object> valGetter = raw::get;
        if (!this.hasValue(FileEntityProviderConfig.Field.KEY_COLUMNS, valGetter) && !this.hasValue(FileEntityProviderConfig.Field.KEY_TYPE, valGetter)) {
            boolean isEdgeTable = this.hasValue(FileEntityProviderConfig.Field.SOURCE_VERTEX_PROVIDER, valGetter) && this.hasValue(FileEntityProviderConfig.Field.DESTINATION_VERTEX_PROVIDER, valGetter);
            IdType defaultKeyType = isEdgeTable ? IdType.LONG : IdType.INTEGER;
            raw.put(FileEntityProviderConfig.Field.KEY_TYPE.toKey(), defaultKeyType);
        }
    }

    @Override
    protected void addDefaultCreateIndexMappingIfMissing(Map<String, Object> raw) {
        boolean createIndexMapping;
        Function<String, Object> valGetter = raw::get;
        boolean isEdgeTable = this.hasValue(FileEntityProviderConfig.Field.SOURCE_VERTEX_PROVIDER, valGetter) && this.hasValue(FileEntityProviderConfig.Field.DESTINATION_VERTEX_PROVIDER, valGetter);
        boolean bl = createIndexMapping = !isEdgeTable;
        if (!this.hasValue(FileEntityProviderConfig.Field.LOADING, valGetter)) {
            raw.put(FileEntityProviderConfig.Field.LOADING.toKey(), new LinkedHashMap());
        }
        Object loadingSectionObject = valGetter.apply(FileEntityProviderConfig.Field.LOADING.toKey());
        Map loadingSection = (Map)loadingSectionObject;
        loadingSection.putIfAbsent(ProviderLoadingConfig.Field.CREATE_KEY_MAPPING.toKey(), createIndexMapping);
    }
}

