/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import oracle.pgx.common.types.IdType;
import oracle.pgx.config.AbstractEntityProviderConfigBuilder;
import oracle.pgx.config.EsEntityProviderConfig;
import oracle.pgx.config.ProviderFormat;
import oracle.pgx.config.ProviderLoadingConfig;

public final class EsEntityProviderConfigBuilder
extends AbstractEntityProviderConfigBuilder<EsEntityProviderConfigBuilder, EsEntityProviderConfig> {
    public EsEntityProviderConfigBuilder() {
        this.values.put(EsEntityProviderConfig.Field.FORMAT.toKey(), ProviderFormat.ES.toString());
        this.setKeyType(IdType.LONG);
    }

    @Override
    public EsEntityProviderConfigBuilder toEntityProviderConfigBuilder() {
        return this;
    }

    @Override
    protected void addDefaultIdTypeIfMissing(Map<String, Object> raw) {
        Function<String, Object> valGetter = raw::get;
        if (!this.hasValue(EsEntityProviderConfig.Field.KEY_TYPE, valGetter)) {
            boolean isEdgeTable = this.hasValue(EsEntityProviderConfig.Field.SOURCE_VERTEX_PROVIDER, valGetter) && this.hasValue(EsEntityProviderConfig.Field.DESTINATION_VERTEX_PROVIDER, valGetter);
            IdType defaultKeyType = isEdgeTable ? IdType.LONG : IdType.INTEGER;
            raw.put(EsEntityProviderConfig.Field.KEY_TYPE.toKey(), defaultKeyType);
        }
    }

    @Override
    protected void addDefaultCreateIndexMappingIfMissing(Map<String, Object> raw) {
        boolean createIndexMapping;
        Function<String, Object> valGetter = raw::get;
        boolean isEdgeTable = this.hasValue(EsEntityProviderConfig.Field.SOURCE_VERTEX_PROVIDER, valGetter) && this.hasValue(EsEntityProviderConfig.Field.DESTINATION_VERTEX_PROVIDER, valGetter);
        boolean bl = createIndexMapping = !isEdgeTable;
        if (!this.hasValue(EsEntityProviderConfig.Field.LOADING, valGetter)) {
            raw.put(EsEntityProviderConfig.Field.LOADING.toKey(), new LinkedHashMap());
        }
        Object loadingSectionObject = valGetter.apply(EsEntityProviderConfig.Field.LOADING.toKey());
        Map loadingSection = (Map)loadingSectionObject;
        loadingSection.putIfAbsent(ProviderLoadingConfig.Field.CREATE_KEY_MAPPING.toKey(), createIndexMapping);
    }

    @Override
    protected EsEntityProviderConfig parseTableConfig(InputStream is) throws IOException {
        return EsEntityProviderConfig.parse(is, true, null, true);
    }

    @Override
    public EsEntityProviderConfigBuilder copyFrom(EsEntityProviderConfig providerConfig) {
        super.copyFrom(providerConfig);
        this.setEsUrl(providerConfig.getEsUrl());
        this.setProxyUrl(providerConfig.getProxyUrl());
        this.setScrollTime(providerConfig.getScrollTime());
        this.setEsIndexName(providerConfig.getLoadedEsIndexName());
        this.setEsQuery(providerConfig.getEsQuery());
        this.setUsername(providerConfig.getUsername());
        this.setPassword((String)providerConfig.getValues().get(EsEntityProviderConfig.Field.PASSWORD));
        this.setKeyField(providerConfig.getKeyField());
        this.setSourceField(providerConfig.getSourceField());
        this.setDestinationField(providerConfig.getDestinationField());
        this.setMaxBatchSize(providerConfig.getMaxBatchSize());
        return (EsEntityProviderConfigBuilder)this.getThis();
    }

    public EsEntityProviderConfigBuilder setEsUrl(String url) {
        this.values.put(EsEntityProviderConfig.Field.ES_URL.toKey(), url);
        return this;
    }

    public EsEntityProviderConfigBuilder setProxyUrl(String proxyUrl) {
        this.values.put(EsEntityProviderConfig.Field.PROXY_URL.toKey(), proxyUrl);
        return this;
    }

    public EsEntityProviderConfigBuilder setScrollTime(String scrollTime) {
        this.values.put(EsEntityProviderConfig.Field.SCROLL_TIME.toKey(), scrollTime);
        return this;
    }

    public EsEntityProviderConfigBuilder setUsername(String username) {
        this.values.put(EsEntityProviderConfig.Field.USERNAME.toKey(), username);
        return this;
    }

    public EsEntityProviderConfigBuilder setEsIndexName(String esIndexName) {
        this.values.put(EsEntityProviderConfig.Field.ES_INDEX_NAME.toKey(), esIndexName);
        return this;
    }

    public EsEntityProviderConfigBuilder setEsQuery(String esQuery) {
        this.values.put(EsEntityProviderConfig.Field.ES_QUERY.toKey(), esQuery);
        return this;
    }

    public EsEntityProviderConfigBuilder setKeyField(String nKey) {
        this.values.put(EsEntityProviderConfig.Field.KEY_FIELD.toKey(), nKey);
        return this;
    }

    public EsEntityProviderConfigBuilder setSourceField(String fromVkey) {
        this.values.put(EsEntityProviderConfig.Field.SOURCE_FIELD.toKey(), fromVkey);
        return this;
    }

    public EsEntityProviderConfigBuilder setDestinationField(String toVkey) {
        this.values.put(EsEntityProviderConfig.Field.DESTINATION_FIELD.toKey(), toVkey);
        return this;
    }

    public EsEntityProviderConfigBuilder setMaxBatchSize(int maxPreFetchedRows) {
        this.values.put(EsEntityProviderConfig.Field.MAX_BATCH_SIZE.toKey(), maxPreFetchedRows);
        return this;
    }
}

