/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.config.EnterpriseSchedulerFlagsConfig;

public final class EnterpriseSchedulerFlagsConfigBuilder {
    private final Map<EnterpriseSchedulerFlagsConfig.Field, Object> values = new HashMap<EnterpriseSchedulerFlagsConfig.Field, Object>();

    public static EnterpriseSchedulerFlagsConfig buildEnterpriseSchedulerFlagsConfig(Consumer<EnterpriseSchedulerFlagsConfigBuilder> builderSetup) {
        EnterpriseSchedulerFlagsConfigBuilder builder = new EnterpriseSchedulerFlagsConfigBuilder();
        builderSetup.accept(builder);
        return builder.build();
    }

    public EnterpriseSchedulerFlagsConfigBuilder() {
    }

    public EnterpriseSchedulerFlagsConfigBuilder(Map<EnterpriseSchedulerFlagsConfig.Field, Object> values) {
        this.putAll(values);
    }

    public EnterpriseSchedulerFlagsConfigBuilder(EnterpriseSchedulerFlagsConfig config) {
        this.putAll(config);
    }

    public EnterpriseSchedulerFlagsConfigBuilder(EnterpriseSchedulerFlagsConfigBuilder builder) {
        this.putAll(builder.values);
    }

    public EnterpriseSchedulerFlagsConfigBuilder putAll(Map<EnterpriseSchedulerFlagsConfig.Field, Object> values) {
        this.values.putAll(values);
        return this;
    }

    public EnterpriseSchedulerFlagsConfigBuilder putAll(EnterpriseSchedulerFlagsConfig config) {
        this.putAll(config.getValuesWithoutDefaults());
        return this;
    }

    public EnterpriseSchedulerFlagsConfigBuilder clear() {
        this.values.clear();
        return this;
    }

    public EnterpriseSchedulerFlagsConfig build(String parentPath) {
        try {
            return EnterpriseSchedulerFlagsConfig.parse(this.toInputStream(), true, parentPath);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public EnterpriseSchedulerFlagsConfig build() {
        return this.build(null);
    }

    public InputStream toInputStream() {
        try {
            return ConfigJsonUtil.toJsonInputStream(this.values);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public Map<EnterpriseSchedulerFlagsConfig.Field, Object> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    public String toString() {
        return "EnterpriseSchedulerFlagsConfigBuilder" + this.values;
    }

    public EnterpriseSchedulerFlagsConfigBuilder setShowLogging(boolean showLogging) {
        this.values.put(EnterpriseSchedulerFlagsConfig.Field.SHOW_LOGGING, showLogging);
        return this;
    }

    public EnterpriseSchedulerFlagsConfigBuilder setShowWarnings(boolean showWarnings) {
        this.values.put(EnterpriseSchedulerFlagsConfig.Field.SHOW_WARNINGS, showWarnings);
        return this;
    }

    public EnterpriseSchedulerFlagsConfigBuilder setShowEnvironment(boolean showEnvironment) {
        this.values.put(EnterpriseSchedulerFlagsConfig.Field.SHOW_ENVIRONMENT, showEnvironment);
        return this;
    }

    public EnterpriseSchedulerFlagsConfigBuilder setShowProfiling(boolean showProfiling) {
        this.values.put(EnterpriseSchedulerFlagsConfig.Field.SHOW_PROFILING, showProfiling);
        return this;
    }

    public EnterpriseSchedulerFlagsConfigBuilder setShowSchedulerState(boolean showSchedulerState) {
        this.values.put(EnterpriseSchedulerFlagsConfig.Field.SHOW_SCHEDULER_STATE, showSchedulerState);
        return this;
    }

    public EnterpriseSchedulerFlagsConfigBuilder setShowAllocations(boolean showAllocations) {
        this.values.put(EnterpriseSchedulerFlagsConfig.Field.SHOW_ALLOCATIONS, showAllocations);
        return this;
    }

    public EnterpriseSchedulerFlagsConfigBuilder setLogToStderr(boolean logToStderr) {
        this.values.put(EnterpriseSchedulerFlagsConfig.Field.LOG_TO_STDERR, logToStderr);
        return this;
    }

    public EnterpriseSchedulerFlagsConfigBuilder setShowDebug(boolean showDebug) {
        this.values.put(EnterpriseSchedulerFlagsConfig.Field.SHOW_DEBUG, showDebug);
        return this;
    }

    public EnterpriseSchedulerFlagsConfigBuilder setUseOpenmpThreadPool(boolean useOpenmpThreadPool) {
        this.values.put(EnterpriseSchedulerFlagsConfig.Field.USE_OPENMP_THREAD_POOL, useOpenmpThreadPool);
        return this;
    }

    public EnterpriseSchedulerFlagsConfigBuilder setOverrideCoresPerSocket(int overrideCoresPerSocket) {
        this.values.put(EnterpriseSchedulerFlagsConfig.Field.OVERRIDE_CORES_PER_SOCKET, overrideCoresPerSocket);
        return this;
    }

    public EnterpriseSchedulerFlagsConfigBuilder setOverrideMemoryPlacement(boolean overrideMemoryPlacement) {
        this.values.put(EnterpriseSchedulerFlagsConfig.Field.OVERRIDE_MEMORY_PLACEMENT, overrideMemoryPlacement);
        return this;
    }

    public EnterpriseSchedulerFlagsConfigBuilder setMarkLoopForProfiling(String markLoopForProfiling) {
        this.values.put(EnterpriseSchedulerFlagsConfig.Field.MARK_LOOP_FOR_PROFILING, markLoopForProfiling);
        return this;
    }

    public EnterpriseSchedulerFlagsConfigBuilder setSelectPerformanceCounters(String selectPerformanceCounters) {
        this.values.put(EnterpriseSchedulerFlagsConfig.Field.SELECT_PERFORMANCE_COUNTERS, selectPerformanceCounters);
        return this;
    }

    public EnterpriseSchedulerFlagsConfigBuilder setSelectRegionPerformanceCounters(String selectRegionPerformanceCounters) {
        this.values.put(EnterpriseSchedulerFlagsConfig.Field.SELECT_REGION_PERFORMANCE_COUNTERS, selectRegionPerformanceCounters);
        return this;
    }

    public EnterpriseSchedulerFlagsConfigBuilder setSelectPerformanceCountersLibrary(int selectPerformanceCountersLibrary) {
        this.values.put(EnterpriseSchedulerFlagsConfig.Field.SELECT_PERFORMANCE_COUNTERS_LIBRARY, selectPerformanceCountersLibrary);
        return this;
    }

    public EnterpriseSchedulerFlagsConfigBuilder setSelectPerformanceCountersPcmShowCodes(int selectPerformanceCountersPcmShowCodes) {
        this.values.put(EnterpriseSchedulerFlagsConfig.Field.SELECT_PERFORMANCE_COUNTERS_PCM_SHOW_CODES, selectPerformanceCountersPcmShowCodes);
        return this;
    }

    public EnterpriseSchedulerFlagsConfigBuilder setSelectPerformanceCountersJobRegions(int selectPerformanceCountersJobRegions) {
        this.values.put(EnterpriseSchedulerFlagsConfig.Field.SELECT_PERFORMANCE_COUNTERS_JOB_REGIONS, selectPerformanceCountersJobRegions);
        return this;
    }

    public EnterpriseSchedulerFlagsConfigBuilder setSelectPerformanceCountersShowStats(int selectPerformanceCountersShowStats) {
        this.values.put(EnterpriseSchedulerFlagsConfig.Field.SELECT_PERFORMANCE_COUNTERS_SHOW_STATS, selectPerformanceCountersShowStats);
        return this;
    }

    public EnterpriseSchedulerFlagsConfigBuilder setShowDeterministicOutput(boolean showDeterministicOutput) {
        this.values.put(EnterpriseSchedulerFlagsConfig.Field.SHOW_DETERMINISTIC_OUTPUT, showDeterministicOutput);
        return this;
    }

    public EnterpriseSchedulerFlagsConfigBuilder setSpinOnExit(boolean spinOnExit) {
        this.values.put(EnterpriseSchedulerFlagsConfig.Field.SPIN_ON_EXIT, spinOnExit);
        return this;
    }

    public EnterpriseSchedulerFlagsConfigBuilder setEnableDebugSignal(boolean enableDebugSignal) {
        this.values.put(EnterpriseSchedulerFlagsConfig.Field.ENABLE_DEBUG_SIGNAL, enableDebugSignal);
        return this;
    }

    public EnterpriseSchedulerFlagsConfigBuilder setFixThreadsUsedFromMain(boolean fixThreadsUsedFromMain) {
        this.values.put(EnterpriseSchedulerFlagsConfig.Field.FIX_THREADS_USED_FROM_MAIN, fixThreadsUsedFromMain);
        return this;
    }
}

