/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.config.AuthorizationEntityPermissionConfig;
import oracle.pgx.config.PgxConfigPermission;

public final class AuthorizationEntityPermissionConfigBuilder {
    private final Map<AuthorizationEntityPermissionConfig.Field, Object> values = new HashMap<AuthorizationEntityPermissionConfig.Field, Object>();

    public static AuthorizationEntityPermissionConfig buildAuthorizationEntityPermissionConfig(Consumer<AuthorizationEntityPermissionConfigBuilder> builderSetup) {
        AuthorizationEntityPermissionConfigBuilder builder = new AuthorizationEntityPermissionConfigBuilder();
        builderSetup.accept(builder);
        return builder.build();
    }

    public AuthorizationEntityPermissionConfigBuilder() {
    }

    public AuthorizationEntityPermissionConfigBuilder(Map<AuthorizationEntityPermissionConfig.Field, Object> values) {
        this.putAll(values);
    }

    public AuthorizationEntityPermissionConfigBuilder(AuthorizationEntityPermissionConfig config) {
        this.putAll(config);
    }

    public AuthorizationEntityPermissionConfigBuilder(AuthorizationEntityPermissionConfigBuilder builder) {
        this.putAll(builder.values);
    }

    public AuthorizationEntityPermissionConfigBuilder putAll(Map<AuthorizationEntityPermissionConfig.Field, Object> values) {
        this.values.putAll(values);
        return this;
    }

    public AuthorizationEntityPermissionConfigBuilder putAll(AuthorizationEntityPermissionConfig config) {
        this.putAll(config.getValuesWithoutDefaults());
        return this;
    }

    public AuthorizationEntityPermissionConfigBuilder clear() {
        this.values.clear();
        return this;
    }

    public AuthorizationEntityPermissionConfig build(String parentPath) {
        try {
            return AuthorizationEntityPermissionConfig.parse(this.toInputStream(), true, parentPath);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public AuthorizationEntityPermissionConfig build() {
        return this.build(null);
    }

    public InputStream toInputStream() {
        try {
            return ConfigJsonUtil.toJsonInputStream(this.values);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public Map<AuthorizationEntityPermissionConfig.Field, Object> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    public String toString() {
        return "AuthorizationEntityPermissionConfigBuilder" + this.values;
    }

    public AuthorizationEntityPermissionConfigBuilder setFileLocation(String fileLocation) {
        this.values.put(AuthorizationEntityPermissionConfig.Field.FILE_LOCATION, fileLocation);
        return this;
    }

    public AuthorizationEntityPermissionConfigBuilder setPreloadedGraph(String preloadedGraph) {
        this.values.put(AuthorizationEntityPermissionConfig.Field.PRELOADED_GRAPH, preloadedGraph);
        return this;
    }

    public AuthorizationEntityPermissionConfigBuilder setGrant(PgxConfigPermission grant) {
        this.values.put(AuthorizationEntityPermissionConfig.Field.GRANT, (Object)grant);
        return this;
    }
}

