/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import oracle.pgx.common.util.Constants;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.AbstractAuthorizationEntityConfig;
import oracle.pgx.config.AbstractConfig;
import oracle.pgx.config.AuthorizationEntityConfig;
import oracle.pgx.config.DataMemoryLimit;
import oracle.pgx.config.DataMemoryLimitsConfig;

public abstract class AbstractEngineConfig
extends AbstractConfig {
    @Override
    public void validate() {
        super.validate();
        this.validateAllowRemoteLoadingLocations();
    }

    private void validateAllowRemoteLoadingLocations() {
        List<String> locations = this.getAllowedRemoteLoadingLocations();
        for (String location : locations) {
            if (location.equals("*") && locations.size() > 1) {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"LOADING_FROM_REMOTE_LOCATIONS_INVALID_LIST", (Object[])new Object[0]));
            }
            if (location.equals("*") || Constants.REMOTE_LOCATIONS_ALLOWED_VALUES.contains(location)) continue;
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"LOADING_FROM_REMOTE_LOCATIONS_INVALID_VALUE", (Object[])new Object[]{location}));
        }
    }

    private Map<String, DataMemoryLimit> getMaxMemoryLimitMapping(Function<AuthorizationEntityConfig, String> entityGetter) {
        return this.getAuthorization().stream().filter(item -> entityGetter.apply((AuthorizationEntityConfig)item) != null).collect(Collectors.toMap(entityGetter, AbstractAuthorizationEntityConfig::getMaxMemoryLimit));
    }

    public Map<String, DataMemoryLimit> getUserMaxMemoryLimits() {
        return this.getMaxMemoryLimitMapping(AbstractAuthorizationEntityConfig::getPgxUser);
    }

    public Map<String, DataMemoryLimit> getRoleMaxMemoryLimits() {
        return this.getMaxMemoryLimitMapping(AbstractAuthorizationEntityConfig::getPgxRole);
    }

    public abstract String getTmpDir();

    public abstract Integer getIntervalToPollMax();

    public abstract List<String> getAllowedRemoteLoadingLocations();

    public abstract Boolean isEnableCsrfTokenChecks();

    public abstract Integer getAdminRequestCacheTimeout();

    public abstract Long getMaxHttpClientRequestSize();

    public abstract List<AuthorizationEntityConfig> getAuthorization();

    public abstract DataMemoryLimitsConfig getDataMemoryLimits();
}

