/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class DaemonThreadFactory
implements ThreadFactory {
    private final String threadBaseName;
    private final AtomicInteger counter;

    public DaemonThreadFactory(String threadBaseName) {
        this.threadBaseName = threadBaseName;
        this.counter = new AtomicInteger();
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(r, this.threadBaseName + "-" + this.counter.getAndIncrement());
        t.setDaemon(true);
        return t;
    }
}

