/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.pojo;

import oracle.pgx.api.SessionContext;
import oracle.pgx.common.Link;
import oracle.pgx.common.LinkRel;
import oracle.pgx.common.PgxId;
import oracle.pgx.common.Self;
import oracle.pgx.common.pojo.GraphConfigContainer;
import oracle.pgx.config.GraphConfig;
import oracle.pgx.config.LinkTemplate;

public class PgqlResultProxyResponse
extends Self {
    private final boolean exists;
    private final PgxId graphId;
    private String resultSetId;
    private final long numResults;
    public final GraphConfigContainer graphConfig;

    public PgqlResultProxyResponse() {
        this.exists = false;
        this.numResults = 0L;
        this.graphId = null;
        this.graphConfig = null;
    }

    public PgqlResultProxyResponse(boolean exists, SessionContext sessionContext, PgxId graphId, String resultSetId, long numResults, GraphConfig graphConfig) {
        super((Object)resultSetId);
        this.exists = exists;
        this.graphId = graphId;
        this.resultSetId = resultSetId;
        this.numResults = numResults;
        this.graphConfig = graphConfig == null ? null : GraphConfigContainer.createObfuscated(graphConfig, sessionContext.getSessionId());
        this.injectLinks();
    }

    public boolean getExists() {
        return this.exists;
    }

    public PgxId getGraphId() {
        return this.graphId;
    }

    public String getResultSetId() {
        return this.resultSetId;
    }

    public long getNumResults() {
        return this.numResults;
    }

    public GraphConfigContainer getGraphConfig() {
        return this.graphConfig;
    }

    public void injectLinks() {
        Link selfLink = new Link(LinkRel.SELF, LinkTemplate.PGQL_RESULT_PROXY_SELF.generateLink(new Object[0]), true);
        Link elementsLink = new Link(LinkRel.RELATED, LinkTemplate.PGQL_RESULT_PROXY_ELEMENTS.generateLink(new Object[0]), true);
        Link resultsLink = new Link(LinkRel.RELATED, LinkTemplate.PGQL_RESULT_PROXY_RESULTS.generateLink(new Object[0]), true);
        this.addLinks(new Link[]{selfLink, elementsLink, resultsLink});
    }
}

