/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.marshalers;

import java.io.IOException;
import oracle.pgx.api.SessionContext;
import oracle.pgx.api.internal.PgqlResultSetProxy;
import oracle.pgx.common.marshalers.Marshaler;
import oracle.pgx.common.pojo.PgqlResultProxyResponse;
import oracle.pgx.common.util.JsonUtil;
import oracle.pgx.common.util.RemotePgqlResultSetProxyFactory;

public class PgqlResultSetMarshaler
implements Marshaler<PgqlResultSetProxy> {
    private final SessionContext sessionContext;
    private final RemotePgqlResultSetProxyFactory factory;

    public PgqlResultSetMarshaler(SessionContext sessionContext, RemotePgqlResultSetProxyFactory factory) {
        this.sessionContext = sessionContext;
        this.factory = factory;
    }

    public PgqlResultSetMarshaler(SessionContext sessionContext) {
        this(sessionContext, null);
    }

    @Override
    public PgqlResultSetProxy unmarshal(String json) throws IOException {
        if (this.sessionContext.getSessionId() == null) {
            throw new IllegalStateException("sessionId is NULL");
        }
        if (this.factory == null) {
            throw new IllegalStateException("factory is NULL");
        }
        PgqlResultProxyResponse proxy = (PgqlResultProxyResponse)((Object)JsonUtil.readTopLevelJson((String)json, PgqlResultProxyResponse.class));
        if (!proxy.getExists()) {
            return null;
        }
        PgqlResultSetProxy resultSet = this.factory.createPgqlResultSetProxy(this.sessionContext, proxy.getResultSetId(), proxy.getGraphId(), proxy.getNumResults(), proxy.getGraphConfig());
        return resultSet;
    }

    @Override
    public String marshal(PgqlResultSetProxy rs) throws IOException {
        boolean exists;
        PgqlResultProxyResponse proxy = new PgqlResultProxyResponse();
        boolean bl = exists = rs != null;
        if (exists) {
            proxy = new PgqlResultProxyResponse(exists, this.sessionContext, rs.getGraphId(), rs.getId(), rs.getNumResults(), rs.getCreatePropertyGraphConfig());
        }
        return JsonUtil.toJson((Object)((Object)proxy));
    }
}

