/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.marshalers;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import oracle.pgx.api.executionenvironment.ExecutionEnvironmentField;
import oracle.pgx.common.marshalers.Marshaler;
import oracle.pgx.common.util.JsonUtil;

public class ExecutionEnvironmentValueMarshaler
implements Marshaler<Object> {
    private final ExecutionEnvironmentField field;
    private final Class<?> typeClass;

    public ExecutionEnvironmentValueMarshaler(ExecutionEnvironmentField field) {
        this.field = field;
        this.typeClass = field.getType();
    }

    @Override
    public String marshal(Object object) throws IOException {
        this.field.checkType(object);
        return JsonUtil.toJson((Object)object);
    }

    @Override
    public Object unmarshal(String content) throws IOException {
        JsonNode node = JsonUtil.readTopLevelJsonToTree((String)content);
        return JsonUtil.fromJsonNode((JsonNode)node.get("entity"), this.typeClass);
    }
}

