/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import oracle.pgx.api.GraphLoadingProgress;
import oracle.pgx.api.internal.FutureProgressAccumulator;
import oracle.pgx.common.Progress;
import oracle.pgx.common.util.ErrorMessages;

public class GraphLoadingState
implements FutureProgressAccumulator {
    private static final String UNDEFINED_STRING = "undefined";
    private static final String EMPTY_STRING = "";
    private long numVertices;
    private long numEdges;
    private String graphName = "undefined";
    private String sessionId = "undefined";
    private final long startLoadingTimestamp;
    private LoadingPhase loadingPhase;
    private String subLoadingPhaseName = null;
    private long startPhaseTimestamp = 0L;
    private AtomicLong numVerticesReadPerProvider = new AtomicLong(0L);
    private AtomicLong numVerticesRead = new AtomicLong(0L);
    private AtomicLong numEdgesReadPerProvider = new AtomicLong(0L);
    private AtomicLong numEdgesRead = new AtomicLong(0L);
    private int numLoadedVertexProviders = 0;
    private int numVertexProviders = 0;
    private int numEdgeProviders = 0;
    private int numLoadedEdgeProviders = 0;
    private final ConcurrentHashMap<String, String> vertexProviderLoadingProgressStates = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, String> edgeProviderLoadingProgressStates = new ConcurrentHashMap();

    public GraphLoadingProgress getFutureProgress() {
        return new GraphLoadingProgress(Progress.PROCESSING, this.graphName, this.getNumVerticesRead(), this.getNumEdgesRead(), this.numVertices, this.numEdges, this.getNumLoadedVertexProviders(), this.getNumLoadedEdgeProviders(), this.getNumVertexProviders(), this.getNumEdgeProviders(), this.getGraphLoadingProgressState());
    }

    public void setNumEntities(long numNodes, long numEdges) {
        this.numVertices = numNodes;
        this.numEdges = numEdges;
    }

    public void setVertexProviderState(String providerName, ProviderLoadingProgressState state) {
        this.vertexProviderLoadingProgressStates.put(providerName, state.name);
    }

    public void setEdgeProviderState(String providerName, ProviderLoadingProgressState state) {
        this.edgeProviderLoadingProgressStates.put(providerName, state.name);
    }

    private String getGraphLoadingProgressState() {
        StringBuilder graphLoadingState = new StringBuilder();
        switch (this.loadingPhase) {
            case SETTING_UP_LOADING: 
            case READING_GRAPH: {
                graphLoadingState.append("Reading the graph " + this.graphName);
                break;
            }
            case BUILDING_GRAPH_INDICES: 
            case FINALIZING_GRAPH: {
                graphLoadingState.append("finalizing the graph " + this.graphName);
            }
        }
        this.vertexProviderLoadingProgressStates.forEach((providerName, state) -> {
            graphLoadingState.append(", ");
            graphLoadingState.append((String)state);
            graphLoadingState.append(" for vertex provider ");
            graphLoadingState.append((String)providerName);
        });
        this.edgeProviderLoadingProgressStates.forEach((providerName, state) -> {
            graphLoadingState.append(", ");
            graphLoadingState.append((String)state);
            graphLoadingState.append(" for edge provider ");
            graphLoadingState.append((String)providerName);
        });
        graphLoadingState.append(".");
        return graphLoadingState.toString();
    }

    public GraphLoadingState() {
        this.startLoadingTimestamp = System.currentTimeMillis();
        this.loadingPhase = LoadingPhase.UNDEFINED;
    }

    private void invalidateLoadingPhase() {
        this.loadingPhase = LoadingPhase.UNDEFINED;
        this.subLoadingPhaseName = null;
    }

    public void setLoadingPhase(LoadingPhase loadingPhase) {
        this.invalidateLoadingPhase();
        this.startPhaseTimestamp = System.currentTimeMillis();
        this.loadingPhase = loadingPhase;
    }

    public void setSubLoadingPhaseName(String subLoadingPhaseName) {
        this.subLoadingPhaseName = subLoadingPhaseName;
    }

    public String getLoadingPhaseName() {
        if (this.subLoadingPhaseName != null) {
            return this.subLoadingPhaseName;
        }
        return this.loadingPhase.getName();
    }

    public String getGraphName() {
        return this.graphName;
    }

    public void setGraphName(String graphName) {
        this.graphName = graphName;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId != null ? sessionId : UNDEFINED_STRING;
    }

    public long getStartLoadingTimestamp() {
        return this.startLoadingTimestamp;
    }

    public void setNumVerticesReadPerProvider(long numVertices) {
        long prevVal = this.numVerticesReadPerProvider.getAndSet(numVertices);
        this.numVerticesRead.addAndGet(numVertices - prevVal);
    }

    public void setNumEdgesReadPerProvider(long numEdges) {
        long prevVal = this.numEdgesReadPerProvider.getAndSet(numEdges);
        this.numEdgesRead.addAndGet(numEdges - prevVal);
    }

    public long getNumEdgesRead() {
        return this.numEdgesRead.get();
    }

    public long getNumVerticesRead() {
        return this.numVerticesRead.get();
    }

    public void setNumVertexProviders(int numVertexProviders) {
        this.numVertexProviders = numVertexProviders;
    }

    public int getNumVertexProviders() {
        return this.numVertexProviders;
    }

    public void setNumEdgeProviders(int numEdgeProviders) {
        this.numEdgeProviders = numEdgeProviders;
    }

    public int getNumEdgeProviders() {
        return this.numEdgeProviders;
    }

    public int incrementNumLoadedVertexProviders(String providerName) {
        this.vertexProviderLoadingProgressStates.remove(providerName);
        this.numVerticesReadPerProvider.set(0L);
        return this.numLoadedVertexProviders++;
    }

    public int getNumLoadedVertexProviders() {
        return this.numLoadedVertexProviders;
    }

    public int incrementNumLoadedEdgeProviders(String providerName) {
        this.edgeProviderLoadingProgressStates.remove(providerName);
        this.numEdgesReadPerProvider.set(0L);
        return this.numLoadedEdgeProviders++;
    }

    public int getNumLoadedEdgeProviders() {
        return this.numLoadedEdgeProviders;
    }

    public long getStartPhaseTimestamp() {
        return this.startPhaseTimestamp;
    }

    public String getLoadingPhaseState() {
        switch (this.loadingPhase) {
            case READING_GRAPH: {
                return ErrorMessages.getMessage((String)"LOADING_STATE_READING_PHASE", (Object[])new Object[]{this.numLoadedVertexProviders, this.numVerticesReadPerProvider, this.numLoadedEdgeProviders, this.numEdgesReadPerProvider});
            }
        }
        return EMPTY_STRING;
    }

    public static enum ProviderLoadingProgressState {
        READING_DATA("Reading data"),
        BUILDING_INTERNAL_REPRESENTATION("Building internal representation"),
        FINALIZING_PROVIDER("Finalizing loading");

        private String name;

        private ProviderLoadingProgressState(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum LoadingPhase {
        UNDEFINED("undefined"),
        SETTING_UP_LOADING("setting up loading"),
        READING_GRAPH("reading graph"),
        BUILDING_GRAPH_INDICES("building graph indices"),
        FINALIZING_GRAPH("finalizing graph");

        private String name;

        private LoadingPhase(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

