/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.redaction;

import java.util.Iterator;
import java.util.ServiceLoader;
import oracle.pgx.api.redaction.DefaultRedactionRuleHandler;
import oracle.pgx.api.redaction.RedactionRuleHandler;
import oracle.pgx.common.util.Plugins;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedactionRuleHandlerProvider {
    private static final Logger LOG = LoggerFactory.getLogger(RedactionRuleHandlerProvider.class);
    private ServiceLoader<RedactionRuleHandler> loader = Plugins.loadPlugins(RedactionRuleHandler.class);

    private RedactionRuleHandlerProvider() {
    }

    public static RedactionRuleHandlerProvider getInstance() {
        return ProviderHolder.provider;
    }

    public synchronized RedactionRuleHandler getService() {
        Iterator<RedactionRuleHandler> serviceIterator = this.loader.iterator();
        if (serviceIterator.hasNext()) {
            RedactionRuleHandler instance = serviceIterator.next().getNewInstance();
            LOG.debug("implementation of type {} used", instance.getClass());
            return instance;
        }
        LOG.debug("default implementation used");
        return new DefaultRedactionRuleHandler();
    }

    private static final class ProviderHolder {
        private static RedactionRuleHandlerProvider provider = new RedactionRuleHandlerProvider();

        private ProviderHolder() {
        }
    }
}

