/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.mllib;

import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.internal.Core;
import oracle.pgx.api.internal.Graph;
import oracle.pgx.api.internal.mllib.UnsupervisedGraphWiseModelMetadata;
import oracle.pgx.api.mllib.GraphWiseModelBuilder;
import oracle.pgx.api.mllib.UnsupervisedGraphWiseModel;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.mllib.GraphWiseDgiLayerConfig;
import oracle.pgx.config.mllib.GraphWiseEmbeddingConfig;
import oracle.pgx.config.mllib.UnsupervisedGraphWiseModelConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnsupervisedGraphWiseModelBuilder
extends GraphWiseModelBuilder<UnsupervisedGraphWiseModel, UnsupervisedGraphWiseModelConfig, UnsupervisedGraphWiseModelBuilder> {
    private static final Logger LOG = LoggerFactory.getLogger(UnsupervisedGraphWiseModelBuilder.class);
    private final PgxSession session;
    private final Core core;
    private final Supplier<String> keystorePathSupplier;
    private final Supplier<char[]> keystorePasswordSupplier;
    private final BiFunction<PgxSession, Graph, PgxGraph> graphConstructor;

    public UnsupervisedGraphWiseModelBuilder(PgxSession session, Core core, Supplier<String> keystorePathSupplier, Supplier<char[]> keystorePasswordSupplier, BiFunction<PgxSession, Graph, PgxGraph> graphConstructor) {
        this.session = session;
        this.core = core;
        this.keystorePathSupplier = keystorePathSupplier;
        this.keystorePasswordSupplier = keystorePasswordSupplier;
        this.modelConfig = new UnsupervisedGraphWiseModelConfig();
        this.graphConstructor = graphConstructor;
    }

    @Deprecated
    public UnsupervisedGraphWiseModelBuilder setDgiLayerConfig(GraphWiseDgiLayerConfig layerConfig) {
        ((UnsupervisedGraphWiseModelConfig)this.modelConfig).setEmbeddingConfig((GraphWiseEmbeddingConfig)layerConfig);
        return this;
    }

    public UnsupervisedGraphWiseModelBuilder setEmbeddingConfig(GraphWiseEmbeddingConfig embeddingConfig) {
        ((UnsupervisedGraphWiseModelConfig)this.modelConfig).setEmbeddingConfig(embeddingConfig);
        return this;
    }

    public UnsupervisedGraphWiseModelBuilder setLossFunction(UnsupervisedGraphWiseModelConfig.LossFunction lossFunction) {
        ((UnsupervisedGraphWiseModelConfig)this.modelConfig).setLossFunction(lossFunction);
        return this;
    }

    private void validateDgiLayerConfig() {
        if (((UnsupervisedGraphWiseModelConfig)this.modelConfig).getDgiLayerConfig() == null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_PREDICTION_LAYERS", (Object[])new Object[0]));
        }
    }

    @Override
    public UnsupervisedGraphWiseModel build() throws InterruptedException, ExecutionException {
        super.validateAll();
        this.validateDgiLayerConfig();
        LOG.debug("Building Model...");
        UnsupervisedGraphWiseModelMetadata metadata = new UnsupervisedGraphWiseModelMetadata(null, (UnsupervisedGraphWiseModelConfig)this.modelConfig);
        return (UnsupervisedGraphWiseModel)((PgxFuture)this.core.createUnsupervisedGraphWiseModel(this.session.getSessionContext(), metadata).thenApply(metaData -> new UnsupervisedGraphWiseModel(this.session, this.core, this.keystorePathSupplier, this.keystorePasswordSupplier, (UnsupervisedGraphWiseModelMetadata)((Object)metaData), this.graphConstructor))).get();
    }

    @Override
    protected UnsupervisedGraphWiseModelBuilder getThis() {
        return this;
    }
}

