/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.mllib;

import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.PgxVertex;
import oracle.pgx.api.internal.mllib.UnsupervisedGnnExplainerConfig;
import oracle.pgx.api.mllib.GnnExplainer;
import oracle.pgx.api.mllib.UnsupervisedGnnExplanation;
import oracle.pgx.api.mllib.UnsupervisedGraphWiseModel;

public class UnsupervisedGnnExplainer
extends GnnExplainer {
    UnsupervisedGraphWiseModel model;

    UnsupervisedGnnExplainer(UnsupervisedGraphWiseModel model) {
        this.model = model;
        this.gnnExplainerConfig = new UnsupervisedGnnExplainerConfig();
    }

    public <ID> PgxFuture<UnsupervisedGnnExplanation<ID>> inferAndExplainAsync(PgxGraph graph, PgxVertex<ID> vertex) {
        return this.model.inferAndExplainWithConfigAsync(graph, vertex, (UnsupervisedGnnExplainerConfig)this.gnnExplainerConfig);
    }

    public <ID> UnsupervisedGnnExplanation<ID> inferAndExplain(PgxGraph graph, PgxVertex<ID> vertex) {
        return this.inferAndExplainAsync(graph, vertex).join();
    }

    public int numClusters() {
        return ((UnsupervisedGnnExplainerConfig)this.gnnExplainerConfig).getNumClusters();
    }

    public int numSamples() {
        return ((UnsupervisedGnnExplainerConfig)this.gnnExplainerConfig).getNumSamples();
    }

    public UnsupervisedGnnExplainer numOptimizationSteps(int numOptimizationSteps) {
        this.gnnExplainerConfig.setNumOptimizationSteps(numOptimizationSteps);
        return this;
    }

    public UnsupervisedGnnExplainer learningRate(double learningRate) {
        this.gnnExplainerConfig.setLearningRate(learningRate);
        return this;
    }

    public UnsupervisedGnnExplainer marginalize(boolean marginalize) {
        this.gnnExplainerConfig.setMarginalize(marginalize);
        return this;
    }

    public UnsupervisedGnnExplainer numClusters(int numClusters) {
        ((UnsupervisedGnnExplainerConfig)this.gnnExplainerConfig).setNumClusters(numClusters);
        return this;
    }

    public UnsupervisedGnnExplainer numSamples(int numSamples) {
        ((UnsupervisedGnnExplainerConfig)this.gnnExplainerConfig).setNumSamples(numSamples);
        return this;
    }
}

