/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.mllib;

import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.mllib.EvaluationFrequencyScale;
import oracle.pgx.config.mllib.GraphWiseValidationConfig;

public class GraphWiseValidationConfigBuilder {
    private GraphWiseValidationConfig validationConfig = new GraphWiseValidationConfig();

    public GraphWiseValidationConfigBuilder setEvaluationFrequency(Integer evaluationFrequency) {
        this.validationConfig.setEvaluationFrequency(evaluationFrequency.intValue());
        return this;
    }

    public GraphWiseValidationConfigBuilder setEvaluationFrequencyScale(EvaluationFrequencyScale evaluationFrequencyScale) {
        this.validationConfig.setEvaluationFrequencyScale(evaluationFrequencyScale);
        return this;
    }

    private void validateEvaluationFrequency() {
        if (this.validationConfig.getEvaluationFrequency() <= 0) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_EVALUATION_FREQUENCY", (Object[])new Object[]{this.validationConfig.getEvaluationFrequency()}));
        }
    }

    public GraphWiseValidationConfig build() {
        this.validateEvaluationFrequency();
        return this.validationConfig;
    }
}

