/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.mllib;

import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.mllib.ActivationFunction;
import oracle.pgx.config.mllib.GraphWisePredictionLayerConfig;
import oracle.pgx.config.mllib.WeightInitScheme;

public class GraphWisePredictionLayerConfigBuilder {
    private GraphWisePredictionLayerConfig predictionLayerConfig = new GraphWisePredictionLayerConfig();

    public GraphWisePredictionLayerConfigBuilder setHiddenDimension(Integer hiddenDimension) {
        this.predictionLayerConfig.setHiddenDimension(hiddenDimension);
        return this;
    }

    public GraphWisePredictionLayerConfigBuilder setActivationFunction(ActivationFunction activationFunction) {
        this.predictionLayerConfig.setActivationFunction(activationFunction);
        return this;
    }

    public GraphWisePredictionLayerConfigBuilder setWeightInitScheme(WeightInitScheme weightInitScheme) {
        this.predictionLayerConfig.setWeightInitScheme(weightInitScheme);
        return this;
    }

    public GraphWisePredictionLayerConfigBuilder setDropoutRate(double dropoutRate) {
        this.predictionLayerConfig.setDropoutRate(dropoutRate);
        return this;
    }

    private void validateDropoutRate() {
        if (this.predictionLayerConfig.getDropoutRate() < 0.0 || this.predictionLayerConfig.getDropoutRate() >= 1.0) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_DROPOUT_RATE", (Object[])new Object[]{this.predictionLayerConfig.getDropoutRate()}));
        }
    }

    public GraphWisePredictionLayerConfig build() {
        this.validateDropoutRate();
        return this.predictionLayerConfig;
    }
}

