/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal.synchronizer;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import oracle.pgx.api.internal.synchronizer.KeyValue;
import oracle.pgx.api.keys.KeyColumnDescriptor;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.ErrorMessages;

public final class ResultSetConverter {
    private ResultSetConverter() {
    }

    public static Object getParsedObject(ResultSet rs, String propName, PropertyType type) throws SQLException {
        if (rs.getObject(propName) == null) {
            return type.getDefaultValue();
        }
        if (type.isNumericType()) {
            return ResultSetConverter.getNumericObject(rs, propName, type);
        }
        if (type.isTemporalType()) {
            return ResultSetConverter.getTemporalObjectObject(rs, propName, type);
        }
        switch (type) {
            case BOOLEAN: {
                return rs.getBoolean(propName);
            }
            case STRING: {
                return rs.getString(propName);
            }
        }
        throw new IllegalArgumentException(ErrorMessages.getMessage((String)"FLASHBACK_TYPE_NOT_COMPATIBLE_EXCEPTION", (Object[])new Object[]{type.toString()}));
    }

    private static Object getNumericObject(ResultSet rs, String propName, PropertyType type) throws SQLException {
        switch (type) {
            case INTEGER: {
                return rs.getInt(propName);
            }
            case LONG: {
                return rs.getLong(propName);
            }
            case FLOAT: {
                return Float.valueOf(rs.getFloat(propName));
            }
            case DOUBLE: {
                return rs.getDouble(propName);
            }
        }
        throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_TYPE", (Object[])new Object[]{propName}));
    }

    private static Object getTemporalObjectObject(ResultSet rs, String propName, PropertyType type) throws SQLException {
        switch (type) {
            case LOCAL_DATE: {
                return rs.getDate(propName).toLocalDate();
            }
            case TIME: {
                return LocalDateTime.from(rs.getDate(propName).toInstant()).toLocalTime();
            }
            case TIMESTAMP: {
                return rs.getTimestamp(propName).toLocalDateTime();
            }
            case TIME_WITH_TIMEZONE: {
                return rs.getObject(propName, OffsetTime.class);
            }
            case TIMESTAMP_WITH_TIMEZONE: {
                return rs.getObject(propName, OffsetDateTime.class);
            }
        }
        throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_TYPE", (Object[])new Object[]{propName}));
    }

    public static Object getKeyColumnValue(ResultSet resultSet, KeyColumnDescriptor keyColumnDescriptor) throws SQLException {
        return ResultSetConverter.getKeyColumnValue(resultSet, keyColumnDescriptor.getType(), keyColumnDescriptor.getName());
    }

    public static Object getKeyColumnValue(ResultSet resultSet, IdType keyType, String keyColName) throws SQLException {
        switch (keyType) {
            case INTEGER: {
                return resultSet.getInt(keyColName);
            }
            case LONG: {
                return resultSet.getLong(keyColName);
            }
            case STRING: {
                return resultSet.getString(keyColName);
            }
        }
        throw new IllegalArgumentException(ErrorMessages.getMessage((String)"KEY_COLUMN_TYPE_NOT_ALLOWED", (Object[])new Object[0]));
    }

    public static KeyValue getKeyColumnValueAndCheckIfNull(ResultSet resultSet, IdType keyType, String keyColName) throws SQLException {
        switch (keyType) {
            case INTEGER: {
                return new KeyValue(resultSet.getInt(keyColName), resultSet.wasNull());
            }
            case LONG: {
                return new KeyValue(resultSet.getLong(keyColName), resultSet.wasNull());
            }
            case STRING: {
                return new KeyValue(resultSet.getString(keyColName), resultSet.wasNull());
            }
        }
        throw new IllegalArgumentException(ErrorMessages.getMessage((String)"KEY_COLUMN_TYPE_NOT_ALLOWED", (Object[])new Object[0]));
    }
}

