/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal.partitionedgraphbuilder;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.frames.PgxFrame;
import oracle.pgx.api.frames.schema.ColumnDescriptor;
import oracle.pgx.api.frames.schema.datatypes.DataType;
import oracle.pgx.api.frames.schema.datatypes.DataTypes;
import oracle.pgx.api.internal.partitionedgraphbuilder.PartitionedGraphBuilderEntity;
import oracle.pgx.api.internal.partitionedgraphbuilder.PartitionedGraphEdgeBuilderEntity;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.types.PropertyType;

public class FrameFromGraphBuilderEntityCreator {
    protected final PgxSession session;
    protected PartitionedGraphBuilderEntity entity;
    protected final IdType vertexIdType;
    private final IdType edgeIdtype;

    public FrameFromGraphBuilderEntityCreator(PgxSession session, PartitionedGraphBuilderEntity entity, IdType vertexIdType, IdType edgeIdtype) {
        this.session = session;
        this.entity = entity;
        this.vertexIdType = vertexIdType;
        this.edgeIdtype = edgeIdtype;
    }

    public PgxFuture<PgxFrame> createFrameAsync() throws ExecutionException, InterruptedException {
        Map<String, Iterable<?>> frameData = this.entity.getcolumnData();
        boolean isEdgeEntity = this.entity instanceof PartitionedGraphEdgeBuilderEntity;
        List<ColumnDescriptor> list = FrameFromGraphBuilderEntityCreator.createFrameSchemaForEntityProperties(this.entity, isEdgeEntity, this.edgeIdtype, this.vertexIdType);
        return this.session.createFrameAsync(list, frameData, this.entity.getEntityName());
    }

    protected static List<ColumnDescriptor> createFrameSchemaForEntityProperties(PartitionedGraphBuilderEntity entity, boolean isEdgeEntity, IdType edgeIdtype, IdType vertexIdType) {
        String idPropertyName = entity.getIdPropertyName();
        Map<String, PropertyType> propertyTypeMap = entity.getPropertiesWithType();
        List<ColumnDescriptor> list = propertyTypeMap.entrySet().stream().map(entry -> ColumnDescriptor.columnDescriptor((String)entry.getKey(), DataTypes.getDataTypeFromPropertyType((PropertyType)entry.getValue()))).collect(Collectors.toList());
        if (isEdgeEntity) {
            list.addAll(FrameFromGraphBuilderEntityCreator.createColumnDescriptorForEdgeFrameKeySourceAndDestinationColumns((PartitionedGraphEdgeBuilderEntity)entity, edgeIdtype, vertexIdType));
        } else {
            list.add(ColumnDescriptor.columnDescriptor(idPropertyName, DataTypes.getDataTypeFromPropertyType(IdType.toPropertyType((IdType)vertexIdType))));
        }
        return list;
    }

    private static List<ColumnDescriptor> createColumnDescriptorForEdgeFrameKeySourceAndDestinationColumns(PartitionedGraphEdgeBuilderEntity entity, IdType edgeIdtype, IdType vertexIdType) {
        String idPropertyName = entity.getIdPropertyName();
        String srcIdPropertyName = entity.getSrcIdPropertyName();
        String dstIdPropertyName = entity.getDstIdPropertyName();
        ArrayList<ColumnDescriptor> descriptors = new ArrayList<ColumnDescriptor>();
        descriptors.add(ColumnDescriptor.columnDescriptor(idPropertyName, DataTypes.getDataTypeFromPropertyType(IdType.toPropertyType((IdType)edgeIdtype))));
        DataType datatype = DataTypes.getDataTypeFromPropertyType(IdType.toPropertyType((IdType)vertexIdType));
        descriptors.add(ColumnDescriptor.columnDescriptor(srcIdPropertyName, datatype));
        descriptors.add(ColumnDescriptor.columnDescriptor(dstIdPropertyName, datatype));
        return descriptors;
    }
}

