/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import oracle.pgx.api.internal.Edge;
import oracle.pgx.api.internal.ProxyException;
import oracle.pgx.api.internal.Vertex;
import oracle.pgx.common.GmParseException;
import oracle.pgx.common.IllegalEnumConstantException;
import oracle.pgx.common.Link;
import oracle.pgx.common.LinkRel;
import oracle.pgx.common.Self;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.JsonUtil;
import oracle.pgx.config.LinkTemplate;

public interface MapProxy<K, V> {
    public String getId();

    public int size() throws ProxyException;

    public V get(K var1) throws ProxyException;

    public boolean containsKey(K var1) throws ProxyException;

    public Iterable<Map.Entry<K, V>> entries() throws ProxyException;

    public Iterable<K> keys() throws ProxyException;

    public PropertyType getKeyType();

    public IdType getKeyNodeEdgeValueType();

    public PropertyType getValueType();

    public IdType getValueNodeEdgeValueType();

    public String getMapName();

    default public Object getParsedKey(String strKey) throws GmParseException, IOException {
        JsonNode node;
        Object parsedKey = this.getKeyType().isNodeOrEdge() ? ((node = JsonUtil.readTopLevelJsonToTree((String)strKey)).has("tableName") ? this.getParsedPartitionedKey(node) : this.getKeyNodeEdgeValueType().parse(strKey)) : this.getKeyType().parse(strKey);
        return parsedKey;
    }

    default public Object getParsedPartitionedKey(JsonNode node) throws IllegalEnumConstantException, IOException {
        switch (this.getKeyType()) {
            case VERTEX: {
                return JsonUtil.fromJsonNode((JsonNode)node, Vertex.class);
            }
            case EDGE: {
                return JsonUtil.fromJsonNode((JsonNode)node, Edge.class);
            }
        }
        throw new IllegalEnumConstantException((Enum)this.getKeyType());
    }

    public static final class EntryWrapper<K, V>
    extends Self
    implements Map.Entry<K, V> {
        private final K key;
        private final V value;
        @JsonIgnore
        private final String mapName;

        EntryWrapper(Map.Entry<K, V> other, String mapName) {
            super(other.getKey());
            this.key = other.getKey();
            this.value = other.getValue();
            this.mapName = mapName;
            this.injectLinks();
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        public void injectLinks() {
            URI selfUri = LinkTemplate.MAP_ENTRY_SELF.generateLink(new Object[0]);
            this.addLinks(new Link[]{new Link(selfUri, LinkRel.SELF, Link.Method.PUT)});
        }
    }

    public static final class ValueWrapper<V>
    extends Self {
        private V value;
        @JsonIgnore
        private final String proxyUuid;

        public ValueWrapper(V value, Object key, String proxyUuid) {
            super(key);
            this.value = value;
            this.proxyUuid = proxyUuid;
            this.injectLinks();
        }

        public V getValue() {
            return this.value;
        }

        public void injectLinks() {
            Link keyLink = new Link(LinkRel.PARENT, LinkTemplate.MAP_PROXY_KEY.generateLink(new Object[0]), true);
            Link selfLink = new Link(LinkRel.SELF, LinkTemplate.MAP_PROXY_VALUE.generateLink(new Object[0]), true);
            this.addLinks(new Link[]{selfLink, keyLink});
        }
    }

    public static final class KeyWrapper<K>
    extends Self {
        private K key;
        @JsonIgnore
        private final String proxyUuid;

        public KeyWrapper() {
            this.proxyUuid = "proxyUuid";
        }

        public KeyWrapper(K key, String proxyUuid) {
            super(key);
            this.key = key;
            this.proxyUuid = proxyUuid;
            this.injectLinks();
        }

        public K getKey() {
            return this.key;
        }

        public void injectLinks() {
            Link keysLink = new Link(LinkRel.PARENT, LinkTemplate.MAP_PROXY_KEYS.generateLink(new Object[0]), true);
            Link selfLink = new Link(LinkRel.SELF, LinkTemplate.MAP_PROXY_KEY.generateLink(new Object[0]), true);
            Link valueLink = new Link(LinkRel.RELATED, LinkTemplate.MAP_PROXY_VALUE.generateLink(new Object[0]), true);
            this.addLinks(new Link[]{keysLink, selfLink, valueLink});
        }
    }
}

