/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.LinkedHashMap;
import java.util.Set;
import oracle.pgx.api.EdgeProviderMetaData;
import oracle.pgx.api.internal.EntityTable;
import oracle.pgx.api.internal.Property;
import oracle.pgx.common.PgxId;
import oracle.pgx.common.types.EntityType;
import oracle.pgx.common.types.IdType;

public class EdgeTable
extends EntityTable<EdgeProviderMetaData> {
    protected String sourceVertexTableName;
    protected String destinationVertexTableName;

    public EdgeTable() {
        super(EntityType.EDGE);
    }

    public EdgeTable(String name, String destinationVertexTableName, String sourceVertexTableName) {
        super(EntityType.EDGE, name);
        this.destinationVertexTableName = destinationVertexTableName;
        this.sourceVertexTableName = sourceVertexTableName;
    }

    public EdgeTable(String name, String sourceVertexTableName, String destinationVertexTableName, boolean transientFlag, String keyPropertyName, IdType entityKeyType, boolean isIdentifyKeyMapping) {
        super(EntityType.EDGE, name, transientFlag, keyPropertyName, entityKeyType, isIdentifyKeyMapping);
        this.sourceVertexTableName = sourceVertexTableName;
        this.destinationVertexTableName = destinationVertexTableName;
    }

    public EdgeTable(String name, boolean transientFlag, String keyPropertyName, IdType entityKeyType, boolean isIdentifyKeyMapping) {
        this(name, null, null, transientFlag, keyPropertyName, entityKeyType, isIdentifyKeyMapping);
    }

    public String getSourceVertexTableName() {
        return this.sourceVertexTableName;
    }

    public void setSourceVertexTableName(String sourceVertexTableName) {
        this.sourceVertexTableName = sourceVertexTableName;
    }

    public String getDestinationVertexTableName() {
        return this.destinationVertexTableName;
    }

    public void setDestinationVertexTableName(String destinationVertexTableName) {
        this.destinationVertexTableName = destinationVertexTableName;
    }

    public void setEdgeLabel(Property property) {
        this.setLabel(property);
    }

    public Property getEdgeLabel() {
        return this.getLabel();
    }

    public LinkedHashMap<PgxId, Property> getEdgeProperties() {
        return this.getProperties();
    }

    public void setEdgeProperties(LinkedHashMap<PgxId, Property> edgeProps) {
        this.setProperties(edgeProps);
    }

    public void addEdgeProperty(PgxId id, Property property) {
        this.addProperty(id, property);
    }

    @JsonIgnore
    public Set<String> getEdgePropertyNames() {
        return this.getPropertyNames();
    }
}

