/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.frames;

import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.frames.PgxFrame;
import oracle.pgx.api.frames.internal.PgxFrameInternal;
import oracle.pgx.api.internal.Core;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.config.EntityProviderConfig;
import oracle.pgx.config.internal.ConfigUtils;

public abstract class PgxFrameStorer<PgxFrameStorerType extends PgxFrameStorer> {
    protected PgxSession session;
    protected Core core;
    protected final Supplier<String> keystorePathSupplier;
    protected final Supplier<char[]> keystorePasswordSupplier;
    protected PgxFrameInternal frame;
    protected boolean overwrite;

    PgxFrameStorer(PgxSession session, Core core, PgxFrame frame, Supplier<String> keystorePathSupplier, Supplier<char[]> keystorePasswordSupplier) {
        this.session = session;
        this.core = core;
        this.keystorePathSupplier = keystorePathSupplier;
        this.keystorePasswordSupplier = keystorePasswordSupplier;
        this.frame = (PgxFrameInternal)frame;
    }

    protected abstract PgxFrameStorerType getThis();

    public abstract PgxFrameStorerType name(String var1);

    public PgxFrameStorerType overwrite(boolean overwrite) {
        this.overwrite = overwrite;
        return this.getThis();
    }

    protected PgxFrameStorerType withVectorColumn(String columnName, PropertyType type, int dimension) {
        return this.withVectorColumn(columnName, type, dimension, null);
    }

    protected abstract PgxFrameStorerType withVectorColumn(String var1, PropertyType var2, int var3, Object var4);

    public abstract PgxFuture<Void> storeAsync(String ... var1);

    public void store(String ... uris) throws InterruptedException, ExecutionException {
        this.storeAsync(uris).get();
    }

    protected final PgxFuture<Void> triggerStoreAsync(EntityProviderConfig config) {
        try {
            if (this.keystorePathSupplier != null && this.keystorePasswordSupplier != null) {
                config = ConfigUtils.createProviderConfigWithCredentials((String)this.keystorePathSupplier.get(), (char[])this.keystorePasswordSupplier.get(), (EntityProviderConfig)config);
            }
        }
        catch (Exception e) {
            return PgxFuture.exceptionallyCompletedFuture(e);
        }
        return this.core.storeFrame(this.session.getSessionContext(), this.frame.getFrameId(), config, this.overwrite);
    }
}

