/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.frames;

import java.util.function.Supplier;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.frames.PgxFrame;
import oracle.pgx.api.frames.PgxFrameReader;
import oracle.pgx.api.internal.Core;
import oracle.pgx.common.types.EntityType;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.AuthCertUtils;
import oracle.pgx.config.AbstractEntityProviderConfigBuilder;
import oracle.pgx.config.ProviderFormat;
import oracle.pgx.config.RdbmsEntityProviderConfig;
import oracle.pgx.config.RdbmsEntityProviderConfigBuilder;
import oracle.pgx.loaders.location.DbEntityProviderLocation;
import oracle.pgx.loaders.location.EntityProviderLocation;

public class PgxDbFrameReader
extends PgxFrameReader<PgxDbFrameReader> {
    protected final RdbmsEntityProviderConfigBuilder configBuilder = new RdbmsEntityProviderConfigBuilder();
    private String jdbcUrl;
    private String dataSourceId;
    private String owner;
    private String username;
    private String password;
    private String keystoreAlias;

    public PgxDbFrameReader(PgxSession session, Core core, Supplier<String> keystorePathSupplier, Supplier<char[]> keystorePasswordSupplier) {
        super(session, core, keystorePathSupplier, keystorePasswordSupplier);
        this.configBuilder.setHasKeys(false);
    }

    @Override
    protected PgxDbFrameReader getThis() {
        return this;
    }

    @Override
    protected PgxDbFrameReader withVectorColumn(String columnName, PropertyType type, int dimension, Object defaultValue) {
        this.configBuilder.addVectorProperty(columnName, type, dimension, defaultValue);
        return this;
    }

    @Override
    protected void clearColumns() {
        this.configBuilder.clearProperties();
    }

    @Override
    public PgxDbFrameReader name(String frameName) {
        this.configBuilder.setName(frameName);
        return this;
    }

    public PgxDbFrameReader tablename(String tableName) {
        this.configBuilder.setDatabaseTableName(tableName);
        return this;
    }

    public PgxDbFrameReader dataSourceId(String dataSourceId) {
        this.dataSourceId = dataSourceId;
        this.configBuilder.setDataSourceId(dataSourceId);
        return this;
    }

    public PgxDbFrameReader jdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
        this.configBuilder.setJdbcUrl(jdbcUrl);
        return this;
    }

    public PgxDbFrameReader username(String userName) {
        this.username = userName;
        this.configBuilder.setUsername(userName);
        return this;
    }

    public PgxDbFrameReader keystoreAlias(String keystoreAlias) {
        this.keystoreAlias = keystoreAlias;
        this.configBuilder.setKeystoreAlias(keystoreAlias);
        return this;
    }

    public PgxDbFrameReader password(String password) {
        this.password = password;
        this.configBuilder.setPassword(password);
        return this;
    }

    public PgxDbFrameReader schema(String schema) {
        this.owner = schema;
        this.configBuilder.setSchema(schema);
        return this;
    }

    public PgxDbFrameReader owner(String owner) {
        return this.schema(owner);
    }

    public PgxDbFrameReader connections(int numConnections) {
        this.configBuilder.setNumConnections(numConnections);
        return this;
    }

    @Override
    public PgxFuture<PgxFrame> loadAsync(String ... uris) {
        if (uris != null && uris.length != 0) {
            throw new IllegalArgumentException("No arguments should be given");
        }
        try {
            if (this.keystorePathSupplier != null && this.keystorePasswordSupplier != null && this.keystoreAlias != null) {
                String keystorePath = (String)this.keystorePathSupplier.get();
                char[] keystorePassword = (char[])this.keystorePasswordSupplier.get();
                if (keystorePath != null || keystorePassword != null) {
                    this.password = AuthCertUtils.getPasswordFromKeystore((String)keystorePath, (char[])keystorePassword, (String)this.keystoreAlias);
                }
            }
        }
        catch (Exception e) {
            return PgxFuture.exceptionallyCompletedFuture(e);
        }
        RdbmsEntityProviderConfig config = (RdbmsEntityProviderConfig)this.configBuilder.build();
        String tablename = config.getLoadedDatabaseTableName();
        DbEntityProviderLocation location = new DbEntityProviderLocation(EntityType.ROW, ProviderFormat.RDBMS, this.jdbcUrl, this.dataSourceId, this.owner, this.username, this.password, tablename);
        return this.triggerLoadAsync((EntityProviderLocation)location, (AbstractEntityProviderConfigBuilder<?, ?>)this.configBuilder);
    }
}

