/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.temporal.ChronoField;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.function.BiPredicate;
import java.util.function.Function;
import oracle.pgql.lang.PgqlException;
import oracle.pgql.lang.spatial.Point2D;
import oracle.pgx.api.PgqlResultElement;
import oracle.pgx.api.PgxEdge;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.PgxResult;
import oracle.pgx.api.PgxVertex;
import oracle.pgx.api.internal.PgqlResultSetImpl;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.common.util.TemporalTypeUtils;

public class ResultImpl
implements PgxResult {
    private static final String DATE_FORMAT_STRING_UTC = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final EnumSet<PgqlResultElement.Type> NUMERIC_TYPES = EnumSet.of(PgqlResultElement.Type.INTEGER, PgqlResultElement.Type.LONG, PgqlResultElement.Type.FLOAT, PgqlResultElement.Type.DOUBLE);
    private final PgxGraph graph;
    private final List<? extends PgqlResultElement> resultElements;
    private final List<Object> rawResult;
    private final SimpleDateFormat dateFormatUtc;

    public ResultImpl(PgqlResultSetImpl resultSet, List<Object> rawResult) {
        this.graph = resultSet.getGraph();
        this.resultElements = resultSet.getPgqlResultElements();
        this.rawResult = rawResult;
        this.dateFormatUtc = new SimpleDateFormat(DATE_FORMAT_STRING_UTC);
        this.dateFormatUtc.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    private void checkResultTypeLoosely(int elementIdx, PgqlResultElement.Type expected) {
        PgqlResultElement.Type type = this.resultElements.get(elementIdx).getElementType();
        if (type != null && type != expected) {
            throw ResultImpl.typeMismatchException(type, expected);
        }
    }

    private void checkResultTypeLoosely(int elementIdx, Set<PgqlResultElement.Type> expected) {
        PgqlResultElement.Type type = this.resultElements.get(elementIdx).getElementType();
        if (type != null && !expected.contains((Object)type)) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"PGQL_RESULT_TYPE_MISMATCH", (Object[])new Object[]{type, expected}));
        }
    }

    private static IllegalArgumentException typeMismatchException(PgqlResultElement.Type actualType, PgqlResultElement.Type requestedType) {
        return new IllegalArgumentException(ErrorMessages.getMessage((String)"PGQL_RESULT_TYPE_MISMATCH", (Object[])new Object[]{actualType, requestedType}));
    }

    private <T> T getFloatOrDouble(PgqlResultElement.Type requestedType, int elementIdx, Function<Number, T> castFunction, BiPredicate<Number, T> outOfRangeCheck) {
        PgqlResultElement.Type type = this.resultElements.get(elementIdx).getElementType();
        if (type == null) {
            return null;
        }
        if (!NUMERIC_TYPES.contains((Object)type)) {
            throw ResultImpl.typeMismatchException(type, requestedType);
        }
        return this.getNumber(requestedType, elementIdx, castFunction, outOfRangeCheck);
    }

    private <T> T getNumber(PgqlResultElement.Type requestedType, int elementIdx, Function<Number, T> castFunction, BiPredicate<Number, T> outOfRangeCheck) {
        Number number = (Number)this.rawResult.get(elementIdx);
        return ResultImpl.castSafely(requestedType, number, castFunction, outOfRangeCheck);
    }

    private static <T> T castSafely(PgqlResultElement.Type requestedType, Number value, Function<Number, T> castFunction, BiPredicate<Number, T> outOfRangeCheck) {
        if (value == null) {
            return null;
        }
        T result = castFunction.apply(value);
        if (!outOfRangeCheck.test(value, (Number)result)) {
            throw new IllegalStateException(ErrorMessages.getMessage((String)"INVALID_CAST_RANGE", (Object[])new Object[]{value, requestedType}));
        }
        return result;
    }

    public <T> List<T> getList(int elementIdx) throws PgqlException {
        PgqlResultElement.Type type = this.resultElements.get(elementIdx - 1).getElementType();
        if (type == null) {
            return Collections.emptyList();
        }
        if (type != PgqlResultElement.Type.ARRAY) {
            throw ResultImpl.typeMismatchException(type, PgqlResultElement.Type.ARRAY);
        }
        return (List)this.rawResult.get(elementIdx - 1);
    }

    public <T> List<T> getList(String elementName) throws PgqlException {
        return this.getList(PgqlResultSetImpl.getColumnNumber(elementName, this.resultElements));
    }

    public Object getObject(int elementIdx) throws PgqlException {
        PgqlResultElement.Type elementType = this.resultElements.get(elementIdx - 1).getElementType();
        Object result = elementType == PgqlResultElement.Type.VERTEX ? this.getVertex(elementIdx) : (elementType == PgqlResultElement.Type.EDGE ? this.getEdge(elementIdx) : (elementType == PgqlResultElement.Type.DATE ? this.getDate(elementIdx) : (elementType == PgqlResultElement.Type.TIME ? this.getTime(elementIdx) : (elementType == PgqlResultElement.Type.TIMESTAMP ? this.getTimestamp(elementIdx) : (elementType == PgqlResultElement.Type.TIME_WITH_TIMEZONE ? this.getTimeWithTimezone(elementIdx) : (elementType == PgqlResultElement.Type.TIMESTAMP_WITH_TIMEZONE ? this.getTimestampWithTimezone(elementIdx) : (elementType == PgqlResultElement.Type.POINT2D ? this.getPoint2D(elementIdx) : (elementType != null ? this.rawResult.get(elementIdx - 1) : null))))))));
        return result;
    }

    public Object getObject(String elementName) throws PgqlException {
        return this.getObject(PgqlResultSetImpl.getColumnNumber(elementName, this.resultElements));
    }

    public String getString(int elementIdx) throws PgqlException {
        EnumSet<PgqlResultElement.Type> stringTypes = EnumSet.of(PgqlResultElement.Type.STRING, PgqlResultElement.Type.EDGE_LABEL);
        this.checkResultTypeLoosely(elementIdx - 1, stringTypes);
        return (String)this.rawResult.get(elementIdx - 1);
    }

    public String getString(String elementName) throws PgqlException {
        return this.getString(PgqlResultSetImpl.getColumnNumber(elementName, this.resultElements));
    }

    public Integer getInteger(int elementIdx) throws PgqlException {
        Integer result;
        PgqlResultElement.Type type = this.resultElements.get(elementIdx - 1).getElementType();
        if (type == null) {
            return null;
        }
        switch (type) {
            case INTEGER: {
                result = this.getNumber(PgqlResultElement.Type.INTEGER, elementIdx - 1, Number::intValue, (intIn, intOut) -> true);
                break;
            }
            case LONG: {
                result = this.getNumber(PgqlResultElement.Type.INTEGER, elementIdx - 1, Number::intValue, (longIn, intOut) -> longIn.longValue() == intOut.longValue());
                break;
            }
            case FLOAT: 
            case DOUBLE: {
                result = this.getNumber(PgqlResultElement.Type.INTEGER, elementIdx - 1, Number::intValue, (numberIn, intOut) -> (long)numberIn.intValue() == numberIn.longValue());
                break;
            }
            default: {
                throw ResultImpl.typeMismatchException(type, PgqlResultElement.Type.INTEGER);
            }
        }
        return result;
    }

    public Integer getInteger(String elementName) throws PgqlException {
        return this.getInteger(PgqlResultSetImpl.getColumnNumber(elementName, this.resultElements));
    }

    public Long getLong(int elementIdx) throws PgqlException {
        PgqlResultElement.Type type = this.resultElements.get(elementIdx - 1).getElementType();
        if (type == PgqlResultElement.Type.INTEGER || type == PgqlResultElement.Type.LONG) {
            return this.getNumber(PgqlResultElement.Type.LONG, elementIdx - 1, Number::longValue, (intIn, longOut) -> true);
        }
        if (type == PgqlResultElement.Type.FLOAT || type == PgqlResultElement.Type.DOUBLE) {
            return this.getNumber(PgqlResultElement.Type.LONG, elementIdx - 1, Number::longValue, (in, longOut) -> {
                try {
                    return BigDecimal.valueOf(in.doubleValue()).toBigInteger().longValueExact() == longOut.longValue();
                }
                catch (ArithmeticException | NumberFormatException unused) {
                    return false;
                }
            });
        }
        if (type != null) {
            throw ResultImpl.typeMismatchException(type, PgqlResultElement.Type.LONG);
        }
        return null;
    }

    public Long getLong(String elementName) throws PgqlException {
        return this.getLong(PgqlResultSetImpl.getColumnNumber(elementName, this.resultElements));
    }

    public Float getFloat(int elementIdx) throws PgqlException {
        return this.getFloatOrDouble(PgqlResultElement.Type.FLOAT, elementIdx - 1, Number::floatValue, (numberIn, floatOut) -> true);
    }

    public Float getFloat(String elementName) throws PgqlException {
        return this.getFloat(PgqlResultSetImpl.getColumnNumber(elementName, this.resultElements));
    }

    public Double getDouble(int elementIdx) throws PgqlException {
        return this.getFloatOrDouble(PgqlResultElement.Type.DOUBLE, elementIdx - 1, Number::doubleValue, (numberIn, doubleOut) -> true);
    }

    public Double getDouble(String elementName) throws PgqlException {
        return this.getDouble(PgqlResultSetImpl.getColumnNumber(elementName, this.resultElements));
    }

    public Boolean getBoolean(int elementIdx) throws PgqlException {
        this.checkResultTypeLoosely(elementIdx - 1, PgqlResultElement.Type.BOOLEAN);
        return (Boolean)this.rawResult.get(elementIdx - 1);
    }

    public Boolean getBoolean(String elementName) throws PgqlException {
        return this.getBoolean(PgqlResultSetImpl.getColumnNumber(elementName, this.resultElements));
    }

    public Set<String> getVertexLabels(int elementIdx) throws PgqlException {
        this.checkResultTypeLoosely(elementIdx - 1, PgqlResultElement.Type.VERTEX_LABELS);
        return (Set)this.rawResult.get(elementIdx - 1);
    }

    public Set<String> getVertexLabels(String elementName) throws PgqlException {
        return this.getVertexLabels(PgqlResultSetImpl.getColumnNumber(elementName, this.resultElements));
    }

    public LocalDate getDate(int elementIdx) throws PgqlException {
        this.checkResultTypeLoosely(elementIdx - 1, PgqlResultElement.Type.DATE);
        Object value = this.rawResult.get(elementIdx - 1);
        if (value instanceof Integer) {
            return LocalDate.ofEpochDay(((Integer)value).intValue());
        }
        return (LocalDate)value;
    }

    public LocalDate getDate(String elementName) throws PgqlException {
        return this.getDate(PgqlResultSetImpl.getColumnNumber(elementName, this.resultElements));
    }

    public LocalTime getTime(int elementIdx) throws PgqlException {
        LocalTime result;
        PgqlResultElement.Type type = this.resultElements.get(elementIdx - 1).getElementType();
        if (type == PgqlResultElement.Type.TIME) {
            Object value = this.rawResult.get(elementIdx - 1);
            result = value instanceof Integer ? TemporalTypeUtils.parseTimeFromMillis((int)((Integer)value)) : (value instanceof LocalTime ? (LocalTime)value : null);
        } else if (type == PgqlResultElement.Type.TIME_WITH_TIMEZONE) {
            OffsetTime offsetTime = (OffsetTime)this.rawResult.get(elementIdx - 1);
            result = offsetTime == null ? null : offsetTime.toLocalTime();
        } else {
            if (type != null) {
                throw ResultImpl.typeMismatchException(type, PgqlResultElement.Type.TIME);
            }
            result = null;
        }
        return result;
    }

    public LocalTime getTime(String elementName) throws PgqlException {
        return this.getTime(PgqlResultSetImpl.getColumnNumber(elementName, this.resultElements));
    }

    public LocalDateTime getTimestamp(int elementIdx) throws PgqlException {
        LocalDateTime result;
        PgqlResultElement.Type type = this.resultElements.get(elementIdx - 1).getElementType();
        if (type == null) {
            return null;
        }
        if (type == PgqlResultElement.Type.TIMESTAMP) {
            Object value = this.rawResult.get(elementIdx - 1);
            result = value instanceof LocalDateTime ? (LocalDateTime)value : (value != null ? TemporalTypeUtils.parseTimestamp((long)((Long)value)) : null);
        } else if (type == PgqlResultElement.Type.TIMESTAMP_WITH_TIMEZONE) {
            OffsetDateTime offsetDateTime = (OffsetDateTime)this.rawResult.get(elementIdx - 1);
            result = offsetDateTime == null ? null : offsetDateTime.toLocalDateTime();
        } else {
            throw ResultImpl.typeMismatchException(type, PgqlResultElement.Type.TIMESTAMP);
        }
        return result;
    }

    public LocalDateTime getTimestamp(String elementName) throws PgqlException {
        return this.getTimestamp(PgqlResultSetImpl.getColumnNumber(elementName, this.resultElements));
    }

    public OffsetTime getTimeWithTimezone(int elementIdx) throws PgqlException {
        OffsetTime result;
        PgqlResultElement.Type type = this.resultElements.get(elementIdx - 1).getElementType();
        if (type == PgqlResultElement.Type.TIME_WITH_TIMEZONE) {
            result = (OffsetTime)this.rawResult.get(elementIdx - 1);
        } else if (type == PgqlResultElement.Type.TIME) {
            Object value = this.rawResult.get(elementIdx - 1);
            result = value instanceof LocalTime ? TemporalTypeUtils.parseTimefromLocalTime((LocalTime)((LocalTime)value), (int)0) : (value instanceof Integer ? TemporalTypeUtils.parseTimeWithTimezone((int)((Integer)value), (int)0) : null);
        } else {
            if (type != null) {
                throw ResultImpl.typeMismatchException(type, PgqlResultElement.Type.TIME_WITH_TIMEZONE);
            }
            result = null;
        }
        return result;
    }

    public OffsetTime getTimeWithTimezone(String elementName) throws PgqlException {
        return this.getTimeWithTimezone(PgqlResultSetImpl.getColumnNumber(elementName, this.resultElements));
    }

    public OffsetDateTime getTimestampWithTimezone(int elementIdx) throws PgqlException {
        OffsetDateTime result;
        PgqlResultElement.Type type = this.resultElements.get(elementIdx - 1).getElementType();
        if (type == PgqlResultElement.Type.TIMESTAMP_WITH_TIMEZONE) {
            result = (OffsetDateTime)this.rawResult.get(elementIdx - 1);
        } else if (type == PgqlResultElement.Type.TIMESTAMP) {
            Object value = this.rawResult.get(elementIdx - 1);
            result = value instanceof Long ? TemporalTypeUtils.parseTimestampWithTimezone((long)((Long)value), (int)0) : (value instanceof LocalDateTime ? TemporalTypeUtils.parseTimestampfromLocalDateTime((LocalDateTime)((LocalDateTime)value), (int)0) : null);
        } else {
            if (type != null) {
                throw ResultImpl.typeMismatchException(type, PgqlResultElement.Type.TIMESTAMP_WITH_TIMEZONE);
            }
            result = null;
        }
        return result;
    }

    public OffsetDateTime getTimestampWithTimezone(String elementName) throws PgqlException {
        return this.getTimestampWithTimezone(PgqlResultSetImpl.getColumnNumber(elementName, this.resultElements));
    }

    public Date getLegacyDate(int elementIdx) throws PgqlException {
        Date result;
        PgqlResultElement.Type type = this.resultElements.get(elementIdx - 1).getElementType();
        if (type == PgqlResultElement.Type.DATE) {
            result = this.getLegacyDateFromLocalDate(elementIdx - 1);
        } else if (type == PgqlResultElement.Type.TIME) {
            result = this.getLegacyDateFromTime(elementIdx - 1);
        } else if (type == PgqlResultElement.Type.TIMESTAMP) {
            result = this.getLegacyDateFromTimestamp(elementIdx - 1);
        } else if (type == PgqlResultElement.Type.TIME_WITH_TIMEZONE) {
            result = this.getLegacyDateFromTimeWithTimezone(elementIdx - 1);
        } else if (type == PgqlResultElement.Type.TIMESTAMP_WITH_TIMEZONE) {
            result = this.getLegacyDateFromTimestampWithTimezone(elementIdx - 1);
        } else {
            if (type != null) {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"PGQL_RESULT_TYPE_MISMATCH", (Object[])new Object[]{type, "legacy date"}));
            }
            result = null;
        }
        return result;
    }

    public Date getLegacyDate(String elementName) throws PgqlException {
        return this.getLegacyDate(PgqlResultSetImpl.getColumnNumber(elementName, this.resultElements));
    }

    private Date convertToUtc(Date date, int elementIdx) {
        String gmtDateString = this.dateFormatUtc.format(date);
        SimpleDateFormat dateFormatLocal = new SimpleDateFormat(DATE_FORMAT_STRING_UTC);
        try {
            return dateFormatLocal.parse(gmtDateString);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"STRING_CANNOT_BE_PARSED_TO_TEMPORAL_TYPE", (Object[])new Object[]{gmtDateString, this.resultElements.get(elementIdx).getElementType()}), e);
        }
    }

    private Date getLegacyDateFromLocalDate(int elementIdx) {
        Object value = this.rawResult.get(elementIdx);
        if (value == null) {
            return null;
        }
        Date date = value instanceof LocalDate ? new Date(TimeUnit.DAYS.toMillis(((LocalDate)value).toEpochDay())) : new Date(TimeUnit.DAYS.toMillis(((Integer)value).intValue()));
        return this.convertToUtc(date, elementIdx);
    }

    private Date getLegacyDateFromTime(int elementIdx) {
        Object value = this.rawResult.get(elementIdx);
        if (value == null) {
            return null;
        }
        Date date = value instanceof Integer ? new Date(((Integer)value).longValue()) : new Date(TimeUnit.MILLISECONDS.convert(((LocalTime)value).toNanoOfDay(), TimeUnit.NANOSECONDS));
        return this.convertToUtc(date, elementIdx);
    }

    private Date getLegacyDateFromTimestamp(int elementIdx) {
        Object value = this.rawResult.get(elementIdx);
        if (value == null) {
            return null;
        }
        Date date = value instanceof Long ? new Date((Long)value) : Date.from(((LocalDateTime)value).atZone(ZoneId.of("UTC")).toInstant());
        return this.convertToUtc(date, elementIdx);
    }

    private Date getLegacyDateFromTimeWithTimezone(int elementIdx) {
        OffsetTime offsetTime = (OffsetTime)this.rawResult.get(elementIdx);
        if (offsetTime == null) {
            return null;
        }
        long millis = (long)offsetTime.toLocalTime().get(ChronoField.MILLI_OF_DAY) - TimeUnit.SECONDS.toMillis(offsetTime.getOffset().getTotalSeconds());
        Date date = new Date(millis);
        return this.convertToUtc(date, elementIdx);
    }

    private Date getLegacyDateFromTimestampWithTimezone(int elementIdx) {
        OffsetDateTime offsetDateTime = (OffsetDateTime)this.rawResult.get(elementIdx);
        if (offsetDateTime == null) {
            return null;
        }
        Date date = new Date(offsetDateTime.toInstant().toEpochMilli());
        return this.convertToUtc(date, elementIdx);
    }

    public Point2D getPoint2D(int elementIdx) throws PgqlException {
        PgqlResultElement.Type type = this.resultElements.get(elementIdx - 1).getElementType();
        if (type == null) {
            return null;
        }
        if (type != PgqlResultElement.Type.POINT2D) {
            throw ResultImpl.typeMismatchException(type, PgqlResultElement.Type.POINT2D);
        }
        return (Point2D)this.rawResult.get(elementIdx - 1);
    }

    public Point2D getPoint2D(String elementName) throws PgqlException {
        return this.getPoint2D(PgqlResultSetImpl.getColumnNumber(elementName, this.resultElements));
    }

    @Override
    public PgxEdge getEdge(int elementIdx) throws PgqlException {
        this.checkResultTypeLoosely(elementIdx - 1, PgqlResultElement.Type.EDGE);
        return PgxEdge.deserialize(this.graph, this.rawResult.get(elementIdx - 1));
    }

    @Override
    public PgxEdge getEdge(String elementName) throws PgqlException {
        return this.getEdge(PgqlResultSetImpl.getColumnNumber(elementName, this.resultElements));
    }

    @Override
    public <ID extends Comparable<ID>> PgxVertex<ID> getVertex(int elementIdx) throws PgqlException {
        this.checkResultTypeLoosely(elementIdx - 1, PgqlResultElement.Type.VERTEX);
        return PgxVertex.deserialize(this.graph, this.rawResult.get(elementIdx - 1));
    }

    @Override
    public <ID extends Comparable<ID>> PgxVertex<ID> getVertex(String elementName) throws PgqlException {
        return this.getVertex(PgqlResultSetImpl.getColumnNumber(elementName, this.resultElements));
    }
}

