/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import oracle.pgx.api.EdgeProperty;
import oracle.pgx.api.MutationStrategyBuilder;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.common.PgxId;
import oracle.pgx.common.mutations.EdgeStrategy;
import oracle.pgx.common.mutations.MutationStrategy;
import oracle.pgx.common.mutations.PickByEdgeId;
import oracle.pgx.common.mutations.PickByProperty;
import oracle.pgx.common.mutations.PickingStrategy;
import oracle.pgx.common.mutations.PickingStrategyFunction;
import oracle.pgx.common.util.ErrorMessages;

public class PickingStrategyBuilder
extends MutationStrategyBuilder<PickingStrategyBuilder> {
    private PgxId edgePropertyId;
    private boolean isLabel = false;
    private PickingStrategyFunction pickingStrategyFunction;

    PickingStrategyBuilder(PgxGraph graph) throws ExecutionException, InterruptedException {
        super(graph);
    }

    @Deprecated
    public PickingStrategyBuilder setPickByProperty(String propertyName, PickingStrategyFunction pickingStrategyFunction) {
        return this.setPickByProperty(this.graph.getEdgeProperty(propertyName), pickingStrategyFunction);
    }

    public PickingStrategyBuilder setPickByProperty(EdgeProperty edgeProperty, PickingStrategyFunction pickingStrategyFunction) {
        return this.setPickByProperty(edgeProperty.getPropertyId(), pickingStrategyFunction);
    }

    private PickingStrategyBuilder setPickByProperty(PgxId propertyName, PickingStrategyFunction pickingStrategyFunction) {
        this.assertEdgePropertyExists(propertyName);
        this.edgePropertyId = propertyName;
        this.isLabel = propertyName.equals((Object)this.edgeLabelId);
        this.pickingStrategyFunction = pickingStrategyFunction;
        return this;
    }

    public PickingStrategyBuilder setPickByLabel(PickingStrategyFunction pickingStrategyFunction) {
        if (this.edgeLabelId == null) {
            throw new IllegalStateException(ErrorMessages.getMessage((String)"EDGE_LABEL_NOT_EXISTS", (Object[])new Object[0]));
        }
        this.edgePropertyId = this.edgeLabelId;
        this.isLabel = true;
        this.pickingStrategyFunction = pickingStrategyFunction;
        return this;
    }

    public PickingStrategyBuilder setPickByEdgeId(PickingStrategyFunction pickingStrategyFunction) {
        this.pickingStrategyFunction = pickingStrategyFunction;
        this.edgePropertyId = null;
        return this;
    }

    @Override
    public MutationStrategy build() throws ExecutionException, InterruptedException {
        if (!this.noMultiEdges) {
            return new MutationStrategy(this.keptVertexProperties, this.keptEdgeProperties, this.inPlace, this.newGraphName, this.noTrivialVertices, (EdgeStrategy)new EdgeStrategy.KeepMultiEdgesStrategy(this.noSelfEdges));
        }
        if (this.edgePropertyId != null && this.pickingStrategyFunction != null) {
            if (this.edgePropertyId.equals((Object)this.edgeLabelId)) {
                int indexOfEdgeProperty = this.getIndexOfEdgeProperty();
                return new MutationStrategy(this.keptVertexProperties, this.keptEdgeProperties, this.inPlace, this.newGraphName, this.noTrivialVertices, (EdgeStrategy)new PickByProperty(indexOfEdgeProperty, this.pickingStrategyFunction, this.noSelfEdges));
            }
            return new MutationStrategy(this.keptVertexProperties, this.keptEdgeProperties, this.inPlace, this.newGraphName, this.noTrivialVertices, (EdgeStrategy)new PickByProperty(this.edgePropertyId, this.pickingStrategyFunction, this.noSelfEdges));
        }
        if (this.pickingStrategyFunction != null) {
            return new MutationStrategy(this.keptVertexProperties, this.keptEdgeProperties, this.inPlace, this.newGraphName, this.noTrivialVertices, (EdgeStrategy)new PickByEdgeId(this.pickingStrategyFunction, this.noSelfEdges));
        }
        return new MutationStrategy(this.keptVertexProperties, this.keptEdgeProperties, this.inPlace, this.newGraphName, this.noTrivialVertices, (EdgeStrategy)new PickingStrategy.PickAnyStrategy(this.noSelfEdges));
    }

    private int getIndexOfEdgeProperty() {
        PgxId e;
        if (this.isLabel) {
            return -1;
        }
        int indexOfEdgeProperty = 0;
        Iterator iterator = this.keptEdgeProperties.iterator();
        while (iterator.hasNext() && !(e = (PgxId)iterator.next()).equals((Object)this.edgePropertyId)) {
            ++indexOfEdgeProperty;
        }
        return indexOfEdgeProperty;
    }
}

