/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import java.util.Collection;
import java.util.stream.Collectors;
import oracle.pgx.api.Destroyable;
import oracle.pgx.api.PgxEntity;

public abstract class PgxManagedObject
extends Destroyable {
    public abstract String getName();

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        PgxManagedObject other = (PgxManagedObject)obj;
        return this.getName().equals(other.getName());
    }

    public int hashCode() {
        String s = this.getClass().getName() + this.getName();
        return s.hashCode();
    }

    protected static Collection<String> getNames(Collection<? extends PgxManagedObject> col) {
        if (col == null) {
            return null;
        }
        return col.stream().map(PgxManagedObject::getName).collect(Collectors.toList());
    }

    protected static Object unwrap(Object obj) {
        if (obj == null) {
            return null;
        }
        if (PgxEntity.class.isAssignableFrom(obj.getClass())) {
            return ((PgxEntity)obj).serialize();
        }
        return obj;
    }
}

