/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import oracle.pgx.api.EdgeProperty;
import oracle.pgx.api.MutationStrategyBuilder;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.common.PgxId;
import oracle.pgx.common.mutations.EdgeStrategy;
import oracle.pgx.common.mutations.LabelMergingFunction;
import oracle.pgx.common.mutations.MergingFunction;
import oracle.pgx.common.mutations.MergingStrategy;
import oracle.pgx.common.mutations.MutationStrategy;

public class MergingStrategyBuilder
extends MutationStrategyBuilder<MergingStrategyBuilder> {
    private static final MergingFunction DEFAULT_MERGING_FUNCTION = MergingFunction.MAX;
    private static final LabelMergingFunction DEFAULT_LABEL_FUNCTION = LabelMergingFunction.MAX;
    private HashMap<PgxId, MergingFunction> mappedMergingFunctions = new HashMap();
    private LabelMergingFunction labelMergingFunction = DEFAULT_LABEL_FUNCTION;
    private boolean keepUserDefinedEdgeKeys = true;

    MergingStrategyBuilder(PgxGraph graph) throws ExecutionException, InterruptedException {
        super(graph);
    }

    public MergingStrategyBuilder setPropertyMergingStrategy(String propertyName, MergingFunction mergingFunction) {
        return this.setPropertyMergingStrategy(this.graph.getEdgeProperty(propertyName), mergingFunction);
    }

    public MergingStrategyBuilder setPropertyMergingStrategy(EdgeProperty edgeProperty, MergingFunction mergingFunction) {
        return this.setPropertyMergingStrategy(edgeProperty.getPropertyId(), mergingFunction);
    }

    private MergingStrategyBuilder setPropertyMergingStrategy(PgxId propertyId, MergingFunction mergingFunction) {
        this.assertEdgePropertyExists(propertyId);
        this.mappedMergingFunctions.put(propertyId, mergingFunction);
        return this;
    }

    public MergingStrategyBuilder setKeepUserDefinedEdgeKeys(boolean keepUserDefinedEdgeKeys) {
        this.keepUserDefinedEdgeKeys = keepUserDefinedEdgeKeys;
        return this;
    }

    public MergingStrategyBuilder setLabelMergingStrategy(LabelMergingFunction mergingFunction) {
        this.labelMergingFunction = mergingFunction;
        return this;
    }

    @Override
    public MutationStrategy build() throws ExecutionException, InterruptedException {
        MergingFunction[] mergingStrategies = new MergingFunction[this.keptEdgeProperties.size()];
        PgxId[] mergingPropertyIds = new PgxId[this.keptEdgeProperties.size()];
        int i = 0;
        for (PgxId keptEdgeProperty : this.keptEdgeProperties) {
            mergingStrategies[i] = this.mappedMergingFunctions.getOrDefault(keptEdgeProperty, DEFAULT_MERGING_FUNCTION);
            mergingPropertyIds[i] = keptEdgeProperty;
            ++i;
        }
        if (this.noMultiEdges) {
            return new MutationStrategy(this.keptVertexProperties, this.keptEdgeProperties, this.inPlace, this.newGraphName, this.noTrivialVertices, (EdgeStrategy)new MergingStrategy(mergingStrategies, mergingPropertyIds, this.labelMergingFunction, this.keepUserDefinedEdgeKeys, this.noSelfEdges));
        }
        return new MutationStrategy(this.keptVertexProperties, this.keptEdgeProperties, this.inPlace, this.newGraphName, this.noTrivialVertices, (EdgeStrategy)new EdgeStrategy.KeepMultiEdgesStrategy(this.noSelfEdges));
    }
}

