/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import oracle.pgx.api.EdgeBuilder;
import oracle.pgx.api.EdgeModifier;
import oracle.pgx.api.GraphBuilder;
import oracle.pgx.api.GraphBuilderImpl;
import oracle.pgx.api.GraphChangeSet;
import oracle.pgx.api.GraphMetaData;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.SessionContext;
import oracle.pgx.api.VertexBuilder;
import oracle.pgx.api.VertexModifier;
import oracle.pgx.api.graphbuilder.EdgeModifierImpl;
import oracle.pgx.api.graphbuilder.VertexModifierImpl;
import oracle.pgx.api.internal.Changes;
import oracle.pgx.api.internal.EdgeChanges;
import oracle.pgx.api.internal.Graph;
import oracle.pgx.common.PgxId;
import oracle.pgx.common.types.ChangeType;
import oracle.pgx.common.types.EntityType;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.ChangeTrackingMap;
import oracle.pgx.common.util.EntityIdConversionHelper;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.common.util.InvalidChangeHandler;
import oracle.pgx.config.GraphBuilderConfig;
import oracle.pgx.config.IdGenerationStrategy;
import oracle.pgx.config.OnAddExistingElement;
import oracle.pgx.config.OnInvalidChange;
import oracle.pgx.config.OnRequiredConversion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphChangeSetImpl<VID>
extends GraphBuilderImpl<VID>
implements GraphChangeSet<VID> {
    private static final Logger LOG = LoggerFactory.getLogger(GraphChangeSetImpl.class);
    protected final PgxGraph graph;

    GraphChangeSetImpl(PgxGraph graph) {
        super(graph.getSession(), graph.getVertexIdType(), Changes.ChangesIntent.MODIFY);
        this.graph = graph;
    }

    protected GraphChangeSetImpl(GraphChangeSetImpl<VID> base) {
        super(base);
        this.graph = base.graph;
    }

    @Override
    protected VertexBuilder<VID> getVertexBuilder(VID vertexId, boolean isIgnored) {
        this.isConfigLocked = true;
        VertexModifierImpl<VID> vertexModifier = new VertexModifierImpl<VID>(this, vertexId, isIgnored);
        vertexModifier.isConfigLocked = true;
        return vertexModifier;
    }

    @Override
    protected EdgeBuilder<VID> getEdgeBuilder(Object edgeId, boolean isIgnored) {
        this.isConfigLocked = true;
        EdgeModifierImpl edgeModifier = new EdgeModifierImpl(this, edgeId, isIgnored);
        edgeModifier.isConfigLocked = true;
        return edgeModifier;
    }

    private VertexModifier<VID> getVertexModifier(VID vertexId, boolean isIgnored) {
        this.isConfigLocked = true;
        VertexModifierImpl<VID> vertexModifier = new VertexModifierImpl<VID>(this, vertexId, isIgnored);
        vertexModifier.isConfigLocked = true;
        return vertexModifier;
    }

    private EdgeModifier<VID> getEdgeModifier(Object edgeId, boolean isIgnored) {
        this.isConfigLocked = true;
        EdgeModifierImpl edgeModifier = new EdgeModifierImpl(this, edgeId, isIgnored);
        edgeModifier.isConfigLocked = true;
        return edgeModifier;
    }

    @Override
    public VertexBuilder<VID> addVertex() {
        if (!this.graph.isHomogeneous()) {
            throw new UnsupportedOperationException(ErrorMessages.getMessage((String)"UNSUPPORTED_ID_STRATEGY_ON_PARTITIONED_GRAPH", (Object[])new Object[]{IdGenerationStrategy.AUTO_GENERATED}));
        }
        return super.addVertex();
    }

    @Override
    public EdgeBuilder<VID> addEdge(long edgeId, VertexBuilder<VID> srcVertex, VertexBuilder<VID> dstVertex) {
        this.expectedIdGenerationStrategy(GraphBuilderConfig.Field.VERTEX_ID_GENERATION_STRATEGY, IdGenerationStrategy.USER_IDS, EntityType.VERTEX);
        return super.addEdge(edgeId, srcVertex, dstVertex);
    }

    @Override
    public EdgeBuilder<VID> addEdge(String edgeId, VertexBuilder<VID> srcVertex, VertexBuilder<VID> dstVertex) {
        this.expectedIdGenerationStrategy(GraphBuilderConfig.Field.VERTEX_ID_GENERATION_STRATEGY, IdGenerationStrategy.USER_IDS, EntityType.VERTEX);
        return super.addEdge(edgeId, srcVertex, dstVertex);
    }

    @Override
    public EdgeBuilder<VID> addEdge(VertexBuilder<VID> srcVertex, VertexBuilder<VID> dstVertex) {
        this.expectedIdGenerationStrategy(GraphBuilderConfig.Field.VERTEX_ID_GENERATION_STRATEGY, IdGenerationStrategy.USER_IDS, EntityType.VERTEX);
        return super.addEdge(srcVertex, dstVertex);
    }

    @Override
    public GraphChangeSet<VID> removeVertex(VID vertexId) {
        InvalidChangeHandler invalidChangeHandler = this.changes.getInvalidChangeHandler();
        if (!EntityIdConversionHelper.canConvertVertexId((IdType)this.idType, vertexId)) {
            invalidChangeHandler.handleVertexIdMismatch(this.idType, vertexId, ChangeType.REMOVE, InvalidChangeHandler.VertexLocation.STANDALONE);
            return this;
        }
        vertexId = EntityIdConversionHelper.toVertexIdAndLogIfNecessary((IdType)this.idType, vertexId, (InvalidChangeHandler)invalidChangeHandler, (InvalidChangeHandler.VertexLocation)InvalidChangeHandler.VertexLocation.STANDALONE);
        this.changes.removeVertex(vertexId);
        return this;
    }

    @Override
    public GraphChangeSet<VID> removeEdge(long edgeId) {
        this.changes.removeEdge(edgeId);
        return this;
    }

    @Override
    public GraphChangeSet<VID> removeEdge(String edgeId) {
        this.changes.removeEdge(edgeId);
        return this;
    }

    @Override
    public VertexModifier<VID> updateVertex(VID vertexId) {
        InvalidChangeHandler invalidChangeHandler = this.changes.getInvalidChangeHandler();
        if (!EntityIdConversionHelper.canConvertVertexId((IdType)this.idType, vertexId)) {
            invalidChangeHandler.handleVertexIdMismatch(this.idType, vertexId, null, InvalidChangeHandler.VertexLocation.STANDALONE);
            return this.getVertexModifier(vertexId, true);
        }
        vertexId = EntityIdConversionHelper.toVertexIdAndLogIfNecessary((IdType)this.idType, vertexId, (InvalidChangeHandler)invalidChangeHandler, (InvalidChangeHandler.VertexLocation)InvalidChangeHandler.VertexLocation.STANDALONE);
        boolean success = this.changes.updateVertex(vertexId);
        return this.getVertexModifier(vertexId, !success);
    }

    @Override
    public EdgeModifier<VID> updateEdge(long edgeId) {
        boolean success = this.changes.updateEdge(edgeId);
        return this.getEdgeModifier(edgeId, !success);
    }

    @Override
    public EdgeModifier<VID> updateEdge(String edgeId) {
        boolean success = this.changes.updateEdge(edgeId);
        return this.getEdgeModifier(edgeId, !success);
    }

    @Override
    public GraphChangeSet<VID> resetEdge(long edgeId) {
        super.resetEdge(edgeId);
        return this;
    }

    @Override
    public GraphChangeSet<VID> resetEdge(String edgeId) {
        super.resetEdge(edgeId);
        return this;
    }

    @Override
    public GraphChangeSet<VID> resetVertex(VertexBuilder<VID> vertex) {
        super.resetVertex(vertex);
        return this;
    }

    @Override
    public GraphChangeSet<VID> resetVertex(VID vertexId) {
        super.resetVertex(vertexId);
        return this;
    }

    @Override
    public GraphChangeSet<VID> setAddExistingEdgePolicy(OnAddExistingElement addExistingEdgePolicy) {
        this.changes.setAddExistingEdgePolicy(addExistingEdgePolicy);
        return this;
    }

    @Override
    public GraphChangeSet<VID> setAddExistingVertexPolicy(OnAddExistingElement addExistingVertexPolicy) {
        this.changes.setAddExistingVertexPolicy(addExistingVertexPolicy);
        return this;
    }

    @Override
    public GraphChangeSet<VID> setInvalidChangePolicy(OnInvalidChange invalidChangePolicy) {
        this.changes.setInvalidChangePolicy(invalidChangePolicy);
        return this;
    }

    @Override
    public GraphChangeSet<VID> setRequiredConversionPolicy(OnRequiredConversion requiredConversionPolicy) {
        this.changes.setRequiredConversionPolicy(requiredConversionPolicy);
        return this;
    }

    @Override
    protected Optional<PgxId> getOldGraphId() {
        return Optional.of(this.graph.getId());
    }

    @Override
    public String toString() {
        return "Graph change set for graph " + this.graph.getName() + " with " + this.changes.toString();
    }

    @Override
    public final PgxFuture<PgxGraph> buildNewSnapshotAsync() {
        SessionContext sessionContext = this.session.getSessionContext();
        PgxId graphId = this.graph.getId();
        IdType idType = this.changes.getIdType();
        Map<String, PropertyType> vertexPropTypes = this.changes.getVertexPropTypes();
        Map<String, PropertyType> edgePropTypes = this.changes.getEdgePropTypes();
        OnAddExistingElement addExistingVertexPolicy = this.changes.getAddExistingVertexPolicy();
        OnAddExistingElement addExistingEdgePolicy = this.changes.getAddExistingEdgePolicy();
        List vertexChanges = this.changes.getVertexChanges();
        List<ChangeTrackingMap.ChangeSetEntry<Object, EdgeChanges>> edgeChanges = this.changes.getEdgeChanges();
        GraphBuilderConfig config = this.createGraphBuilderConfig();
        IdGenerationStrategy vertexIdGenerationStrategy = config.getVertexIdGenerationStrategy();
        IdGenerationStrategy edgeIdGenerationStrategy = config.getEdgeIdGenerationStrategy();
        LOG.debug("Parsed Graph Builder Config: {}", (Object)config);
        InvalidChangeHandler invalidChangeHandler = this.changes.getInvalidChangeHandler();
        return ((PgxFuture)this.session.getCore().addChanges(sessionContext, this.graphBuilderName, vertexChanges, edgeChanges, graphId, addExistingVertexPolicy, addExistingEdgePolicy, invalidChangeHandler.getInvalidChangePolicy(), invalidChangeHandler.getRquiredConversionPolicy(), vertexIdGenerationStrategy, edgeIdGenerationStrategy).thenCompose(aVoid -> this.session.getCore().buildNewGraphSnapshot(sessionContext, graphId, this.graphBuilderName, idType, vertexPropTypes, edgePropTypes, config, this.dataSourceVersion))).thenApply(graph -> {
            GraphMetaData metaData = graph.getMetaData();
            LOG.info("Created a new snapshot with {} vertices and {} edges. Vertex properties: {}. Edge properties: {}.", new Object[]{metaData.getNumVertices(), metaData.getNumEdges(), graph.getVertexPropertyNames(), graph.getEdgePropertyNames()});
            return new PgxGraph(this.session, (Graph)((Object)graph));
        });
    }

    @Override
    public ChangeType getVertexChangeType(VID id) {
        return this.changes.getVertexChangeType(id);
    }

    @Override
    public ChangeType getEdgeChangeType(Object id) {
        return this.changes.getEdgeChangeType(id);
    }

    @Override
    public GraphBuilder<VID> partitionedEdgeIds(boolean partitionedIds) {
        throw new UnsupportedOperationException("UNSUPPORTED_OP_ON_GRAPH_CHANGE_SET");
    }

    @Override
    public GraphBuilder<VID> partitionedVertexIds(boolean partitionedIds) {
        throw new UnsupportedOperationException("UNSUPPORTED_OP_ON_GRAPH_CHANGE_SET");
    }
}

