/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import java.security.SecureRandom;
import oracle.security.crypto.core.EntropySource;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.provider.TransitionMode;

public class SRRandomBitsSource
extends RandomBitsSource {
    private SecureRandom a = new SecureRandom();
    private static final int b = 20;

    public SRRandomBitsSource() {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
    }

    @Override
    public void clear() {
    }

    @Override
    public byte[] randomBytes(byte[] byArray) {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        this.a.nextBytes(byArray);
        return byArray;
    }

    @Override
    public byte randomByte() {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        byte[] byArray = new byte[1];
        this.a.nextBytes(byArray);
        return byArray[0];
    }

    @Override
    public void seed(byte[] byArray) {
        this.a.setSeed(byArray);
    }

    @Override
    public void seed(EntropySource entropySource) {
        this.a.setSeed(entropySource.generateBytes(new byte[20]));
    }
}

