/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.stream.Collectors;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.util.OracleEnvironment;
import oracle.jdbc.util.ipc.SignalSender;

public class OracleServerProcessWrapper {
    private static final String CLASS_NAME = OracleServerProcessWrapper.class.getName();
    private static final String serverProcessHome = "bin";
    private static final String serverProcessFilename = "oracle";
    private final Path serverProcessPath;
    Map<String, String> environ = new HashMap<String, String>();
    private Process serverProcess;

    public OracleServerProcessWrapper(String serverProcessHomeBase) throws IOException {
        String home = serverProcessHomeBase;
        if (home == null && (home = this.environ.get(OracleEnvironment.ORACLE_HOME.getEnvName())) == null) {
            home = System.getenv(OracleEnvironment.ORACLE_HOME.getEnvName());
        }
        this.serverProcessPath = this.locateServerProcessBin(home);
        this.isServerProcessBinValid();
        CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "OracleServerProcessWrapper", "new  server process wrapper on {0}", (String)null, (Throwable)null, (Object)this.serverProcessPath);
    }

    public void addEnvironment(String variable, String value) {
        this.environ.put(variable, value);
    }

    private Path locateServerProcessBin(String base) throws IOException {
        if (base == null) {
            if (System.getenv(OracleEnvironment.ORACLE_HOME.getEnvName()) == null) {
                throw new IllegalArgumentException(String.format("%s is not defined", OracleEnvironment.ORACLE_HOME.getEnvName()));
            }
            CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "locateServerProcessBin", "{0} defined as [{1}] ", (String)null, (Throwable)null, (Object)OracleEnvironment.ORACLE_HOME.getEnvName(), (Object)System.getenv(OracleEnvironment.ORACLE_HOME.getEnvName()));
            return Paths.get(System.getenv(OracleEnvironment.ORACLE_HOME.getEnvName()), serverProcessHome, serverProcessFilename).toRealPath(new LinkOption[0]);
        }
        return Paths.get(base, serverProcessHome, serverProcessFilename).toRealPath(new LinkOption[0]);
    }

    private void isServerProcessBinValid() throws IOException {
        if (!Files.isExecutable(this.serverProcessPath)) {
            throw DatabaseError.createIOException(1731);
        }
    }

    public InputStream getInputStream() {
        if (this.serverProcess == null) {
            throw new IllegalStateException("server process not started");
        }
        return this.serverProcess.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.serverProcess == null) {
            throw new IllegalStateException("server process not started");
        }
        return new AutoFlushPipedOutputStream(this.serverProcess.getOutputStream());
    }

    public void start(String ... parameters) throws IOException {
        if (this.serverProcess != null) {
            throw new IllegalStateException("server process already started");
        }
        ArrayList<String> builderParams = new ArrayList<String>();
        builderParams.add(this.serverProcessPath.toString());
        if (parameters != null) {
            for (String param : parameters) {
                builderParams.add(param);
            }
        }
        for (String param : builderParams) {
            CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "start", "Adding param [{0}] ", (String)null, (Throwable)null, (Object)param);
        }
        ProcessBuilder pb = new ProcessBuilder(builderParams);
        pb.environment().put(OracleEnvironment.COMM_FDS_ENV.getEnvName(), "0,1");
        CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "start", "{0} defined as [{1}] ", (String)null, (Throwable)null, (Object)OracleEnvironment.COMM_FDS_ENV.getEnvName(), (Object)"0,1");
        this.environ.forEach((k, v) -> {
            assert (!k.equalsIgnoreCase(OracleEnvironment.COMM_FDS_ENV.getEnvName())) : "overwriting COMM_FDS_ENV is not allowed";
            CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "start", "{0} defined as [{1}] ", (String)null, (Throwable)null, k, v);
            pb.environment().put((String)k, (String)v);
        });
        try {
            this.serverProcess = pb.start();
        }
        catch (IOException e) {
            CommonDiagnosable.getInstance().debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "start", "new server process cannot be started", null, e);
            throw e;
        }
        if (!this.serverProcess.isAlive()) {
            CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "start", "new server process error: {0}", (String)null, (Throwable)null, (Object)new BufferedReader(new InputStreamReader(this.serverProcess.getErrorStream(), StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n")));
            throw new IOException("new server process did not start code=" + this.serverProcess.exitValue());
        }
        CommonDiagnosable.getInstance().debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "start", "new server process started", null, null);
    }

    private long getProcessPid() throws UnsupportedOperationException {
        Long pid;
        try {
            Method getPid = Process.class.getMethod("pid", new Class[0]);
            pid = (Long)getPid.invoke((Object)this.serverProcess, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new UnsupportedOperationException(e);
        }
        return pid;
    }

    public void stop() throws IOException {
        if (this.serverProcess == null) {
            throw new IllegalStateException("server process not started");
        }
        this.serverProcess.getInputStream().close();
        try {
            if (!this.serverProcess.waitFor(5L, TimeUnit.SECONDS)) {
                CommonDiagnosable.getInstance().debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "stop", "server process did not stop on time", null, null);
                this.serverProcess.destroy();
                if (this.serverProcess.isAlive()) {
                    CommonDiagnosable.getInstance().debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "stop", "had to forcibly kill the server process", null, null);
                    this.serverProcess.destroyForcibly();
                }
            }
            this.serverProcess = null;
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public void terminate() {
        if (this.serverProcess == null) {
            throw new IllegalStateException("server process not started");
        }
        this.serverProcess.destroyForcibly();
        this.serverProcess = null;
    }

    public void sendInterrupt() throws IOException {
        try {
            SignalSender sender = new SignalSender(this.getProcessPid());
            sender.send(SignalSender.SIGNAME.SIGURG);
        }
        catch (IOException e) {
            CommonDiagnosable.getInstance().debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "sendInterrupt", "Error while interrupting wrapper process", null, e);
            throw new IOException("Failed to interrupt server process", e);
        }
    }

    private class AutoFlushPipedOutputStream
    extends OutputStream {
        private OutputStream stream;

        public AutoFlushPipedOutputStream(OutputStream s) {
            this.stream = s;
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        public void write(byte b) throws IOException {
            this.stream.write(b);
            this.stream.flush();
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.stream.write(b, off, len);
            try {
                this.stream.flush();
            }
            catch (IOException e) {
                CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "write", "Error while flushing the stream", null, e);
            }
        }

        @Override
        public void flush() throws IOException {
            this.stream.flush();
        }

        @Override
        public void close() throws IOException {
            this.stream.close();
        }

        public int hashCode() {
            return this.stream.hashCode();
        }

        @Override
        public void write(int b) throws IOException {
            this.stream.write(b);
        }
    }
}

