/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.sqlpgq;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import oracle.pg.rdbms.sqlpgq.SqlPgqBuilder;
import oracle.pgx.graphviz.formatter.EnhancedResultSet;
import oracle.pgx.graphviz.formatter.Graph;
import oracle.pgx.graphviz.formatter.Table;

class SqlPgqEnhancedResultSet
implements EnhancedResultSet {
    private static final String DEFAULT_START = "0";
    private static final String DEFAULT_SIZE = "100";
    private final SqlPgqBuilder builder;
    private Map<String, Object> properties;

    public SqlPgqEnhancedResultSet(String query, Connection conn, Map<String, Object> properties) throws SQLException {
        this.properties = properties;
        this.builder = new SqlPgqBuilder(query, conn);
        this.builder.build();
    }

    public String getValueOrDefault(String value, String defaultValue) {
        return value != null ? value : defaultValue;
    }

    @Nullable
    public Graph createGraphRepresentation(int start, int size) {
        return this.builder.getGraph();
    }

    @Nonnull
    public Table createTableRepresentation() {
        return this.builder.getTable();
    }

    @Nullable
    public Graph createGraphRepresentation() {
        int start = Integer.parseInt(this.getValueOrDefault((String)this.properties.get("START"), DEFAULT_START));
        int size = Integer.parseInt(this.getValueOrDefault((String)this.properties.get("SIZE"), DEFAULT_SIZE));
        return this.createGraphRepresentation(start, size);
    }

    @Nonnull
    public String getGraphName() {
        return this.builder.getGraphName();
    }

    @Nonnull
    public String getGraphSchemaName() {
        return this.builder.getGraphSchemaName();
    }

    public boolean hasGraph() {
        return this.builder.isVisualizable();
    }

    public long getNumResults() {
        return this.builder.getSize();
    }

    public String getResultSetId() {
        return UUID.randomUUID().toString().substring(0, 20);
    }
}

