/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import oracle.pg.rdbms.RdbmsDriver;
import oracle.pg.rdbms.pgql.PgqlConnection;
import oracle.pg.rdbms.pgql.PgqlResultSet;
import oracle.pg.rdbms.pgql.PgqlStatement;
import oracle.pg.rdbms.pgql.pgview.PgViewInformation;
import oracle.pg.rdbms.pgql.pgview.PgViewMetadataInformation;
import oracle.pgql.lang.PgqlException;
import oracle.pgql.lang.ResultSet;
import oracle.pgx.graphviz.driver.CursorWrapper;
import oracle.pgx.graphviz.driver.GraphInformation;
import oracle.pgx.graphviz.driver.GraphName;
import oracle.pgx.graphviz.driver.ResultSetCache;
import oracle.pgx.graphviz.formatter.EnhancedResultSet;
import oracle.pgx.graphviz.formatter.Pair;
import oracle.pgx.graphviz.library.enhancer.Enhancement;
import oracle.pgx.graphviz.library.enhancer.Enhancer;

public class PgqlDriver
extends RdbmsDriver {
    static final int DEFAULT_TIMEOUT = 0;
    static final int DEFAULT_PARALLEL = 0;
    static final int DEFAULT_DS = 2;
    static final int DEFAULT_MAX_RESULTS = -1;

    public PgqlDriver(Map<String, Object> properties) throws SQLException {
        super(properties);
    }

    @Nonnull
    public EnhancedResultSet query(String pgqlQuery, String graphName, @Nullable String schema, Map<String, Object> properties) throws PgqlException, SQLException {
        DataSource ods = (DataSource)properties.get("datasource");
        try (Connection conn = ods.getConnection();){
            EnhancedResultSet enhancedResultSet;
            block14: {
                if (schema == null) {
                    schema = conn.getSchema();
                    LOG.debug("Setting schema name from connection {}", (Object)schema);
                }
                conn.setAutoCommit(false);
                PgqlConnection pgqlConnection = PgqlConnection.getConnection((Connection)conn);
                String threadsPerTaskString = (String)properties.get("parallelism");
                int threadsPerTask = threadsPerTaskString == null ? 0 : Integer.parseInt(threadsPerTaskString);
                String timeoutString = (String)properties.get("timeout");
                int timeout = timeoutString == null ? 0 : Integer.parseInt(timeoutString);
                String dynamicSamplingString = (String)properties.get("dynamic-sampling");
                int dynamicSampling = dynamicSamplingString == null ? 2 : Integer.parseInt(dynamicSamplingString);
                PgqlStatement pgqlStatement = pgqlConnection.createStatement();
                try {
                    Enhancer enhancer = (Enhancer)properties.get("enhancer");
                    Pair canViz = enhancer.checkIfVisualizable();
                    List header = enhancer.getOriginalHeader();
                    properties.put("original_header", header);
                    if (((Boolean)canViz.getFirst()).booleanValue()) {
                        Enhancement enhancement = enhancer.enhance();
                        properties.put("enhancement", enhancement);
                        pgqlQuery = "/*ALLOW_REFERENCING_ANY_PROPERTY*/ " + enhancement.getQuery().toString();
                    }
                    String options = (String)properties.getOrDefault("options", "");
                    PgqlResultSet resultSet = pgqlStatement.executeQuery((String)pgqlQuery, timeout, threadsPerTask, dynamicSampling, -1, options);
                    ResultSetCache rsCache = new ResultSetCache((ResultSet)resultSet, conn);
                    enhancedResultSet = super.getEnhancedResultSet((ResultSet)rsCache, schema, graphName, ((Boolean)canViz.getFirst()).booleanValue(), this.isDirectedSupported(), this.supportsMultipleIterations(), properties);
                    if (pgqlStatement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (pgqlStatement != null) {
                        try {
                            pgqlStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                pgqlStatement.close();
            }
            return enhancedResultSet;
        }
    }

    public String modify(@Nonnull String pgqlQuery, String graphName, Map<String, Object> properties) throws PgqlException, SQLException {
        long modifyCount = this.executePgqlQuery(pgqlQuery, properties);
        return String.format("Success: %s row(s) affected", modifyCount);
    }

    public String create(@Nonnull String pgqlQuery, Map<String, Object> properties) throws PgqlException, SQLException {
        this.executePgqlQuery(pgqlQuery, properties);
        return "Graph successfully created";
    }

    public String drop(@Nonnull String pgqlQuery, Map<String, Object> properties) throws PgqlException, SQLException {
        this.executePgqlQuery(pgqlQuery, properties);
        return "Graph successfully dropped";
    }

    private long executePgqlQuery(String pgqlQuery, Map<String, Object> properties) throws SQLException, PgqlException {
        DataSource ods = (DataSource)properties.get("datasource");
        try (Connection conn = ods.getConnection();){
            long l;
            block12: {
                conn.setAutoCommit(false);
                PgqlConnection pgqlConnection = PgqlConnection.getConnection((Connection)conn);
                PgqlStatement pgqlStatement = pgqlConnection.createStatement();
                try {
                    pgqlStatement.execute(pgqlQuery);
                    l = pgqlStatement.getModifyCount();
                    if (pgqlStatement == null) break block12;
                }
                catch (Throwable throwable) {
                    if (pgqlStatement != null) {
                        try {
                            pgqlStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                pgqlStatement.close();
            }
            return l;
        }
    }

    public Collection<GraphName> getGraphs(Map<String, Object> properties) throws SQLException, PgqlException {
        DataSource ods = (DataSource)properties.get("datasource");
        try (Connection conn = ods.getConnection();){
            conn.setAutoCommit(false);
            Set<GraphName> set = PgViewMetadataInformation.getPgViewNames(conn);
            return set;
        }
    }

    @Nonnull
    public GraphInformation getGraph(@Nullable String schemaName, @Nonnull String graphName, Map<String, Object> properties) throws SQLException, PgqlException {
        DataSource ds = (DataSource)properties.get("datasource");
        try (Connection conn = ds.getConnection();){
            conn.setAutoCommit(false);
            PgViewInformation pgViewInformation = new PgViewInformation(schemaName, graphName, conn);
            return pgViewInformation;
        }
    }

    public boolean supportsMultipleIterations() {
        return false;
    }

    public boolean isDirectedSupported() {
        return false;
    }

    public void close() {
    }

    public CursorWrapper createCursorWrapper(String connectionId, String query, Map<String, Object> properties) throws SQLException {
        throw new UnsupportedOperationException("This operation is only available for SQL property graphs.");
    }

    public Future<CursorWrapper> createCursorWrapperAsync(String connectionId, String query, Map<String, Object> properties) throws SQLException {
        throw new UnsupportedOperationException("This operation is only available for SQL property graphs.");
    }
}

