/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms.attachments;

import jakarta.annotation.Nullable;
import org.spoofax.interpreter.terms.ISimpleTerm;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.terms.attachments.AbstractTermAttachment;
import org.spoofax.terms.attachments.TermAttachmentType;
import org.spoofax.terms.attachments.VolatileTermAttachmentType;

public final class OriginAttachment
extends AbstractTermAttachment {
    private static final long serialVersionUID = 1180953352629370705L;
    public static TermAttachmentType<OriginAttachment> TYPE = new VolatileTermAttachmentType<OriginAttachment>(OriginAttachment.class);
    @Nullable
    private IStrategoTerm origin;

    private OriginAttachment(@Nullable IStrategoTerm origin) {
        this.origin = origin;
    }

    public TermAttachmentType<OriginAttachment> getAttachmentType() {
        return TYPE;
    }

    public static OriginAttachment get(ISimpleTerm term) {
        return term.getAttachment(TYPE);
    }

    @Nullable
    public IStrategoTerm getOrigin() {
        return this.origin;
    }

    public void setOrigin(@Nullable IStrategoTerm origin) {
        this.origin = origin;
    }

    @Nullable
    public static IStrategoTerm getOrigin(ISimpleTerm term) {
        OriginAttachment attachment = term.getAttachment(TYPE);
        return attachment == null ? null : attachment.getOrigin();
    }

    public static IStrategoTerm tryGetOrigin(IStrategoTerm term) {
        OriginAttachment attachment = term.getAttachment(TYPE);
        return attachment == null ? term : attachment.getOrigin();
    }

    public static void setOrigin(ISimpleTerm term, IStrategoTerm origin) {
        term.putAttachment(new OriginAttachment(origin));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.origin == null ? 0 : this.origin.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OriginAttachment other = (OriginAttachment)obj;
        if (this.origin == null) {
            return other.origin == null;
        }
        if (this.origin == other.origin) {
            return true;
        }
        return this.origin.equals(other.origin);
    }

    public String toString() {
        return "" + this.origin;
    }
}

