/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2.parseforest.hybrid;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.metaborg.parsetable.productions.IProduction;
import org.spoofax.jsglr2.parseforest.IParseNode;
import org.spoofax.jsglr2.parseforest.hybrid.HybridDerivation;
import org.spoofax.jsglr2.parseforest.hybrid.HybridParseForest;
import org.spoofax.jsglr2.util.iterators.SingleElementWithListIterable;

public class HybridParseNode
extends HybridParseForest
implements IParseNode<HybridParseForest, HybridDerivation> {
    private final int width;
    private final IProduction production;
    private HybridDerivation firstDerivation;
    private List<HybridDerivation> otherDerivations;

    public HybridParseNode(int width, IProduction production, HybridDerivation firstDerivation) {
        this.width = width;
        this.production = production;
        this.firstDerivation = firstDerivation;
        this.otherDerivations = null;
    }

    public HybridParseNode(int width, IProduction production) {
        this(width, production, null);
    }

    @Override
    public int width() {
        return this.width;
    }

    @Override
    public IProduction production() {
        return this.production;
    }

    @Override
    public void addDerivation(HybridDerivation derivation) {
        if (this.otherDerivations == null) {
            this.otherDerivations = new ArrayList<HybridDerivation>();
        }
        this.otherDerivations.add(derivation);
    }

    @Override
    public boolean hasDerivations() {
        return this.firstDerivation != null;
    }

    @Override
    public Iterable<HybridDerivation> getDerivations() {
        if (this.firstDerivation == null) {
            return Collections.emptyList();
        }
        if (this.otherDerivations == null) {
            return Collections.singleton(this.firstDerivation);
        }
        return SingleElementWithListIterable.of(this.firstDerivation, this.otherDerivations);
    }

    @Override
    public HybridDerivation getFirstDerivation() {
        if (this.firstDerivation == null) {
            throw new UnsupportedOperationException("Cannot get derivation of skipped parse node");
        }
        return this.firstDerivation;
    }

    @Override
    public boolean isAmbiguous() {
        return this.otherDerivations != null;
    }

    @Override
    public void disambiguate(HybridDerivation derivation) {
        this.firstDerivation = derivation;
        this.otherDerivations = null;
    }
}

